// Define an ENUM for status
export enum TransactionType {
  DEPOSIT = 'Deposit',
  WITHDRAWAL = 'Withdrawal',
  TICKET_PURCHASE = 'Ticket Purchase',
  PERFORMANCE_FEE = 'Performance Fee',
  TICKET_COMMISSION = 'Ticket Commission',
  PERFORMANCE_COMMISSION = 'Performance Commission',
  REFUND = 'Refund',
}

export enum EventStatus {
  PENDING = 'Pending',
  WAITING_FOR_ENTERTAINER = 'Waiting for Entertainer',
  PENDING_PAYMENT = 'Pending Payment',
  REJECTED = 'Rejected',
  CANCELED = 'Canceled',
  APPROVED = 'Approved',
  LIVE = 'Live',
  ENDED = 'Ended',
}

export enum PaymentMethodTransactionType {
  DEPOSIT = 'Deposit',
  WITHDRAWAL = 'Withdrawal',
  WALLET = 'Wallet',
}

export enum PaymentMethodType {
  DEPOSIT = 'Deposit',
  WITHDRAWAL = 'Withdrawal',
  WALLET = 'Wallet',
}

export enum EscrowStatus {
  INITIATED = 'Initiated',
  ON_HOLD = 'On-Hold',
  RELEASED = 'Released',
  REVERSED = 'Reversed',
}

export enum GigStatus {
  PENDING = 'Pending',
  ACCEPTED = 'Accepted',
  REJECTED = 'Rejected',
  CANCELED = 'Cancelled',
  FULFILLED = 'Fulfilled',
}

export enum RefundStatus {
  PENDING = 'Pending',
  PROCESSED = 'Processed',
  FAILED = 'Failed',
}

export enum TransactionStatus {
  PENDING = 'Pending',
  IN_ESCROW = 'In-Escrow',
  COMPLETED = 'Completed',
  FAILED = 'Failed',
  REFUNDED = 'Refunded',
}
// Define an ENUM for status
export enum Currency {
  USD = 'USD',
  BHD = 'BHD',
}

export enum NotificationType {
  PROFILE = 'Profile',
  EVENT = 'Event',
  PAYMENT_RELEASE = 'Payment Release',
  PAYMENT_REFUND = 'Payment Refund',
  DISPUTE = 'Dispute',
}

export enum UserRole {
  ENTERTAINER = 'Entertainer',
  ADMIN = 'Admin',
  GUEST = 'Guest', // Attendee
  ORGANIZER = 'Organizer', // Business
  BUSINESS = 'Business',
}

export enum DisputeStatus {
  OPEN = 'Open',
  IN_REVIEW = 'In Review',
  RESOLVED = 'Resolved',
  REJECTED = 'Rejected',
}

export enum DisputeReasons {
  NO_SHOW = 'No Show',
  LATE = 'Late',
  CANCELLED = 'Cancelled',
  OTHER = 'Other',
  PAYMENT_DID_NOT_RECEIVE = 'Payment did not receive',
  SERVICE_NOT_DELIVERED = 'Service not delivered',
}

export enum DisputeResolveAction {
  REJECT = 'Reject',
  REFUND = 'Refund',
}

export enum DisputeResolution {
  UNRESOLVED = 'Unresolved',
  REJECTED = 'Rejected Request',
  REFUNDED = 'Refunded To Requester',
}
