import store from '../../redux';

const currentLanguage =
  store.getState()?.userInfo?.preferences?.language ?? 'en';

export const paginationInfoValue = {
  rowPerPage: '10',
  totalRecords: 0,
  totalPages: 0,
  currentPage: 1,
};

// Initial state for notification
export const initialNotification = {
  isSuccess: true, // Indicates whether the operation was successful
  isEnable: false, // Indicates whether the notification is active
  title: '', // Title of the notification
  message: '', // Message of the notification
};

export const AMOUNT_LIMIT_OPTIONS =
  currentLanguage === 'en'
    ? [
        { label: 'Amount Limit 1 - 10', value: '10' },
        { label: 'Amount Limit 10 - 20', value: '20' },
        { label: 'Amount Limit 20 - 30', value: '30' },
        { label: 'Amount Limit 30+', value: '40' },
      ]
    : [
        { label: 'الحد الأعلى للمبلغ 1 - 10', value: '10' },
        { label: 'الحد الأعلى للمبلغ 10 - 20', value: '20' },
        { label: 'الحد الأعلى للمبلغ 20 - 30', value: '30' },
        { label: 'الحد الأعلى للمبلغ 30+', value: '40' },
      ];

export const SORT_OPTIONS =
  currentLanguage === 'en'
    ? [
        { label: 'Sort By A to Z', value: 'ASC' },
        { label: 'Sort By Z to A', value: 'DESC' },
      ]
    : [
        { label: 'ترتيب من أ إلى ي', value: 'ASC' },
        { label: 'ترتيب من ي إلى أ', value: 'DESC' },
      ];

export const AMOUNT =
  currentLanguage === 'en'
    ? [
        { label: 'Amount Limit 1 - 10', value: '10' },
        { label: 'Amount Limit 10 - 30', value: '30' },
        { label: 'Amount Limit 30 - 50', value: '50' },
        { label: 'Amount Limit 50+', value: '1000' },
      ]
    : [
        { label: 'الحد الأعلى للمبلغ 1 - 10', value: '10' },
        { label: 'الحد الأعلى للمبلغ 10 - 30', value: '30' },
        { label: 'الحد الأعلى للمبلغ 30 - 50', value: '50' },
        { label: 'الحد الأعلى للمبلغ 50+', value: '1000' },
      ];
