import { PasswordInputStylesNames } from '@mantine/core';

export const inputStyle = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans', // Updated font family
    position: 'absolute',
    top: '-14px',
    left: '18px',
    backgroundColor: '#3B1E6D',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '60.84px',
    paddingLeft: '60px',
    paddingRight: '40px',
    width: '100%',
    fontFamily: 'Product Sans', // Updated font family
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
    marginBottom: '16px',
  },
};

export const inputStyle1: Partial<
  Record<PasswordInputStylesNames, React.CSSProperties>
> = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans',
    position: 'absolute',
    top: '-14px',
    left: '18px',
    backgroundColor: '#3B1E6D',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '60.84px',
    paddingLeft: '40px',
    width: '100%',
    fontFamily: 'Product Sans', // Updated font family
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
  },
};
export const inputStyle2: Partial<
  Record<PasswordInputStylesNames, React.CSSProperties>
> = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans', // Updated font family
    position: 'absolute',
    top: '0px',
    left: '30px',
    backgroundColor: '#452975',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '54.84px',
    paddingLeft: '22px',
    width: '100%',
    fontSize: '16px',
    fontFamily: 'Product Sans', // Updated font family
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
  },
};

export const inputStyle3: Partial<
  Record<PasswordInputStylesNames, React.CSSProperties>
> = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans', // Updated font family
    position: 'absolute',
    top: '0px',
    left: '30px',
    backgroundColor: '#452975',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '94.84px',
    paddingLeft: '22px',
    width: '100%',
    fontSize: '16px',
    paddingTop: '20px',
    fontFamily: 'Product Sans', // Updated font family
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
  },
};

export const inputStyle4: Partial<
  Record<PasswordInputStylesNames, React.CSSProperties>
> = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans',
    position: 'absolute',
    top: '0px',
    left: '30px',
    // backgroundColor: '#653dab',
    // backgroundColor: '#673faa',
    backgroundColor: 'rgba(103, 63, 170, 0.4)',
    backdropFilter: 'blur(3px)',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '50.84px',
    paddingLeft: '22px',
    width: '100%',
    fontSize: '14px',
    fontWeight: 'normal',
    fontFamily: 'Product Sans',
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
  },
};

export const inputStyle5: Partial<
  Record<PasswordInputStylesNames, React.CSSProperties>
> = {
  label: {
    fontWeight: '400',
    fontSize: '16px',
    color: '#ffffff',
    marginBottom: '0',
    fontFamily: 'Product Sans', // Updated font family
    position: 'absolute',
    top: '0px',
    left: '30px',
    backgroundColor: '#6534BA',
    padding: '0 8px',
    zIndex: 1,
  },
  input: {
    backgroundColor: 'transparent',
    color: '#ffffff',
    border: '1px solid #ffffff',
    height: '50.84px',
    width: '100%',
    fontSize: '14px',
    fontWeight: 'normal',
    fontFamily: 'Product Sans', // Updated font family
  },
  root: {
    position: 'relative',
    maxWidth: '100%',
  },
};

export const textAreaStyle = {
  input: {
    backgroundColor: 'transparent',
    border: '1px solid #c3c7ec !important',
    radius: '10px',
    color: '#ffffff',
    height: '48px',
  },
};

export const settingStyle = {
  label: {
    fontWeight: 'bold',
    fontSize: '12px',
    fontFamily: 'Product Sans',
    color: '#ffffff',
    marginBottom: '8px',
  },
  input: {
    backgroundColor: 'rgba(255, 255, 255, 0.05)',
    border: '1px solid rgba(255, 255, 255, 0.1) !important',
    borderRadius: '10px',
    height: '48px',
    color: '#ffffff',
  },
};

export const filterStyle = {
  label: {
    fontWeight: 'normal',
    fontSize: '12px',
    color: '#ffffff',
    marginBottom: '4px',
  },
  input: {
    backgroundColor: 'transparent',
    radius: '10px',
    color: '#ffffff',
    height: '48px',
  },
};

export const fileInputStyle: Partial<
  Record<'input' | 'placeholder', React.CSSProperties>
> = {
  input: {
    backgroundColor: '#D83F87',
    borderRadius: '10px',
    color: '#ffffff',
    height: '200px',
    textAlign: 'center',
    lineHeight: '150px', // Ensures vertical centering
    border: 'none',
  },
  placeholder: {
    color: '#ffffff',
    opacity: 1,
    fontSize: '20px',
    fontWeight: 'normal',
  },
};
