import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Voucher from '../../pages/voucher/voucher';
const Loading = () => <SkeletonCard />;
export const voucherRoutes = [
  {
    path: '/voucher',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Voucher" />
              <Voucher />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
