import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Users from '../../pages/users/users';
import EntertainerProfile from '../../pages/users/entertainer';
import BussinessProfile from '../../pages/users/bussiness';
import UserProfile from '../../pages/users/userProfile';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const userRoutes = [
  {
    path: '/user',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="User" />
              <Users />
              {/* <BussinessProfile /> */}
              {/* <EntertainerProfile /> */}
              {/* <UserProfile /> */}
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'business/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Bussiness" />
              <BussinessProfile />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'entertainer/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Entertainer" />
              <EntertainerProfile />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'customer/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Customer" />
              <UserProfile />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
