import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Tickets from '../../pages/sales/ticket';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const ticketRoutes = [
  {
    path: '/tickets',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Tickets" />
              <Tickets isTicket />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
