import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';

import EventSummary from '../../pages/events/event-summary';
import SystemSettings from '../../pages/system-settings/system-settings';
import SystemUser from '../../pages/system-user/add-user';
import ViewSystemUser from '../../pages/system-user/view-user.page';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const systemUserRoutes = [
  {
    path: '/systemUser',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="System-User" />

              <ViewSystemUser />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'add',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="System User - Add-User" />
              <SystemUser />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
