import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';

import EventSummary from '../../pages/events/event-summary';
import SystemSettings from '../../pages/system-settings/system-settings';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const settingRoutes = [
  {
    path: '/systemSettings',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="System-Settings" />
              <SystemSettings />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
