import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Dashboard from '../../pages/dashboard/entertainer-dashboard';
import BusinessDashboard from '../../pages/dashboard/business-dashboard';
import AdminDashboard from '../../pages/dashboard/admin-dashboard';
import Sales from '../../pages/sales/sales';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const salesRoutes = [
  {
    path: '/sales',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Sale" />
              <Sales />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
