import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Voucher from '../../pages/voucher/voucher';
import Reporting from '../../pages/reporting/reporting&analytics';
import ReportingBussiness from '../../pages/reporting/reporting&analytics-bussiness';
import ReportingAdmin from '../../pages/reporting/reporting&analytics-admin';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const reportingRoutes = [
  {
    path: '/reporting',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Reporting and Analytics" />
              <Reporting />
              {/* <ReportingAdmin /> */}
              {/* <ReportingBussiness /> */}
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
