import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';

import EventSummary from '../../pages/events/event-summary';
import SystemSettings from '../../pages/system-settings/system-settings';
import RefundDisputes from '../../pages/refund-disputes/refund-disputes';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const refundRoutes = [
  {
    path: '/refundDispute',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Refund-Disputes" />
              <RefundDisputes />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
