import { DocumentTitle } from '../../components/title';
import { LoginPage } from '../../pages/authentication/login.page';
import { BusinessSignupPage } from '../../pages/authentication/BusinessSignup.page';
import { ErrorPage } from '../../pages/error';
import { PublicRoute } from '../private';
import { EntertainerSignupPage } from '../../pages/authentication/EntertainerSignup.page';
import { ForgotPassword } from '../../pages/authentication/request-forgot.page';
import { PasswordResetPage } from '../../pages/authentication/reset-password.page';
import PublicTicketPage from '../../pages/ticket/ticket-view.page';

export const publicRoutes = [
  {
    path: '/',
    basename: '/',
    element: (
      <PublicRoute>
        <DocumentTitle title="Login" />
        <LoginPage />
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },
  {
    path: '/forgot-password',
    element: (
      <PublicRoute>
        <DocumentTitle title="Forgot Password" />
        <ForgotPassword />
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },
  {
    path: '/reset-password',
    element: (
      <PublicRoute>
        <DocumentTitle title="Reset Password" />
        <PasswordResetPage />
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },

  {
    path: '/business-register',
    element: (
      <PublicRoute>
        <DocumentTitle title="Sign Up" />
        <BusinessSignupPage />
        {/* <EntertainerSignupPage /> */}
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },
  {
    path: '/entertainer-register-page',
    element: (
      <PublicRoute>
        <DocumentTitle title="Sign Up" />

        <EntertainerSignupPage />
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },
  {
    path: '/view-ticket-info/:bookingCode',
    element: (
      <PublicRoute>
        <DocumentTitle title="Ticket Information" />
        <PublicTicketPage />
      </PublicRoute>
    ),
    errorElement: <ErrorPage />,
  },
];
