import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import MyCalendar from '../../pages/calendar/calendar';
import MyProfile from '../../pages/profile/profile';
import MyProfileBussiness from '../../pages/profile/bussiness-profile';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const profileRoutes = [
  {
    path: '/profile',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Profile" />
              <MyProfile />
              {/* <MyProfileBussiness /> */}
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
