import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import PaymentWithdrawal from '../../pages/payments/withdrawl';
import PaymentWalletEntertainer from '../../pages/payments/payments-wallet-entertainer';
import PaymentWalletBusiness from '../../pages/payments/payments-wallet-bussiness';
import PaymentWalletAdmin from '../../pages/payments/payment-wallet-admin';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const paymentRoutes = [
  {
    path: '/payment',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Payments and Wallet" />
              <PaymentWalletEntertainer />
              {/* <PaymentWalletBussiness /> */}
              {/* <PaymentWalletAdmin />/ */}
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'withdrawal',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Withdrawal" />
              <PaymentWithdrawal />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
