import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';

import UpcomingEvents from '../../pages/events/upcoming-events';
import UpcomingEventsDetail from '../../pages/events/event-details';
import AddEntertainer from '../../pages/events/add-entertainers';
import EntertainerProfile from '../../pages/events/entertainer-profile';
import CreateEvent from '../../pages/events/create-event';
import EventSummary from '../../pages/events/event-summary';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const eventsRoutes = [
  {
    path: '/upcomingEvents',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Upcoming Events" />
              <UpcomingEvents />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'view-details/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="UpcomingEvents - View-Details" />
              <UpcomingEventsDetail />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: ':id/add-entertainer',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Events - Add-Entertainer" />
              <AddEntertainer />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: ':eventid/entertainer-profile/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Events - Entertainer-Profile" />
              <EntertainerProfile />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'create-event',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Events - Create-Event" />
              <CreateEvent />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'Search-Entertainer',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Search Entertainer" />
              <AddEntertainer />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'Event-Summary',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Event Summary" />
              <EventSummary />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
