import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import Dashboard from '../../pages/dashboard/entertainer-dashboard';
import BusinessDashboard from '../../pages/dashboard/business-dashboard';
import AdminDashboard from '../../pages/dashboard/admin-dashboard';
import Sales from '../../pages/sales/sales';
import Gigs from '../../pages/gigs/gigs';
import EventSummary from '../../pages/events/event-summary';
import AddEntertainer from '../../pages/events/add-entertainers';
import EntertainerProfile from '../../pages/events/entertainer-profile';

const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const entertainerRoutes = [
  {
    path: '/entertainer',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Entertainer" />
              <AddEntertainer />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'entertainer-profile/:id',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Entertainer-Entertainer-Profile" />
              <EntertainerProfile />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
