import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import AdminDashboard from '../../pages/dashboard/admin-dashboard';
import BusinessDashboard from '../../pages/dashboard/business-dashboard';
import DemoDashboard from '../../pages/dashboard/view-dashboard';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';

const Loading = () => <SkeletonCard />;

export const dashboardRoutes = [
  {
    path: '/dashboard',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Dashboard" />
              <DemoDashboard />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'admin',
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Dashboard" />
              <AdminDashboard />
            </Suspense>
          </PrivateRoute>
        ),
      },
      {
        path: 'business',
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Dashboard" />
              <BusinessDashboard />
              <DemoDashboard />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
