import { Suspense } from 'react';
import SkeletonCard from '../../components/skeleton/dashboard-skeleton';
import { DocumentTitle } from '../../components/title';
import { AppShell } from '../../pages/app-layout';
import { ErrorPage } from '../../pages/error';
import PrivateRoute from '../private/private.routes';
import AngelWings from '../../pages/angel-wish/angel-wish';
const Loading = () => (
  <div>
    <SkeletonCard />
  </div>
);
export const angelWishRoutes = [
  {
    path: '/angel-wing',
    element: <AppShell />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: (
          <PrivateRoute>
            <Suspense fallback={<Loading />}>
              <DocumentTitle title="Angel Wings" />
              <AngelWings />
            </Suspense>
          </PrivateRoute>
        ),
      },
    ],
  },
];
