import { publicRoutes } from './route';
import { angelWishRoutes } from './route/angel-wish.routes';
import { calendarRoutes } from './route/calendar.routes';
import { dashboardRoutes } from './route/dashboard.routes';
import { entertainerRoutes } from './route/entertainer.routes';
import { eventsRoutes } from './route/events.routes';
import { gigsRoutes } from './route/gigs.routes';
import { notificationRoutes } from './route/notification.routes';
import { paymentRoutes } from './route/payment.routes';
import { profileRoutes } from './route/profile.routes';
import { refundRoutes } from './route/refund.routes';
import { reportingRoutes } from './route/reporting.routes';
import { salesRoutes } from './route/sales.routes';
import { settingRoutes } from './route/systemSettings.routes';
import { systemUserRoutes } from './route/systemUser.routes';
import { ticketRoutes } from './route/ticket.routes';
import { userRoutes } from './route/users.route';
import { voucherRoutes } from './route/voucher.route';

export function getRoutesAgainstRole(roleId: string | number) {
  if (Number(roleId) === 1) {
    return getRoutesAgainstSystemAdmin();
  } else if (Number(roleId) === 2) {
    return getRoutesAgainstEntertainer();
  } else {
    return getRoutesAgainstBusiness();
  }
}

function getRoutesAgainstSystemAdmin() {
  return [
    ...publicRoutes,
    ...dashboardRoutes,
    ...salesRoutes,
    ...calendarRoutes,
    ...profileRoutes,
    ...angelWishRoutes,
    ...ticketRoutes,
    ...notificationRoutes,
    ...voucherRoutes,
    ...userRoutes,
    ...reportingRoutes,
    ...paymentRoutes,
    ...eventsRoutes,
    ...gigsRoutes,
    ...settingRoutes,
    ...refundRoutes,
    ...systemUserRoutes,
  ];
}
function getRoutesAgainstEntertainer() {
  // Common routes accessible by all roles
  return [
    ...publicRoutes,
    ...dashboardRoutes,
    ...salesRoutes,
    ...calendarRoutes,
    ...profileRoutes,
    ...angelWishRoutes,
    ...ticketRoutes,
    ...notificationRoutes,
    ...voucherRoutes,
    ...userRoutes,
    ...reportingRoutes,
    ...paymentRoutes,
    ...eventsRoutes,
    ...gigsRoutes,
  ];
}

function getRoutesAgainstBusiness() {
  return [
    ...publicRoutes,
    ...dashboardRoutes,
    ...salesRoutes,
    ...calendarRoutes,
    ...profileRoutes,
    ...angelWishRoutes,
    ...ticketRoutes,
    ...notificationRoutes,
    ...voucherRoutes,
    ...entertainerRoutes,
    ...userRoutes,
    ...reportingRoutes,
    ...paymentRoutes,
    ...eventsRoutes,
    ...gigsRoutes,
  ];
}
