import {
  SET_CROP_DATA,
  SET_Location_Data,
  SET_REFERENCE_DATA,
} from '../constants/reference';
import CryptoJS from 'crypto-js';
import { setProcessedSessionStorageData } from '../../utils/common/function';

const decryptMessage = (text: string): string => {
  if (!text) {
    console.error('Text cannot be empty');
    return '';
  }

  try {
    const bytes = CryptoJS.AES.decrypt(
      text,
      process.env.REACT_APP_CRYPTO_KEY ?? 'secret_key'
    );
    const originalText = bytes.toString(CryptoJS.enc.Utf8);

    if (!originalText) {
      console.error('Failed to decrypt. Check the text and key.');
      return '';
    }

    return originalText;
  } catch (err) {
    console.error('Decryption failed:', err);
    return '';
  }
};

const getProcessedSessionStorageData = (key: string): any => {
  const dataString = sessionStorage.getItem(key);

  if (!dataString) return null;

  const isDevelopment =
    process.env.REACT_APP_APPLICATION_PHASE === 'development';

  return isDevelopment
    ? JSON.parse(dataString)
    : JSON.parse(decryptMessage(dataString));
};

const initialState = {
  referenceData: getProcessedSessionStorageData('referenceData'),
};

const referenceReducer = (state = initialState, action: any) => {
  switch (action.type) {
    case SET_REFERENCE_DATA:
      setProcessedSessionStorageData(
        'referenceData',
        action.payload.referenceData
      );

      return {
        ...state,
        referenceData: action.payload.referenceData,
      };

    default:
      return state;
  }
};

export default referenceReducer;
