import { fetchData } from '../../api/api';
import { SET_REFERENCE_DATA } from '../constants/reference';

function setReferenceData(referenceData: any) {
  return {
    type: SET_REFERENCE_DATA,
    payload: {
      referenceData,
    },
  };
}

export const fetchAllData = async (dispatch: any) => {
  try {
    const [referenceData]: [any] = await Promise.all([fetchData('refs')]);
    dispatch(setReferenceData(referenceData));
  } catch (error) {
    console.error('Error fetching data:', error);
  }
};
