import { Button, Grid, Modal } from '@mantine/core';
import { IconMapPin } from '@tabler/icons-react';
import {
  formatDate,
  handleError,
  handleSuccess,
} from '../../utils/common/function';
import { useNavigate } from 'react-router-dom';
import { useSelector } from 'react-redux';
import { getTranslation } from '../../layout/languages';
import { putData } from '../../api/api';
import { useState } from 'react';
import { EventStatus } from '../../utils/common/enums';
const ViewVoucherDetails = ({ opened, setOpened, voucherData }: any) => {
  const navigate = useNavigate();
  const [loading, setLoading] = useState<boolean>(false);
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const today = new Date();
  const from = new Date(voucherData?.validFrom);
  const to = new Date(voucherData?.validTo);
  const isLive = from <= today && today <= to;
  return (
    <Modal
      opened={opened}
      centered
      size="md"
      onClose={() => setOpened(false)}
      withCloseButton={false}
      styles={{
        content: {
          borderRadius: '15px',
          backgroundColor: '#6D3EBD',
          padding: 0,
        },
        body: {
          padding: 0,
        },
        inner: {
          padding: 0,
          margin: 0,
          maxWidth: '100vw',
        },
      }}
      overlayProps={{
        backgroundOpacity: 0.55,
        blur: 3,
      }}
      transitionProps={{ transition: 'fade-up', duration: 300 }}
      title=""
    >
      <div className="relative w-full">
        {voucherData?.image ? (
          <img
            src={voucherData?.image}
            alt="image"
            className="rounded-t-md h-[180px] w-full object-cover"
          />
        ) : (
          <div className="rounded-t-md h-[30px] w-full object-cover"> </div>
        )}
        <Modal.CloseButton
          onClick={() => setOpened(false)}
          style={{
            position: 'absolute',
            top: 10,
            right: 10,
            border: 'none',
            outline: 'none',
            boxShadow: 'none',
            color: '#ffffff',
            backgroundColor: 'transparent', // Ensure initial state is transparent
            transition: 'background-color 0.2s ease-in-out',
            width: 33,
            height: 33,
          }}
        />
      </div>
      <div className="mt-4">
        <div className="flex flex-row justify-between ml-8 mr-6">
          <div className="text-[18px] font-productsans text-[#F4F4FE]">
            {voucherData?.offerName}
          </div>

          <div className="text-[14px] font-productsans text-[#F4F4FE] mt-2">
            {getTranslation(language, 'voucher', 'From Date - To Date')}
          </div>
        </div>
        <div className="flex flex-row justify-between ml-8 mr-6">
          <div className="text-[14px] font-productsans text-[#F4F4FE] flex flex-row justify-start">
            <p>{voucherData?.offerCode || 'N/A'}</p>
          </div>
          <div className="text-[18px] font-productsans text-[#F4F4FE] ml-14">
            {formatDate(voucherData?.validFrom?.substring(0, 10) || '')}-
            {formatDate(voucherData?.validTo?.substring(0, 10) || '')}
          </div>
        </div>
        <div className="bg-[#ffffff] w-auto h-auto bg-opacity-10 rounded-lg mb-3 ml-2 mr-2 ">
          <div
            className={`flex flex-row justify-between mt-4 text-[#ffffff] ml-1 mr-1 text-[13px] font-productsans`}
          >
            <div className="flex flex-col justify-between">
              <p className="mt-3 ml-4 rtl:mr-3 rtl:ml-0">
                {getTranslation(language, 'voucher', 'Dicount Percentage')}
              </p>
              <p className="mb-2 ml-4 rtl:mr-3 rtl:ml-0">
                {voucherData?.discountPercentage} %
              </p>
            </div>
            <div className="border-r-[1px] border-r-caption border-color-light mt-4 mb-3"></div>
            <div className="flex flex-col justify-between">
              <p className="mt-3">
                {getTranslation(language, 'voucher', 'Discount Cap')}
              </p>
              <p className="mb-2">{voucherData?.discountCap}</p>
            </div>
            <div className="border-r-[1px] border-r-caption border-color-light  mt-4 mb-3"></div>
            <div className="flex flex-col justify-between">
              <p className="mt-3 mr-4 rtl:ml-4 rtl:mr-0">
                {getTranslation(language, 'voucher', 'Usage Limit')}
              </p>
              <p className="mr-4 mb-2 rtl:ml-4 rtl:mr-0">
                {voucherData?.usageLimit}
              </p>
            </div>
            <div className="border-r-[1px] border-r-caption border-color-light  mt-4 mb-3"></div>
            <div className="flex flex-col justify-between">
              <p className="mt-3 mr-4 rtl:ml-4 rtl:mr-0">
                {getTranslation(language, 'voucher', 'Status')}
              </p>
              <p className="mr-4 mb-2 rtl:ml-4 rtl:mr-0">
                {isLive ? 'Live' : 'Expired'}
              </p>
            </div>
          </div>
        </div>

        <div className=" text-[14px] px-8 py-3 bg-[#3B1E6D] bg-opacity-30">
          <div className="text-[#ffffff] text-[14px] font-semibold font-productsans mt-3">
            {getTranslation(language, 'voucher', 'Category')}:
          </div>
          <div className="text-[#BBACD7D9] text-[13px] font-productsans mt-1">
            <p>{voucherData?.eventCategory?.name}</p>
          </div>
        </div>
      </div>
    </Modal>
  );
};

export default ViewVoucherDetails;
