import {
  Container,
  Box,
  Text,
  Avatar,
  Group,
  Divider,
  Paper,
  Grid,
  ActionIcon,
  Image,
  Overlay,
} from '@mantine/core';
import {
  IconArrowLeft,
  IconBrandFacebook,
  IconBrandInstagram,
  IconBrandTwitter,
  IconBrandSnapchat,
  IconUserOff,
} from '@tabler/icons-react';
import { Carousel } from '@mantine/carousel';
import '@mantine/carousel/styles.css';
import { RiUserForbidLine } from 'react-icons/ri';
import { useLocation, useNavigate, useParams } from 'react-router-dom';
import fb from '../../assets/images/fb.png';
import insta from '../../assets/images/insta.png';
import X from '../../assets/images/X.png';
import snap from '../../assets/images/snap.png';
import { Key, useEffect, useState } from 'react';
import { fetchData, putData } from '../../api/api';
import { handleError } from '../../utils/common/function';
import { useSelector } from 'react-redux';
const UserProfile = () => {
  const location = useLocation();
  const { id } = useParams();
  // const userData = location.state?.userData;
  const currency = useSelector(
    (state: any) =>
      state.userInfo?.preferences?.currency?.preferredCurrencyId ?? '1'
  );
  const [isLoading, setIsLoading] = useState(false);
  const [userData, setData] = useState<any>();

  const navigate = useNavigate();
  const handleToggleBlock = async (userId: string, currentStatus: boolean) => {
    setIsLoading(true);
    try {
      await putData(`/users/${userId}`, {
        isBlocked: !currentStatus,
      });
    } catch (error) {
      console.error('Failed to update block status:', error);
    } finally {
      setIsLoading(false);
    }
  };

  useEffect(() => {
    if (!id) return;

    setIsLoading(true);

    fetchData(`/users/${id}`)
      .then((response: any) => {
        setData(response);
      })
      .catch((error: any) => {
        handleError(error, 'Failed to fetch user data');
      })
      .finally(() => {
        setIsLoading(false);
      });
  }, [id, currency]);
  return (
    <Container
      size="md"
      style={{
        padding: '20px',
        width: '100%',
        maxWidth: '100%',
        background: 'radial-gradient(#6534BA 43%, #3B1E6D)',
        margin: 0,
        overflowX: 'hidden',
      }}
      className="min-h-screen"
    >
      {/* Back Button & Header */}
      <Group mb="md">
        <ActionIcon
          size="lg"
          color="white"
          radius="xl"
          variant="light"
          onClick={() => navigate('/user')}
        >
          <IconArrowLeft size={20} />
        </ActionIcon>
        <Text
          style={{
            fontSize: '33px',
            color: 'white',
            fontFamily: 'Product Sans',
          }}
        >
          Users &nbsp;
          <Text
            component="span"
            style={{
              fontSize: '33px',
              fontFamily: 'Product Sans',
              color: '#D83F87',
            }}
          >
            &gt; Customer Profile
          </Text>
        </Text>
      </Group>

      {/* Profile Card */}
      <Paper
        style={{
          background: 'radial-gradient(#6534BA 43%, #3B1E6D)',
          padding: '30px',
          paddingBottom: '25%',
          borderRadius: '10px',
          color: 'white',
          border: '1px solid rgba(255, 255, 255, 0.2)',
        }}
      >
        <Grid align="stretch">
          {/* Profile Picture */}
          <Grid.Col
            span={{ base: 12, md: 4 }}
            style={{
              display: 'flex',
              alignItems: 'stretch',
              justifyContent: 'flex-start',
            }}
          >
            <Avatar
              src={userData?.profilePicture}
              radius="md"
              style={{
                width: '100%',
                maxWidth: '500px',
                height: '100%',
                objectFit: 'cover',
              }}
            />
          </Grid.Col>

          {/* Profile Details */}
          <Grid.Col span={{ base: 12, md: 8 }} style={{ paddingLeft: '20px' }}>
            <Group
              justify="space-between"
              style={{ width: '100%' }}
              wrap="nowrap"
            >
              <Box
                style={{ display: 'flex', alignItems: 'center', gap: '10px' }}
              >
                <Text
                  size="xl"
                  style={{ fontFamily: 'Product Sans', fontSize: '26px' }}
                >
                  {userData?.fullNameOrBusinessName
                    ? userData?.fullNameOrBusinessName
                    : 'N/A'}
                </Text>
                <RiUserForbidLine
                  size={25}
                  color="white"
                  title={userData?.isBlocked ? 'Unblock User' : 'Block User'}
                  onClick={() =>
                    handleToggleBlock(userData?.id, userData?.isBlocked)
                  }
                />{' '}
              </Box>

              {/* Social Media Icons */}
              <Group gap="xs">
                {userData?.faceBookLink && (
                  <a
                    href={userData.faceBookLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={fb}
                        alt="fb"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.instagramLink && (
                  <a
                    href={userData.instagramLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={insta}
                        alt="insta"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.xLink && (
                  <a
                    href={userData.xLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={X}
                        alt="X"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.snapChatLink && (
                  <a
                    href={userData.snapChatLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'black' }}
                    >
                      <Image
                        src={snap}
                        alt="snap"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}
              </Group>
            </Group>

            {/* Contact Info */}
            <Group mt="md">
              <Text
                size="md"
                style={{ fontFamily: 'Product Sans', fontSize: '18px' }}
              >
                {userData?.phoneNumber ? userData?.phoneNumber : 'N/A'}{' '}
              </Text>
              <Divider orientation="vertical" color="white" />
              <Text
                size="md"
                style={{ fontFamily: 'Product Sans', fontSize: '18px' }}
              >
                {userData?.email ? userData?.email : 'N/A'}{' '}
              </Text>
              <Divider orientation="vertical" color="white" />
              <Text
                size="md"
                style={{ fontFamily: 'Product Sans', fontSize: '18px' }}
              >
                Password: {userData?.password ? userData?.password : '*****'}
              </Text>
            </Group>

            {/* Additional Info */}
            <Group mt="md">
              <Box>
                <Text
                  style={{
                    color: 'white',
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '21.06px',
                    lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  Customer Type
                </Text>

                <Text
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 300,
                    fontSize: '21.06px',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  {userData?.isActive && !userData?.isBlocked
                    ? 'Active'
                    : 'Inactive'}
                </Text>
              </Box>
              <Divider orientation="vertical" color="white" />
              <Box>
                <Text
                  size="md"
                  style={{
                    color: 'white',
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '21.06px',
                    lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  Total Spend
                </Text>
                <Text
                  size="md"
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 300,
                    fontSize: '21.06px',
                    // lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  {`${currency === '1' ? '$' : 'BHD ≈'} ${userData?.totalSpends || '0'}`}
                </Text>
              </Box>
              <Divider orientation="vertical" color="white" />
              <Box>
                <Text
                  size="md"
                  style={{
                    color: 'white',
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '21.06px',
                    lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  Available Balance
                </Text>
                <Text
                  size="md"
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 300,
                    fontSize: '21.06px',
                    // lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  {`${currency === '1' ? '$' : 'BHD ≈'} ${userData?.availableBalance || '0'}`}
                </Text>
              </Box>
              <Divider orientation="vertical" color="white" />
              <Box>
                <Text
                  size="md"
                  style={{
                    color: 'white',
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '21.06px',
                    lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  Location
                </Text>
                <Text
                  size="md"
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 300,
                    fontSize: '21.06px',
                    // lineHeight: '100%',
                    letterSpacing: '0%',
                    verticalAlign: 'bottom',
                  }}
                >
                  {userData?.address ?? 'N/A'}
                </Text>
              </Box>
            </Group>

            {/* Description */}
            <Box mt="md">
              <Text
                style={{
                  color: '#FFFFFF',
                  fontFamily: 'Product Sans',
                  fontWeight: 400,
                  fontSize: '18px',
                  lineHeight: '30px',
                  letterSpacing: '0%',
                }}
              >
                {userData?.bio ? userData?.bio : 'N/A'}{' '}
              </Text>
            </Box>

            <Box mt="md">
              <Text
                size="xl"
                style={{
                  color: 'white',
                  fontSize: '21px',
                  fontFamily: 'Product Sans',
                }}
              >
                Recent Activities
              </Text>

              {userData?.tickets?.length > 0 ? (
                <Carousel
                  withIndicators
                  height={250}
                  slideSize="33.333%"
                  slideGap="md"
                  loop
                  align="start"
                  mt="md"
                >
                  {userData.tickets.map(
                    (ticket: any, index: Key | null | undefined) => (
                      <Carousel.Slide key={index}>
                        <Box style={{ position: 'relative' }}>
                          <Image
                            src={ticket?.ticket?.event?.eventImage}
                            radius="md"
                          />
                          <Overlay opacity={0.5} color="#000" zIndex={1} />

                          {/* Event Info */}
                          <Box
                            style={{
                              position: 'absolute',
                              bottom: 10,
                              left: 10,
                              right: 10,
                              color: 'white',
                              fontSize: '16px',
                              zIndex: 2,
                              width: 'calc(100% - 20px)',
                              display: 'flex',
                              justifyContent: 'space-between',
                            }}
                          >
                            <Text size="16px">
                              {ticket?.event?.title || 'No Title'}
                            </Text>
                            <Text size="16px">
                              {ticket?.ticketType || 'Ticket'}
                            </Text>
                            <Text size="16px">
                              {ticket?.seats?.length || 0} PCs
                            </Text>
                          </Box>
                        </Box>
                      </Carousel.Slide>
                    )
                  )}
                </Carousel>
              ) : (
                <Text
                  style={{
                    color: 'white',
                    marginTop: '10px',
                    fontFamily: 'Inter',
                    fontSize: '16px',
                  }}
                >
                  No recent activity found.
                </Text>
              )}
            </Box>
          </Grid.Col>
        </Grid>
      </Paper>

      {/* Recent Activities Section */}
    </Container>
  );
};

export default UserProfile;
