import {
  Container,
  Box,
  Text,
  Avatar,
  Group,
  Divider,
  Paper,
  Grid,
  ActionIcon,
  Card,
  Image,
} from '@mantine/core';
import { IconArrowLeft, IconFlame, IconStarFilled } from '@tabler/icons-react';
import '@mantine/carousel/styles.css';
import { Carousel } from '@mantine/carousel';
import { RiUserForbidLine } from 'react-icons/ri';
import { useLocation, useNavigate, useParams } from 'react-router-dom';
import { Key, useEffect, useState } from 'react';
import { FaCalendarDays } from 'react-icons/fa6';
import BasicDateCalendar from '../events/calender';
import fb from '../../assets/images/fb.png';
import insta from '../../assets/images/insta.png';
import X from '../../assets/images/X.png';
import snap from '../../assets/images/snap.png';
import { fetchData, putData } from '../../api/api';
import { handleError } from '../../utils/common/function';
const BussinessProfile = () => {
  const location = useLocation();
  const [isLoading, setIsLoading] = useState(false);
  const { id } = useParams();

  const [userData, setData] = useState<any>({
    businessFeedbacks: [],
  });

  const navigate = useNavigate();
  const handleToggleBlock = async (userId: string, currentStatus: boolean) => {
    setIsLoading(true);
    try {
      await putData(`/users/${userId}`, {
        isBlocked: !currentStatus, // toggle status
      });
    } catch (error) {
      console.error('Failed to update block status:', error);
    } finally {
      setIsLoading(false);
    }
  };

  useEffect(() => {
    if (!id) return;

    setIsLoading(true);

    fetchData(`/users/${id}`)
      .then((response: any) => {
        setData(response);
      })
      .catch((error: any) => {
        handleError(error, 'Failed to fetch user data');
      })
      .finally(() => {
        setIsLoading(false);
      });
  }, [id]);
  return (
    <Container
      size="md"
      style={{
        padding: '20px',
        maxWidth: '100%',
        background: 'radial-gradient(#6534BA 43%, #3B1E6D)',
      }}
      className="min-h-screen"
    >
      {/* Back Button & Header */}
      <Group mb="md">
        <ActionIcon
          size="lg"
          color="white"
          radius="xl"
          variant="light"
          onClick={() => navigate('/user')}
        >
          <IconArrowLeft size={20} />
        </ActionIcon>
        <Text
          style={{
            fontSize: '33px',
            color: 'white',
            fontFamily: 'Product Sans',
          }}
        >
          Users &nbsp;
          <Text
            component="span"
            style={{
              fontSize: '33px',
              fontFamily: 'Product Sans',
              color: '#D83F87',
            }}
          >
            &gt; Business Profile
          </Text>
        </Text>
      </Group>
      {/* Profile Card */}
      <Paper
        style={{
          background: 'radial-gradient(#6534BA 43%, #3B1E6D)',
          padding: '30px',
          borderRadius: '10px',
          color: 'white',
          border: '1px solid rgba(255, 255, 255, 0.2)',
        }}
      >
        <Grid align="stretch" style={{ height: '100%' }} gutter="lg">
          {/* Profile Picture */}
          <Grid.Col
            span={{ base: 12, md: 6 }}
            style={{ display: 'flex', alignItems: 'stretch' }}
          >
            <Avatar
              src={userData?.profilePicture}
              radius={0}
              style={{
                width: '100%',
                height: '100%',
                maxWidth: '731px',
                maxHeight: '598px',
                borderRadius: '9.6px',
                objectFit: 'cover',
              }}
            />
          </Grid.Col>

          {/* Profile Details & Other Info */}
          <Grid.Col span={{ base: 12, md: 6 }}>
            <Group>
              <Box
                style={{ display: 'flex', alignItems: 'center', gap: '10px' }}
              >
                <Text
                  size="xl"
                  style={{ fontFamily: 'Product Sans', fontSize: '26px' }}
                >
                  {userData?.fullNameOrBusinessName
                    ? userData?.fullNameOrBusinessName
                    : 'N/A'}{' '}
                </Text>
                <Box
                  style={{
                    backgroundColor: '#D83F87',
                    padding: '5px 10px',
                    borderRadius: '20px',
                    display: 'flex',
                    alignItems: 'center',
                    gap: '5px',
                  }}
                >
                  <IconStarFilled size={12} color="white" />
                  <Text size="md" style={{ fontSize: '14px', color: 'white' }}>
                    {userData?.rating ? userData?.rating : '-'}{' '}
                  </Text>
                </Box>
                <RiUserForbidLine
                  size={25}
                  color="white"
                  title={userData?.isBlocked ? 'Unblock User' : 'Block User'}
                  onClick={() =>
                    handleToggleBlock(userData?.id, userData?.isBlocked)
                  }
                />
              </Box>

              {/* Social Media Icons */}
              <Group gap="xs" style={{ marginLeft: '150px' }}>
                {userData?.faceBookLink && (
                  <a
                    href={userData.faceBookLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={fb}
                        alt="fb"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.instagramLink && (
                  <a
                    href={userData.instagramLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={insta}
                        alt="insta"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.xLink && (
                  <a
                    href={userData.xLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'white' }}
                    >
                      <Image
                        src={X}
                        alt="X"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}

                {userData?.snapChatLink && (
                  <a
                    href={userData.snapChatLink}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <ActionIcon
                      size={36}
                      radius="sm"
                      style={{ backgroundColor: 'transparent', color: 'black' }}
                    >
                      <Image
                        src={snap}
                        alt="snap"
                        width={20}
                        height={20}
                        style={{
                          backgroundColor: 'transparent',
                          border: 'none',
                        }}
                      />
                    </ActionIcon>
                  </a>
                )}
              </Group>
            </Group>

            <Group mt="md">
              <Text size="18px" className="pt-sans-regular ">
                {userData?.phoneNumber ? userData?.phoneNumber : 'N/A'}
              </Text>
              <Divider orientation="vertical" color="white" />
              <Text size="18px" className="pt-sans-regular ">
                {userData?.email ? userData?.email : 'N/A'}
              </Text>
              <Divider orientation="vertical" color="white" />
              <Text size="18px" className="pt-sans-regular ">
                Password: {userData?.password ? userData?.password : '*******'}
              </Text>
            </Group>
            <Grid className="mt-6">
              <Grid.Col span={{ base: 5, md: 4, lg: 4 }}>
                <Text
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '16px',
                    lineHeight: '20px',
                  }}
                >
                  Business Website
                </Text>
                {userData?.businessWebsite ? (
                  <a
                    href={userData.businessWebsite}
                    target="_blank"
                    rel="noopener noreferrer"
                    style={{
                      fontFamily: 'Inter',
                      fontWeight: 300,
                      fontSize: '14px',
                      lineHeight: '18px',
                      color: '#ffffff',
                      textDecoration: 'underline',
                    }}
                  >
                    {userData.businessWebsite}
                  </a>
                ) : (
                  <Text
                    style={{
                      fontFamily: 'Inter',
                      fontWeight: 300,
                      fontSize: '14px',
                      lineHeight: '18px',
                    }}
                  >
                    N/A
                  </Text>
                )}

                <Divider orientation="vertical" />
              </Grid.Col>

              <Grid.Col
                span={{ base: 1, md: 1, lg: 1 }}
                style={{
                  borderLeft: '1px solid white',
                  marginTop: '10px',
                  height: 28,
                  marginLeft: 35,
                }}
              ></Grid.Col>

              <Grid.Col span={{ base: 6, md: 4, lg: 4 }}>
                <Text
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '16px',
                    lineHeight: '20px',
                  }}
                >
                  GMB Profile
                </Text>
                {userData?.gmbProfile ? (
                  <a
                    href={userData.gmbProfile}
                    target="_blank"
                    rel="noopener noreferrer"
                    style={{
                      fontFamily: 'Inter',
                      fontWeight: 300,
                      fontSize: '14px',
                      lineHeight: '18px',
                      color: '#ffffff',
                      textDecoration: 'underline',
                    }}
                  >
                    {userData.gmbProfile}
                  </a>
                ) : (
                  <Text
                    style={{
                      fontFamily: 'Inter',
                      fontWeight: 300,
                      fontSize: '14px',
                      lineHeight: '18px',
                    }}
                  >
                    N/A
                  </Text>
                )}
                <Divider orientation="vertical" />
              </Grid.Col>
              {/* Location */}
              <Grid.Col span={{ base: 4, md: 4, lg: 4 }}>
                <Text
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 600,
                    fontSize: '16px',
                    lineHeight: '20px',
                  }}
                >
                  Location
                </Text>
                <Text
                  style={{
                    fontFamily: 'Inter',
                    fontWeight: 300,
                    fontSize: '14px',
                    lineHeight: '18px',
                  }}
                >
                  {userData?.address ?? 'N/A'}
                </Text>
              </Grid.Col>
            </Grid>

            <Box mt="md">
              <Text
                color="dimmed"
                style={{
                  fontFamily: 'Product Sans',
                  fontWeight: 400,
                  fontSize: '18px',
                  lineHeight: '30px',
                  letterSpacing: '0%',
                  color: '#FFFFFF',
                }}
              >
                {userData?.bio ? userData?.bio : 'N/A'}
              </Text>
            </Box>

            <Grid>
              <Grid.Col span={{ base: 12, md: 12, lg: 8 }}>
                <div className="flex flex-row justify-between">
                  <div className="text-[#ffffff] font-productsans text-[14px] px-3 py-2 font-semibold flex flex-row justify-normal">
                    <div>
                      <FaCalendarDays size={20} color="#D83F87" />
                    </div>
                    <div className="ml-2 "> Available Date:</div>
                  </div>
                  <div className="text-[#ffffff] font-productsans text-[12px] py-3 font-normal flex flex-row justify-normal">
                    <div className="rounded-full w-3 h-3 bg-[#D83F87] mt-0.5"></div>
                    <p className="px-1.5">Booked</p>
                    <div className="rounded-full w-3 h-3 bg-[#7B7B7B] ml-1 mt-0.5"></div>
                    <p className="px-1.5">Unavailable</p>
                  </div>
                </div>
                <div className="border border-[#ffffff] rounded-lg">
                  <BasicDateCalendar />
                </div>
              </Grid.Col>
            </Grid>
          </Grid.Col>
        </Grid>
      </Paper>
      <Box mt="md">
        <Group
          justify="space-between"
          align="center"
          style={{ flexWrap: 'wrap' }}
        >
          <Text
            style={{
              fontFamily: 'Inter',
              fontWeight: 600,
              fontSize: '21px',
              lineHeight: '100%',
              letterSpacing: '0%',
              verticalAlign: 'bottom',
              color: 'white',
              padding: '10px',
            }}
          >
            Reviews:
          </Text>

          {/* Positive Feedback */}
          <Group align="center" style={{ flexWrap: 'wrap' }}>
            <IconFlame size={24} color="orange" />
            <Text
              style={{
                fontFamily: 'Inter',
                fontWeight: 400,
                fontSize: '21px',
                lineHeight: '100%',
                letterSpacing: '0%',
                verticalAlign: 'bottom',
                color: 'white',
              }}
            >
              {userData.businessFeedbacks?.length || 0} Feedback Received
            </Text>
          </Group>
        </Group>

        {userData.businessFeedbacks?.length ? (
          <Carousel
            slideSize={{ base: '100%', sm: '50%', md: '33%' }}
            slideGap="md"
            align="start"
            loop
            withControls
            withIndicators
          >
            {userData.businessFeedbacks.map(
              (feedback: any, index: Key | null | undefined) => (
                <Carousel.Slide key={index}>
                  <Card
                    style={{
                      background: '#D83F87',
                      padding: '20px',
                      borderRadius: '10px',
                      color: 'white',
                      display: 'flex',
                      flexDirection: 'column',
                      gap: '10px',
                    }}
                  >
                    {/* Review Text */}
                    <Text
                      style={{
                        fontFamily: 'Product Sans',
                        fontWeight: 700,
                        fontSize: '16.34px',
                        lineHeight: '22.87px',
                        letterSpacing: '0%',
                        color: 'white',
                      }}
                    >
                      “{feedback.comment}”
                    </Text>

                    {/* Reviewer Info */}
                    <Group justify="space-between">
                      <Box>
                        <Text
                          size="sm"
                          style={{
                            fontWeight: 'bold',
                            fontFamily: 'Inter',
                            fontSize: '19px',
                          }}
                        >
                          {feedback.business?.fullNameOrBusinessName ||
                            'Unknown Business'}
                        </Text>
                        <Text
                          size="xs"
                          style={{ fontFamily: 'Inter', fontSize: '13px' }}
                        >
                          Event Partner
                        </Text>
                      </Box>

                      {/* Rating */}
                      <Box
                        style={{
                          backgroundColor: '#D83F87',
                          padding: '4px 8px',
                          borderRadius: '20px',
                          display: 'flex',
                          alignItems: 'center',
                          gap: '5px',
                        }}
                      >
                        <Text
                          size="md"
                          style={{
                            fontSize: '22px',
                            fontFamily: 'Product Sans',
                            color: 'white',
                          }}
                        >
                          {feedback.rating}
                        </Text>
                        <IconStarFilled size={18} color="white" />
                      </Box>
                    </Group>
                  </Card>
                </Carousel.Slide>
              )
            )}
          </Carousel>
        ) : (
          <Text
            style={{
              color: '#bbb',
              fontSize: '16px',
              fontFamily: 'Inter',
              marginTop: '10px',
            }}
          >
            No reviews available.
          </Text>
        )}
      </Box>

      {/*protofio Section*/}
      <Box mt="md">
        <Text
          style={{
            fontFamily: 'Inter',
            fontWeight: 600,
            fontSize: '21px',
            lineHeight: '100%',
            letterSpacing: '0%',
            verticalAlign: 'bottom',
            color: 'white',
            marginBottom: '10px',
          }}
        >
          Portfolio:
        </Text>

        {userData.portfolioImages?.length ? (
          <Carousel
            slideSize={{ base: '100%', sm: '50%', md: '33%' }}
            slideGap="md"
            align="start"
            loop
            withControls
            withIndicators
          >
            {userData.portfolioImages.map((imgUrl: string, index: number) => (
              <Carousel.Slide key={index}>
                <Card
                  style={{
                    padding: '0',
                    borderRadius: '10px',
                    overflow: 'hidden',
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                  }}
                >
                  <Image
                    src={imgUrl}
                    alt={`Portfolio Image ${index + 1}`}
                    style={{
                      width: '100%',
                      height: 'auto',
                      objectFit: 'cover',
                    }}
                  />
                </Card>
              </Carousel.Slide>
            ))}
          </Carousel>
        ) : (
          <Text
            style={{
              color: '#bbb',
              fontSize: '16px',
              fontFamily: 'Product Sans',
              marginTop: '10px',
            }}
          >
            No portfolio pictures available or uploaded.
          </Text>
        )}
      </Box>
    </Container>
  );
};

export default BussinessProfile;
