import { Grid, Paper } from '@mantine/core';
import {
  IconCalendar,
  IconChevronDown,
  IconCirclePlus,
} from '@tabler/icons-react';
import img from '../../assets/images/dj-night.png';

import { useEffect, useMemo, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button, Table } from '../../components';
import { filterStyle } from '../../theme/common.style';
import {
  initialNotification,
  paginationInfoValue,
} from '../../utils/common/constant.objects';
import { handlePaginationValue } from '../../utils/common/pagination.Helper';

import { DatePickerInput } from '@mantine/dates';
import { useSelector } from 'react-redux';
import { fetchData, putData } from '../../api/api';
import useScreenSize from '../../hooks/useScreenSize';
import { getTranslation } from '../../layout/languages';
import { DisputeResolveAction, DisputeStatus } from '../../utils/common/enums';
import {
  extractPageInfo,
  formatDate,
  handleError,
  handleSetParams,
  handleSuccess,
  removeEmptyValueFilters,
} from '../../utils/common/function';

const ViewSystemUser = () => {
  const initialPaginationFromQueryParams = () => {
    const rowPerPage =
      searchParams.get('rowPerPage') ?? paginationInfoValue.rowPerPage;
    const currentPage = Number(
      searchParams.get('currentPage') ??
        paginationInfoValue.currentPage?.toString()
    );
    return { ...paginationInfoValue, rowPerPage, currentPage };
  };
  const handlePagination = (actionType: string, value?: any) =>
    handlePaginationValue(
      actionType,
      value,
      searchParams,
      paginationInfo,
      setPaginationInfo,
      setSearchParams
    );
  const [searchParams, setSearchParams] = useSearchParams();
  const [paginationInfo, setPaginationInfo] = useState(
    initialPaginationFromQueryParams()
  );
  const [disputeInfo, setdisputeInfo] = useState({
    isModalOpen: false,
    id: '',
  });
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const { isSmallScreen } = useScreenSize();

  useEffect(() => {
    const newPaginationInfo = initialPaginationFromQueryParams();

    if (JSON.stringify(newPaginationInfo) !== JSON.stringify(paginationInfo)) {
      setPaginationInfo(newPaginationInfo);
    }
  }, [searchParams]);

  /////////////////////////////

  const initialSearchValues = {
    searchValue: '',
    type: '',
    limit: '',
    sort: '',
  };
  const initializeStateFromQueryParams = () => {
    const searchValue =
      searchParams.get('searchValue') ?? initialSearchValues.searchValue;
    const type = searchParams.get('type') ?? initialSearchValues.type;
    const limit = searchParams.get('limit') ?? initialSearchValues.limit;
    const sort = searchParams.get('sort') ?? initialSearchValues.sort;

    return {
      searchValue,
      type,
      limit,
      sort,
    };
  };
  const navigate = useNavigate();
  const [searchValues, setSearchValues] = useState(
    initializeStateFromQueryParams()
  );
  const [isLoading, setIsLoading] = useState(false);

  // State for table data
  const [tableData, setTableData] = useState([]);

  // State for reset button
  const [resetTable, setResetTable] = useState(false);

  const handleFetchDataByFilter = () => {
    setIsLoading(true);

    const baseFilters = [
      {
        field: 'users.roleId',
        operator: 'eq',
        value: '1',
      },
    ];

    const filters = removeEmptyValueFilters(baseFilters);

    const filterObject = JSON.stringify({ filter: filters });
    const queryParams = new URLSearchParams({
      rpp: paginationInfo.rowPerPage.toString(),
      page: (paginationInfo.currentPage === 0
        ? 1
        : paginationInfo.currentPage
      ).toString(),
      filter: filterObject,
    });

    const fetchUrl = `users?${queryParams.toString()}`;

    fetchData(fetchUrl)
      .then((response: any) => {
        if (!response.data || response.data.length === 0) {
          setTableData(response.data);
          if (response.total > 0) {
            setPaginationInfo({
              ...paginationInfo,
              totalRecords: response.total,
            });
          }
        } else {
          setTableData(response.data);
          const getPages = extractPageInfo(response.pages);
          setPaginationInfo({
            ...paginationInfo,
            totalRecords: response.total,
            totalPages: getPages?.totalPages ?? 0,
          });
        }
      })
      .catch(error => {
        handleError(error, 'Failed to fetch table data');
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  const handleSearchButtonClick = () => {
    handleSetParams(
      searchParams,
      searchValues,
      initialSearchValues,
      setSearchParams
    );
    handleFetchDataByFilter();
  };

  // Effect for handling search button click
  useEffect(() => {
    handleSearchButtonClick();
  }, [
    resetTable,
    paginationInfo?.currentPage,
    searchValues.searchValue,
    searchValues.limit,
    searchValues.sort,
  ]);

  // Effect to update state when searchParams change
  useEffect(() => {
    const newSearchValues = initializeStateFromQueryParams();

    if (JSON.stringify(newSearchValues) !== JSON.stringify(searchValues)) {
      setSearchValues(newSearchValues);
    }
  }, [searchParams]);

  //   const setValuesById = (valuesById: Partial<SearchFilter>) => {
  //     setSearchValues(prevFormValues => ({
  //       ...prevFormValues,
  //       ...valuesById, // Merge the new values with the existing state
  //     }));
  //   };
  const handleAddUser = () => {
    navigate('/systemUser/add');
  };
  const columns = useMemo(
    () => [
      {
        header: (
          <div className="flex text-start -ml-2 font-normal font-productsans text-[14px]">
            {getTranslation(language, 'refund', 'ID')}
          </div>
        ),
        accessorKey: 'Id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start -ml-2 ">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject?.displayOrderId}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div
            className={` ${isSmallScreen ? 'flex text-center items-center font-normal ml-3 font-productsans text-[14px]' : 'flex text-center items-center font-normal -ml-4 font-productsans text-[14px]'}`}
          >
            {getTranslation(language, 'setting', 'First Name')}
          </div>
        ),
        accessorKey: 'firstName',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div
              className={` ${
                isSmallScreen ? 'flex text-start ml-3' : 'flex text-start -ml-6'
              }`}
            >
              <p className="text-start  font-productsans font-normal text-[14px]">
                {rowObject?.firstName || 'N/A'}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div
            className={` ${isSmallScreen ? 'flex text-center items-center font-normal ml-3 font-productsans text-[14px]' : 'flex text-center items-center font-normal font-productsans text-[14px]'}`}
          >
            {getTranslation(language, 'setting', 'Last Name')}
          </div>
        ),
        accessorKey: 'lastName',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div
              className={` ${
                isSmallScreen ? 'flex text-start ml-3' : 'flex text-start -ml-3'
              }`}
            >
              <p className="text-start  font-productsans font-normal text-[14px]">
                {rowObject?.lastName || 'N/A'}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-start font-normal font-productsans text-[14px]">
            {getTranslation(language, 'setting', 'Email Address')}
          </div>
        ),
        accessorKey: 'emailAddress',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-0.5">
              <p
                className={` ${isSmallScreen ? 'text-start ml-4 font-productsans font-normal text-[14px]' : 'text-start  font-productsans font-normal text-[14px]'}`}
              >
                {rowObject?.email}
              </p>
            </div>
          );
        },
      },
    ],
    [tableData, language]
  );

  return (
    <>
      <Paper
        // className="flex justify-between items-center p-4 h-full bg-gradient-to-b from-[#3B1E6D] from-0% via-[#6534BA] via-80% to-[#23073f]"
        className="flex justify-between items-center p-4  min-h-screen overflow-x-hidden"
        radius={0}
        style={{
          backgroundColor: '#3B1E6D',
          background: 'radial-gradient( #6534BA 43%, #3B1E6D)',
        }}
      >
        <Grid className="mt-6 mr-7 ">
          <Grid.Col span={{ base: 12, md: 9, lg: 10 }}>
            <div className="ml-4 text-[33px] font-semibold text-[#ffffff] font-productsans">
              {getTranslation(language, 'setting', 'System User')}
            </div>
          </Grid.Col>

          <Grid.Col span={{ base: 12, md: 3, lg: 2 }} className="rtl:-mr-6 ">
            <div className="mb-3">
              <Button
                autoContrast
                size="sm"
                styles={{
                  root: {
                    background: '#D83F87',
                  },
                }}
                style={{
                  height: 48,
                  width: '100%',
                }}
                className="px-2"
                onClick={handleAddUser}
              >
                <div className="font-productsans font-normal text-[15px] text-[#ffffff] flex flex-row justify-start">
                  <IconCirclePlus size={17} />
                  <div className="ml-1 mt-0.5">
                    {getTranslation(language, 'setting', 'Add User')}
                  </div>
                </div>
              </Button>
            </div>
          </Grid.Col>
        </Grid>
        <Grid className="py-5 px-4">
          <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
            <div
              className="rounded-2xl  mr-2 font-semibold text-[#ffffff] p-4 font-productsans h-[100%] bg-transparent bg-[#ffffff] bg-opacity-5 border border-[#623F9D]"
              style={{ height: 'auto' }}
            >
              <div className="mt-4">
                <Table
                  data={tableData}
                  columns={columns}
                  isLoading={isLoading}
                  paginationInfo={paginationInfo}
                  handlePagination={handlePagination}
                />
              </div>
            </div>
          </Grid.Col>
        </Grid>
      </Paper>
    </>
  );
};

export default ViewSystemUser;
