import { Modal } from '@mantine/core';

import { useSelector } from 'react-redux';
import { getTranslation } from '../../layout/languages';

const TicketDetailModal = ({ opened, setOpened, ticketData }: any) => {
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const currency = useSelector(
    (state: any) => state.userInfo?.preferences?.currency?.preferredCurrencyId
  );
  const { referenceData } = useSelector((state: any) => state?.referenceData);
  const ticketList = ticketData?.ticket?.event?.ticketsAndPrices ?? [];

  return (
    <Modal
      opened={opened}
      centered
      size="md"
      onClose={() => setOpened(false)}
      withCloseButton={false}
      styles={{
        content: {
          borderRadius: '15px',
          backgroundColor: '#6D3EBD',
          padding: 0,
        },
        body: {
          padding: 0,
        },
        inner: {
          padding: 0,
          margin: 0,
          maxWidth: '100vw',
        },
      }}
      overlayProps={{
        backgroundOpacity: 0.55,
        blur: 3,
      }}
      transitionProps={{ transition: 'fade-up', duration: 300 }}
      title=""
    >
      <div className="relative w-full">
        <Modal.CloseButton
          onClick={() => setOpened(false)}
          style={{
            position: 'absolute',
            top: 10,
            right: 10,
            border: 'none',
            outline: 'none',
            boxShadow: 'none',
            color: '#ffffff',
            backgroundColor: 'transparent',
            transition: 'background-color 0.2s ease-in-out',
            width: 33,
            height: 33,
          }}
        />
      </div>

      <div className="mt-4 text-white font-productsans px-8 py-4">
        <div className="text-[18px] font-semibold text-[#ffffff]">
          {getTranslation(language, 'event', 'Ticket Details')}:
        </div>

        {ticketList.length > 0 ? (
          ticketList.map((ticket: any, index: number) => {
            const ticketTypeName = ticket.ticketName || 'N/A';

            return (
              <>
                <div
                  key={index}
                  className="text-[#ffffff] text-[13px] font-productsans mt-4 px-4 rounded-md flex flex-row justify-between"
                >
                  <div className="mb-2">
                    <span className="font-semibold">
                      {getTranslation(language, 'event', 'Ticket Type')}:
                    </span>
                  </div>
                  <div className="mb-2">
                    <span className="font-semibold ">
                      {getTranslation(language, 'event', 'Price')}:
                    </span>
                  </div>
                  <div className="mb-2">
                    <span className="font-semibold">
                      {getTranslation(language, 'event', 'Quantity')}:
                    </span>
                  </div>
                </div>
                <div className=" text-[#ffffff] text-[13px] font-productsans px-4 rounded-md flex flex-row justify-between">
                  <div className="mb-2">{ticketTypeName}</div>
                  <div className="mb-2">{`${currency === '1' ? '$' : 'BHD ≈'} ${ticket.price}`}</div>
                  <div className="mb-2 flex items-start justify-start text-start">
                    {ticket.quantity}
                  </div>
                </div>
              </>
            );
          })
        ) : (
          <div className="text-center text-[14px] py-4">
            {getTranslation(language, 'event', 'No Ticket Yet')}
          </div>
        )}
      </div>
    </Modal>
  );
};

export default TicketDetailModal;
