import {
  Button,
  Center,
  Container,
  Divider,
  FileInput,
  Grid,
  Image,
  Loader,
  Modal,
  RingProgress,
  Select,
  Text,
  Textarea,
  TextInput,
  Title,
} from '@mantine/core';
import { useEffect, useRef, useState } from 'react';

import { Dropzone, MIME_TYPES } from '@mantine/dropzone';
import { useFormik } from 'formik';
import { FaArrowLeft, FaCalendarAlt, FaStar, FaUpload } from 'react-icons/fa';
import { useSelector } from 'react-redux';
import { fetchData, putData, uploadFile } from '../../api/api';
import fb from '../../assets/images/fb.png';
import insta from '../../assets/images/insta.png';
import snap from '../../assets/images/snap.png';
import X from '../../assets/images/X.png';
import tiktok from '../../assets/images/tiktok.webp';
import { inputStyle4, inputStyle5 } from '../../theme/common.style';
import {
  cleanObject,
  handleError,
  organizeDropDownData,
} from '../../utils/common/function';
import BasicDateCalendar from '../dashboard/Calendar';
import MyProfileBussiness from './bussiness-profile';
import { IconUser } from '@tabler/icons-react';
import ViewProfileDetails from './profile-progress.modal';
import { PhoneNumber } from 'libphonenumber-js';
interface EntertainerType {
  id: string;
  name: string;
  isActive: boolean;
  createdAt: string;
  updatedAt: string;
}
interface profileCompletion {
  percentage: number;
}
interface UserData {
  firstName: string;
  lastName: string;
  stageName: string;
  email: string;
  dateOfBirth: string;
  gender: string;
  phoneNumber: number;
  fullNameOrBusinessName: string;
  rating: string;
  location: string;
  bio: string;
  entertainerTypeId: string;
  liveLocation: string;
  snapChatLink: string;
  tiktokLink: string;
  instagramLink: string;
  ratePerHour: number;
  xLink: string;
  faceBookLink: string;
  address: string;
  profilePicture: string;
  portfolioPics: string[] | null;
  portfolioImages: string[];
  entertainerType: EntertainerType; // add any other fields you expect
  profileCompletion: profileCompletion;
}
const MyProfile = () => {
  const [profilePic, setProfilePic] = useState<File | null>(null);
  const [portfolioPics, setPortfolioPics] = useState<(File | string)[]>([]);
  const [profileInfo, setprofileInfo] = useState({
    isModalOpen: false,
  });
  const pathRef = useRef<SVGPathElement>(null);
  const [pos, setPos] = useState<{ x: number; y: number }>({ x: 0, y: 0 });
  const userInfo = useSelector((state: any) => state?.userInfo?.userInfo);
  const [userData, setUserData] = useState<UserData | null>(null);
  const [profileData, setprofileData] = useState();
  const [loading, setLoading] = useState<boolean>(false);
  const [uploadingImages, setUploadingImages] = useState<string[]>([]);
  const [viewMoreOpen, setViewMoreOpen] = useState(false);
  const currency = useSelector(
    (state: any) => state.userInfo?.preferences?.currency?.preferredCurrencyId
  );
  const [formSubmitting, setFormSubmitting] = useState(false);
  useEffect(() => {
    const getUserData = async () => {
      try {
        setLoading(true);
        const data = await fetchData<UserData>(`/users/${userInfo?.id}`);
        setUserData(data);
      } catch (error) {
        console.error('Error fetching user data:', error);
      } finally {
        setLoading(false);
      }
    };

    if (userInfo?.id) {
      getUserData();
    }
  }, [userInfo?.id, currency]);

  const { referenceData } = useSelector((state: any) => state?.referenceData);
  const formik = useFormik({
    enableReinitialize: true, // This allows Formik to reinitialize when `initialValues` changes
    initialValues: {
      firstName: userData?.firstName || 'N/A',
      lastName: userData?.lastName || 'N/A',
      stageName: userData?.stageName || 'N/A',
      email: userData?.email || 'N/A',
      phoneNumber: userData?.phoneNumber || 'N/A',
      gender: userData?.gender || 'N/A',
      dateOfBirth: userData?.dateOfBirth || 'N/A',
      fullNameOrBusinessName: userData?.fullNameOrBusinessName || 'N/A',
      rating: userData?.rating || 'N/A',
      ratePerHour: userData?.ratePerHour || '',
      entertainerTypeId: userData?.entertainerTypeId || '',
      address: userData?.address || 'N/A',
      profilePicture: userData?.profilePicture || '',
      portfolioPics: userData?.portfolioPics || [],
      bio: userData?.bio || 'N/A',
      faceBookLink: userData?.faceBookLink || 'N/A',
      instagramLink: userData?.instagramLink || 'N/A',
      tiktokLink: userData?.tiktokLink || 'N/A',
      xLink: userData?.xLink || 'N/A',
      snapChatLink: userData?.snapChatLink || 'N/A',
      roleId: userInfo?.roleId || 'N/A',
    },

    onSubmit: async values => {
      setLoading(true);
      const formData = new FormData();
      formData.append('firstName', values?.firstName);
      formData.append('lastName', values?.lastName);
      formData.append('stageName', values?.stageName);
      formData.append('email', values?.email);
      formData.append('phoneNumber', values?.phoneNumber.toString());
      formData.append('gender', values?.gender);
      formData.append('dateOfBirth', values?.dateOfBirth);
      formData.append('fullNameOrBusinessName', values?.fullNameOrBusinessName);
      formData.append('ratePerHour', values?.ratePerHour.toString());
      formData.append('rating', values?.rating);
      formData.append('entertainerTypeId', values?.entertainerTypeId);
      formData.append('address', values?.address);
      formData.append('bio', values?.bio);
      formData.append('faceBookLink', values?.faceBookLink);
      formData.append('instagramLink', values?.instagramLink);
      formData.append('xLink', values?.xLink);
      formData.append('snapChatLink', values?.snapChatLink);
      formData.append('tiktokLink', values?.tiktokLink);
      formData.append('profilePicture', values.profilePicture ?? 'null');
      formData.append(
        'portfolioPics',
        values.portfolioPics ? JSON.stringify(values.portfolioPics) : 'null'
      );
      formData.append('roleId', userInfo?.roleId);
      setFormSubmitting(true);
      try {
        const cleanedValues = cleanObject({
          ...values,
          ratePerHour: Number(values?.ratePerHour),
          roleId: userInfo.roleId,
          portfolioImages: values?.portfolioPics,
        });

        await putData(`/users/${userInfo?.id}`, cleanedValues);
      } catch (error) {
        console.error('Error updating profile:', error);
      } finally {
        setFormSubmitting(false); // Stop loading in both success/failure
      }
    },
  });

  const percentage: number = userData?.profileCompletion?.percentage ?? 0;
  const displayValue = percentage === 0 ? 2 : percentage;

  const rectWidth = 128;
  const rectHeight = 128;
  const rectRx = 30;

  // total perimeter length
  const perimeter =
    2 * (rectWidth - 2 * rectRx + rectHeight - 2 * rectRx) +
    2 * Math.PI * rectRx;

  // stroke progress
  const progressLength = (perimeter * percentage) / 100;
  useEffect(() => {
    if (pathRef.current) {
      const point = pathRef.current.getPointAtLength(progressLength);
      setPos({ x: point.x, y: point.y });
    }
  }, [progressLength]);
  // pick gradient colors based on percentage
  let gradientStops;
  if (percentage >= 70) {
    gradientStops = (
      <>
        <stop offset="0%" stopColor="#00C853" /> {/* light green */}
        <stop offset="100%" stopColor="#2E7D32" /> {/* dark green */}
      </>
    );
  } else if (percentage >= 40) {
    gradientStops = (
      <>
        <stop offset="0%" stopColor="#FFD600" /> {/* light yellow */}
        <stop offset="100%" stopColor="#F9A825" /> {/* darker yellow */}
      </>
    );
  } else {
    gradientStops = (
      <>
        <stop offset="0%" stopColor="#FF5252" /> {/* light red */}
        <stop offset="100%" stopColor="#B71C1C" /> {/* dark red */}
      </>
    );
  }

  if (Number(userInfo?.roleId) === 3) {
    return <MyProfileBussiness />;
  }
  const handleFileChange = async (file: File | null) => {
    if (!file || !file.type.startsWith('image/')) {
      console.warn('Only image files are allowed.');
      return;
    }

    try {
      const response = await uploadFile<{ url: string }>('file/upload', file);
      if (response?.url) {
        formik.setFieldValue('profilePicture', response.url);
      }
    } catch (error) {
      console.error('Upload failed:', error);
    }
  };
  const handleDrop = async (files: File[]) => {
    const validFiles = files.slice(0, 6 - portfolioPics.length);
    const uploadedUrls: string[] = [];

    for (const file of validFiles) {
      const tempPreview = URL.createObjectURL(file);
      setUploadingImages(prev => [...prev, tempPreview]);
      if (!file.type.startsWith('image/')) continue;
      try {
        const res = await uploadFile<{ url: string }>('file/upload', file);
        if (res?.url) {
          uploadedUrls.push(res.url);
        }
      } catch (err) {
        console.error('Image upload failed:', err);
      } finally {
        setUploadingImages(prev => prev.filter(url => url !== tempPreview));
      }
    }

    const updated = [...portfolioPics, ...uploadedUrls].slice(0, 6);
    setPortfolioPics(updated);
    formik.setFieldValue('portfolioPics', updated);
  };
  const allImages = [
    ...(userData?.portfolioImages || []),
    ...(formik.values.portfolioPics || []),
    ...uploadingImages,
  ].filter((item, index, self) => self.indexOf(item) === index);

  return (
    <>
      <Container
        fluid
        bg="radial-gradient(#6534BA 43%, #3B1E6D)"
        style={{
          padding: '40px 0',
        }}
        className="min-h-screen"
      >
        <Container
          fluid
          style={{
            padding: '0px 50px',
          }}
        >
          <form onSubmit={formik.handleSubmit}>
            <Grid>
              <Grid.Col span={{ base: 12, md: 6, lg: 8 }}>
                {/* Three Grid for Image, Upload & Remove */}
                <Grid>
                  <Grid.Col span={12}>
                    <Title
                      style={{
                        color: 'white',
                        marginBottom: '10px',
                        textAlign: 'left',
                        fontSize: '25px',
                        fontFamily: 'Product Sans',
                      }}
                    >
                      My Profile
                    </Title>
                  </Grid.Col>
                </Grid>

                <Grid className="mb-4">
                  <Grid.Col span={{ base: 12, md: 12, lg: 3 }}>
                    <div
                      style={{
                        position: 'relative',
                        width: 140,
                        height: 140,
                        display: 'flex',
                        alignItems: 'center',
                        justifyContent: 'center',
                      }}
                      onClick={() => {
                        setprofileInfo({
                          isModalOpen: true,
                        });
                      }}
                    >
                      <svg
                        width={150}
                        height={140}
                        style={{
                          position: 'absolute',
                          top: 0,
                          left: 0,
                          zIndex: 10,
                        }}
                      >
                        <defs>
                          <linearGradient
                            id="progress-gradient"
                            x1="0%"
                            y1="0%"
                            x2="100%"
                            y2="0%"
                          >
                            {gradientStops}
                          </linearGradient>
                        </defs>

                        {/* base path */}
                        <path
                          ref={pathRef}
                          id="progressPath"
                          d={`
          M 70 6
          H ${6 + rectRx}
          Q 6 6, 6 ${6 + rectRx}
          V ${134 - rectRx}
          Q 6 134, ${6 + rectRx} 134
          H ${134 - rectRx}
          Q 134 134, 134 ${134 - rectRx}
          V ${6 + rectRx}
          Q 134 6, ${134 - rectRx} 6
          H 70
        `}
                          fill="none"
                          stroke="#E0E0E0"
                          strokeWidth={6}
                        />

                        {/* progress stroke */}
                        <path
                          d={`
          M 70 6
          H ${6 + rectRx}
          Q 6 6, 6 ${6 + rectRx}
          V ${134 - rectRx}
          Q 6 134, ${6 + rectRx} 134
          H ${134 - rectRx}
          Q 134 134, 134 ${134 - rectRx}
          V ${6 + rectRx}
          Q 134 6, ${134 - rectRx} 6
          H 70
        `}
                          fill="none"
                          stroke="url(#progress-gradient)"
                          strokeWidth={6}
                          strokeDasharray={`${progressLength}, ${perimeter}`}
                          strokeLinecap="round"
                        />

                        {/* circle background + text */}
                        {/* circle background + text */}
                        <g transform={`translate(${pos.x}, ${pos.y})`}>
                          {/* grey background circle */}
                          <circle
                            r="16"
                            fill="#E0E0E0"
                            stroke="#999"
                            strokeWidth="2"
                            transform="translate(-3, 0)" // shift left & up
                          />

                          {/* percentage text inside the circle */}
                          <text
                            fill="#000"
                            fontSize="12"
                            fontWeight="bold"
                            dominantBaseline="middle"
                            textAnchor="middle"
                            dy="2"
                            transform="translate(0, 0)" // move text with circle
                          >
                            {percentage}%
                          </text>
                        </g>
                      </svg>

                      <div className="relative w-[110px] h-[110px] rounded-[20%] bg-gray-300 overflow-hidden group">
                        {formik.values?.profilePicture ? (
                          <img
                            src={formik.values.profilePicture}
                            alt="Profile"
                            style={{
                              width: '100%',
                              height: '100%',
                              objectFit: 'cover',
                            }}
                          />
                        ) : (
                          <IconUser
                            size={40}
                            color="#9E9E9E"
                            style={{
                              marginLeft: '5px',
                              marginTop: '2px',
                              width: '90%',
                              height: '90%',
                              objectFit: 'cover',
                            }}
                          />
                        )}
                        <div className="absolute inset-0 z-10 flex items-center justify-center text-center bg-color-black bg-opacity-50 text-color-white text-sm font-medium rounded-[20%] opacity-0 transition-opacity duration-300 group-hover:opacity-100">
                          Click to View Profile Progress
                        </div>
                      </div>
                    </div>
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 9 }}>
                    <div>
                      <Title
                        style={{
                          color: 'white',
                          marginBottom: '8px',
                          marginTop: '8px',
                          textAlign: 'left',
                          fontSize: '20px',
                          fontFamily: 'Product Sans',
                        }}
                      >
                        Profile Picture
                      </Title>
                    </div>
                    <div className="flex flex-row items-start justify-start">
                      <div>
                        <FileInput
                          accept="image/*"
                          placeholder="Upload New"
                          onChange={file => {
                            setProfilePic(file);
                            handleFileChange(file);
                          }}
                          leftSection={<FaUpload color="white" />}
                          styles={{
                            input: {
                              width: 'auto',
                              backgroundColor: '#D83F87',
                              color: 'white',
                              textAlign: 'center',
                              fontWeight: 'bold',
                              cursor: 'pointer',
                              height: '40px',
                              fontFamily: 'Product Sans',
                              border: 'none',
                            },
                            placeholder: { color: 'white', fontSize: '14px' },
                          }}
                        />
                      </div>
                      <div>
                        <Button
                          onClick={() => {
                            setProfilePic(null);
                            formik.setFieldValue('profilePicture', '');
                          }}
                          style={{
                            width: 'auto',
                            backgroundColor: '#2A114A',
                            color: 'white',
                            fontWeight: 'bold',
                            height: '40px',
                            fontSize: '14px',
                            fontFamily: 'Product Sans',
                          }}
                          className="ml-4"
                        >
                          Remove Picture
                        </Button>
                      </div>
                    </div>
                    <div className="mt-2">
                      <Text
                        style={{
                          color: 'white',
                          marginBottom: '20px',
                          textAlign: 'left',
                          paddingLeft: '0',
                          fontFamily: 'Product Sans',
                        }}
                      >
                        Support: JPG.
                      </Text>
                    </div>
                  </Grid.Col>
                </Grid>
                {/* Profile Fields */}

                {/* Profile Form */}
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="First Name"
                      placeholder="Enter your first name"
                      name="firstName"
                      onChange={formik.handleChange}
                      value={formik.values?.firstName}
                      required
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Last Name"
                      placeholder="Enter your last name"
                      name="lastName"
                      onChange={formik.handleChange}
                      value={formik.values?.lastName}
                      required
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Stage Name"
                      placeholder="Enter your stage name"
                      name="stageName"
                      onChange={formik.handleChange}
                      value={formik.values?.stageName}
                      required
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Email"
                      placeholder="Enter your email"
                      name="email"
                      onChange={formik.handleChange}
                      value={formik.values?.email}
                      disabled
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Date Of Birth"
                      placeholder="Enter your date of birth"
                      name="dateOfBirth"
                      onChange={formik.handleChange}
                      value={
                        formik.values?.dateOfBirth
                          ? formik.values.dateOfBirth.split('T')[0]
                          : ''
                      }
                      disabled
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Phone Number"
                      placeholder="Enter your phone number"
                      name="phoneNumber"
                      onChange={formik.handleChange}
                      value={formik.values?.phoneNumber}
                      disabled
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Gender"
                      placeholder="Enter your gender"
                      name="gender"
                      onChange={formik.handleChange}
                      value={formik.values?.gender}
                      disabled
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <TextInput
                      className=" py-3"
                      radius="8px"
                      label="Rate/Price"
                      placeholder="Enter your price"
                      name="ratePerHour"
                      onChange={formik.handleChange}
                      value={formik.values?.ratePerHour}
                      required
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                </Grid>
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <Select
                      className=" py-3"
                      radius="8px"
                      label="Entertainer Type"
                      placeholder="E.g., Singer, DJ, Dancer"
                      name="entertainerType"
                      data={organizeDropDownData(
                        referenceData?.entertainerTypes
                      )}
                      onChange={value =>
                        formik.setFieldValue('entertainerTypeId', value)
                      }
                      value={formik.values?.entertainerTypeId}
                      required
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <Select
                      className=" py-3"
                      radius="8px"
                      label="Select Your Location"
                      placeholder="Choose your location"
                      name="address"
                      data={['New York', 'Los Angeles', 'Chicago', 'Miami']}
                      onChange={value => formik.setFieldValue('address', value)}
                      value={formik.values?.address}
                      styles={inputStyle4}
                    />
                  </Grid.Col>
                </Grid>

                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <Textarea
                      //className=" py-4"
                      radius="8px"
                      label="BIO"
                      placeholder="Tell us about yourself..."
                      minRows={3}
                      className="Profile-textArea py-3"
                      name="bio"
                      onChange={formik.handleChange}
                      value={formik.values?.bio}
                      required
                      styles={inputStyle4}
                      style={{ minHeight: '160 !important' }}
                    />
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <Grid>
                      <Grid.Col span={{ base: 12, md: 6 }}>
                        <TextInput
                          className=" py-3"
                          radius="8px"
                          label="Facebook"
                          leftSection={
                            <Image src={fb} alt="fb" width={20} height={20} />
                          }
                          placeholder="@username"
                          name="faceBookLink"
                          onChange={formik.handleChange}
                          value={formik.values?.faceBookLink}
                          styles={inputStyle5}
                        />
                      </Grid.Col>
                      <Grid.Col span={{ base: 12, md: 6 }}>
                        <TextInput
                          className=" py-3"
                          radius="8px"
                          label="Instagram"
                          leftSection={
                            <Image
                              src={insta}
                              alt="fb"
                              width={20}
                              height={20}
                            />
                          }
                          placeholder="@username"
                          name="instagramLink"
                          onChange={formik.handleChange}
                          value={formik.values?.instagramLink}
                          styles={inputStyle5}
                        />
                      </Grid.Col>
                    </Grid>
                    <Grid>
                      <Grid.Col span={{ base: 12, md: 6 }}>
                        <TextInput
                          className=" py-3"
                          radius="8px"
                          label="Twitter"
                          leftSection={
                            <Image src={X} alt="fb" width={20} height={20} />
                          }
                          placeholder="@username"
                          name="xLink"
                          onChange={formik.handleChange}
                          value={formik.values?.xLink}
                          styles={inputStyle5}
                        />
                      </Grid.Col>
                      <Grid.Col span={{ base: 12, md: 6 }}>
                        <TextInput
                          className=" py-3"
                          radius="8px"
                          label="Snapchat"
                          leftSection={
                            <Image src={snap} alt="fb" width={20} height={20} />
                          }
                          placeholder="@username"
                          name="snapChatLink"
                          onChange={formik.handleChange}
                          value={formik.values?.snapChatLink}
                          styles={inputStyle5}
                        />
                      </Grid.Col>

                      <Grid.Col span={{ base: 12, md: 6 }}>
                        <TextInput
                          className=" py-3"
                          radius="8px"
                          label="Tiktok"
                          leftSection={
                            <Image
                              src={tiktok}
                              alt="tiktok"
                              width={34}
                              height={24}
                            />
                          }
                          placeholder="@username"
                          name="tiktokLink"
                          onChange={formik.handleChange}
                          value={formik.values?.tiktokLink}
                          styles={inputStyle5}
                        />
                      </Grid.Col>
                    </Grid>
                  </Grid.Col>
                </Grid>
                {/* End of Profile Form */}

                {/* Divider */}
                <Divider color="white" style={{ margin: '20px 0' }} />

                {/* Portfolio Upload */}
                <Grid>
                  <Text
                    style={{
                      color: 'white',
                      margin: '20px 0px',
                      paddingLeft: '10',
                      fontFamily: 'Product Sans',
                    }}
                  >
                    Upload Portfolio Pictures
                  </Text>
                </Grid>
                <Grid>
                  {/* Dropzone Area */}
                  <Grid.Col span={{ base: 12, md: 6 }}>
                    <Dropzone
                      onDrop={handleDrop}
                      maxSize={3 * 1024 ** 2}
                      accept={[
                        MIME_TYPES.png,
                        MIME_TYPES.jpeg,
                        MIME_TYPES.webp,
                      ]}
                      style={{
                        border: '2px dashed white',
                        borderRadius: '10px',
                        backgroundColor: '#6534BA',
                        padding: '20px',
                        fontFamily: 'Product Sans',
                        cursor: 'pointer',
                        height: '250px',
                        display: 'flex',
                        justifyContent: 'center',
                        alignItems: 'center',
                        flexDirection: 'column',
                      }}
                    >
                      <FaUpload size={30} color="white" />
                      <Text color="white" size="sm" mt="xs">
                        Drag images here or click to upload (Max 6)
                      </Text>
                    </Dropzone>
                  </Grid.Col>

                  {/* Image Previews */}
                  <Grid.Col span={{ base: 12, md: 6 }}>
                    <div
                      style={{
                        display: 'grid',
                        gridTemplateColumns: 'repeat(3, 1fr)',
                        gap: '10px',
                        marginTop: '0px',
                      }}
                    >
                      {allImages.slice(0, 6).map((img, i) => (
                        <div
                          key={i}
                          style={{
                            height: '120px',
                            backgroundColor: '#E0E0E0',
                            borderRadius: '10px',
                            overflow: 'hidden',
                            position: 'relative',
                            cursor:
                              i === 5 && allImages.length > 6
                                ? 'pointer'
                                : 'default',
                          }}
                          onClick={() => {
                            if (i === 5 && allImages.length > 6) {
                              setViewMoreOpen(true);
                            }
                          }}
                        >
                          <img
                            src={img}
                            alt="Portfolio"
                            style={{
                              width: '100%',
                              height: '100%',
                              objectFit: 'cover',
                              opacity: uploadingImages.includes(img) ? 0.4 : 1,
                            }}
                          />
                          {uploadingImages.includes(img) && (
                            <div
                              style={{
                                position: 'absolute',
                                top: '40%',
                                left: '50%',
                                transform: 'translate(-50%, -50%)',
                              }}
                            >
                              <Loader size="sm" color="gray" />
                            </div>
                          )}

                          {i === 5 && allImages.length > 6 && (
                            <div
                              style={{
                                position: 'absolute',
                                top: 0,
                                left: 0,
                                height: '100%',
                                width: '100%',
                                backgroundColor: 'rgba(0,0,0,0.5)',
                                display: 'flex',
                                justifyContent: 'center',
                                alignItems: 'center',
                                color: 'white',
                                fontWeight: 'bold',
                                fontSize: '16px',
                              }}
                            >
                              View More
                            </div>
                          )}
                        </div>
                      ))}
                    </div>
                  </Grid.Col>
                </Grid>
                {/* Portfolio Picture Preview */}

                {/* Save & Update Button */}
                <Button
                  type="submit"
                  style={{
                    backgroundColor: '#D83F87',
                    color: 'white',
                    marginTop: '20px',
                    width: 'auto',
                    fontFamily: 'Product Sans',
                  }}
                  loading={formSubmitting}
                >
                  Save & Update
                </Button>
              </Grid.Col>
              <Grid.Col span={{ base: 12, md: 6, lg: 4 }}>
                <div
                  style={{
                    backgroundColor: '#3B1E6D',
                    borderRadius: '20px',
                    padding: '0px',
                    boxShadow: '0 4px 10px rgba(0, 0, 0, 0.2)',
                    maxWidth: '360px',
                    margin: '0 auto',
                    fontFamily: 'Product Sans',
                    overflow: 'hidden',
                    color: 'white',
                  }}
                >
                  {/* Top Header */}
                  <div
                    style={{
                      width: '100%',
                      height: '50px',
                      display: 'flex',
                      alignItems: 'center',
                      justifyContent: 'center',
                      fontSize: '24px',
                      position: 'relative',
                      fontFamily: 'Product Sans',
                    }}
                  >
                    <FaArrowLeft
                      style={{
                        position: 'absolute',
                        left: '15px',
                        fontSize: '18px',
                        cursor: 'pointer',
                      }}
                    />
                    Entertainer Profile
                  </div>

                  {/* Image */}

                  <div
                    style={{ width: '100%', height: '300px' }}
                    className="flex items-center justify-center"
                  >
                    <div
                      style={{
                        position: 'relative',
                        width: 250,
                        height: 250,
                        display: 'flex',
                        alignItems: 'center',
                        justifyContent: 'center',
                      }}
                      onClick={() => {
                        setprofileInfo({
                          isModalOpen: true,
                        });
                      }}
                    >
                      {/* SVG square progress */}

                      <svg
                        width={255}
                        height={240}
                        viewBox="0 0 140 140"
                        style={{
                          position: 'absolute',
                          top: 0,
                          left: 0,
                          zIndex: 10,
                        }}
                      >
                        <defs>
                          <linearGradient
                            id="progress-gradient"
                            x1="0%"
                            y1="0%"
                            x2="100%"
                            y2="0%"
                          >
                            {gradientStops}
                          </linearGradient>
                        </defs>

                        {/* base path */}
                        <path
                          id="progressPath"
                          d={`
      M 70 6
      H ${6 + rectRx}
      Q 6 6, 6 ${6 + rectRx}
      V ${134 - rectRx}
      Q 6 134, ${6 + rectRx} 134
      H ${134 - rectRx}
      Q 134 134, 134 ${134 - rectRx}
      V ${6 + rectRx}
      Q 134 6, ${134 - rectRx} 6
      H 70
    `}
                          fill="none"
                          stroke="#E0E0E0"
                          strokeWidth={4}
                        />

                        {/* progress stroke */}
                        <path
                          d={`
      M 70 6
      H ${6 + rectRx}
      Q 6 6, 6 ${6 + rectRx}
      V ${134 - rectRx}
      Q 6 134, ${6 + rectRx} 134
      H ${134 - rectRx}
      Q 134 134, 134 ${134 - rectRx}
      V ${6 + rectRx}
      Q 134 6, ${134 - rectRx} 6
      H 70
    `}
                          fill="none"
                          stroke="url(#progress-gradient)"
                          strokeWidth={4}
                          strokeDasharray={`${progressLength}, ${perimeter}`}
                          strokeLinecap="round"
                        />

                        {/* circle background + text */}
                        <g transform={`translate(${pos.x}, ${pos.y})`}>
                          {/* grey background circle */}
                          <circle
                            r="12"
                            fill="#E0E0E0"
                            stroke="#999"
                            strokeWidth="2"
                            transform="translate(-2, 0)"
                          />

                          {/* percentage text inside the circle */}
                          <text
                            fill="#000"
                            fontSize="9"
                            fontWeight="bold"
                            dominantBaseline="middle"
                            textAnchor="middle"
                            dy="2"
                          >
                            {percentage}%
                          </text>
                        </g>
                      </svg>

                      <div className="relative overflow-hidden group">
                        {/* Profile Picture */}
                        {formik.values?.profilePicture ? (
                          <img
                            src={formik.values.profilePicture}
                            alt="Preview"
                            style={{
                              width: 200,
                              height: 200,
                              borderRadius: 20,
                              objectFit: 'cover',
                            }}
                          />
                        ) : (
                          <IconUser size={120} color="#aaa" />
                        )}
                        <div className="absolute z-10 inset-0 mb-2 ml-1 flex items-center justify-center text-center bg-color-black bg-opacity-50 text-color-white text-sm font-medium rounded-[20%] opacity-0 transition-opacity duration-300 group-hover:opacity-100">
                          <p className=""> Click to View Profile Progress</p>
                        </div>
                      </div>
                    </div>
                  </div>

                  {/* Content */}
                  <div style={{ padding: '16px', fontFamily: 'Product Sans' }}>
                    {/* Name & Rating Row */}
                    <div
                      style={{
                        display: 'flex',
                        justifyContent: 'space-between',
                        alignItems: 'center',
                        marginBottom: '8px',
                      }}
                    >
                      <Text
                        fw={600}
                        size="25px"
                        style={{ fontFamily: 'Product Sans' }}
                      >
                        {userData?.fullNameOrBusinessName ?? 'N/A'}
                      </Text>
                      <div
                        style={{
                          display: 'flex',
                          alignItems: 'center',
                          backgroundColor: '#D83F87',
                          borderRadius: '20px',
                          padding: '2px 8px',
                          width: 'fit-content',
                          fontFamily: 'Product Sans',
                        }}
                      >
                        <FaStar
                          color="white"
                          size={14}
                          style={{ marginRight: 4 }}
                        />
                        <span
                          style={{
                            fontSize: '14px',
                            color: 'white',
                            fontFamily: 'Product Sans',
                          }}
                        >
                          {userData?.rating ?? 'N/A'}
                        </span>
                      </div>
                    </div>

                    {/* Info Section */}
                    <div
                      style={{ marginTop: '16px', fontFamily: 'Product Sans' }}
                    >
                      {/* Headings */}
                      <div
                        style={{
                          fontSize: '16px',
                          fontWeight: 500,
                          color: 'white',
                          display: 'flex',
                          justifyContent: 'space-between',
                          marginBottom: '4px',
                        }}
                      >
                        <span style={{ flex: 1, textAlign: 'left' }}>
                          Entertainer
                        </span>
                        <span>|</span>
                        <span style={{ flex: 1, textAlign: 'center' }}>
                          Rate/Price
                        </span>
                        <span>|</span>

                        <span style={{ flex: 1, textAlign: 'right' }}>
                          Location
                        </span>
                      </div>

                      {/* Values */}
                      <div
                        style={{
                          fontSize: '14px',
                          color: '#DADADA',
                          display: 'flex',
                          justifyContent: 'space-between',
                        }}
                      >
                        <span style={{ flex: 1, textAlign: 'left' }}>
                          {userData?.entertainerType?.name ?? 'N/A'}
                        </span>
                        <span style={{ flex: 1, textAlign: 'center' }}>
                          {' '}
                          {userData?.ratePerHour !== undefined &&
                          userData?.ratePerHour !== null
                            ? ` ${currency === '1' ? '$' : 'BHD ≈'} ${userData?.ratePerHour} `
                            : 'N/A'}
                        </span>
                        <span style={{ flex: 1, textAlign: 'right' }}>
                          {userData?.address ?? 'N/A'}
                        </span>
                      </div>
                    </div>

                    {/* Bio */}
                    <Text
                      size="18px"
                      mt="sm"
                      style={{
                        fontStyle: 'Product Sans',
                        color: '#FFFF',
                        textAlign: 'left',
                        marginTop: '12px',
                        fontFamily: 'Product Sans',
                      }}
                    >
                      {userData?.bio ?? 'N/A'}
                    </Text>
                  </div>
                  {/* Available Dates Section */}
                  <div style={{ marginTop: '24px' }}>
                    <div
                      style={{
                        display: 'flex',
                        alignItems: 'center',
                        gap: '8px',
                        color: 'white',
                        fontSize: '16px',
                        fontWeight: 500,
                        fontFamily: 'Product Sans',
                        marginBottom: '8px',
                        marginLeft: '18px',
                      }}
                    >
                      <FaCalendarAlt size={14} />
                      <span>Available Dates</span>
                    </div>

                    {/* Calendar Box */}
                    <div
                      style={{
                        border: '1px solid white',
                        borderRadius: '12px',
                        padding: '8px',
                        height: '350px',

                        width: '320px',
                        marginLeft: '10px',
                        marginBottom: '12px',
                      }}
                    >
                      <BasicDateCalendar />
                    </div>
                  </div>
                </div>
              </Grid.Col>
            </Grid>
            <Modal
              opened={viewMoreOpen}
              onClose={() => setViewMoreOpen(false)}
              title="More Portfolio Images"
              size="lg"
              centered
            >
              <div
                style={{
                  display: 'grid',
                  gridTemplateColumns: 'repeat(3, 1fr)',
                  gap: '10px',
                }}
              >
                {allImages.slice(6).map((img, index) => (
                  <img
                    key={index}
                    src={img}
                    alt="More Portfolio"
                    style={{
                      width: '100%',
                      height: '120px',
                      objectFit: 'cover',
                      borderRadius: '8px',
                    }}
                  />
                ))}
              </div>
            </Modal>
          </form>
        </Container>
      </Container>
      <ViewProfileDetails
        opened={profileInfo?.isModalOpen}
        setOpened={setprofileInfo}
      />
    </>
  );
};

export default MyProfile;
