import { Grid, Paper, Select, TextInput } from '@mantine/core';
import { IconCalendar, IconChevronDown } from '@tabler/icons-react';
// import { Button, Table } from '../../concave.agri/components';
import { DatePickerInput } from '@mantine/dates';
import { useDisclosure } from '@mantine/hooks';
import { useEffect, useMemo, useState } from 'react';
import { useSelector } from 'react-redux';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { fetchData } from '../../api/api';
import { Table } from '../../components';
import { DebouncedTextInput } from '../../components/DebouncedTextInput';
import { getTranslation } from '../../layout/languages';
import { filterStyle, textAreaStyle } from '../../theme/common.style';
import {
  AMOUNT,
  paginationInfoValue,
  SORT_OPTIONS,
} from '../../utils/common/constant.objects';
import { TransactionType } from '../../utils/common/enums';
import {
  formatNumber,
  handleError,
  handleSetParams,
  organizeDropDownData,
  removeEmptyValueFilters,
} from '../../utils/common/function';
import { handlePaginationValue } from '../../utils/common/pagination.Helper';
import {
  initialSearchValues,
  initialSearchValues1,
  SearchFilter,
} from '../reporting/initial.values';
import DepositModal from './deposit.modal';
import PaymentWalletChart from './payment-wallet-chart';
const PaymentWalletBusiness = () => {
  const navigate = useNavigate();
  const [isDepositOpen, { toggle: toggleDeposit }] = useDisclosure(false);
  const { userInfo } = useSelector((state: any) => state?.userInfo);
  const currency = useSelector(
    (state: any) => state.userInfo?.preferences?.currency?.preferredCurrencyId
  );
  const { referenceData } = useSelector((state: any) => state?.referenceData);
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const [walletBalance, setWalletBalance] = useState<any>();
  const [isLoading, setIsLoading] = useState(false);
  const [Loading, setLoading] = useState(false);
  const [transactionData, setTranscationData] = useState([]);
  const [tableData, setTableData] = useState([]);
  const [refreshAmount, setRefreshAmount] = useState(false);

  useEffect(() => {
    if (userInfo.id) setIsLoading(true);
    fetchData(`wallet/${userInfo.id}`)
      .then((res: any) => {
        setWalletBalance(res);
        setIsLoading(false);
      })
      .catch(err => {
        console.log('Error', err);
        setIsLoading(false);
      });
  }, [refreshAmount, currency]);

  const initialPaginationFromQueryParams = () => {
    const rowPerPage =
      searchParams.get('rowPerPage') ?? paginationInfoValue.rowPerPage;
    const currentPage = Number(
      searchParams.get('currentPage') ??
        paginationInfoValue.currentPage?.toString()
    );
    return { ...paginationInfoValue, rowPerPage, currentPage };
  };
  const handlePagination = (actionType: string, value?: any) =>
    handlePaginationValue(
      actionType,
      value,
      searchParams,
      paginationInfo,
      setPaginationInfo,
      setSearchParams
    );
  const [searchParams, setSearchParams] = useSearchParams();
  const [value, setValue] = useState<[Date | null, Date | null]>([null, null]);
  const [paginationInfo, setPaginationInfo] = useState(
    initialPaginationFromQueryParams()
  );
  useEffect(() => {
    const newPaginationInfo = initialPaginationFromQueryParams();

    if (JSON.stringify(newPaginationInfo) !== JSON.stringify(paginationInfo)) {
      setPaginationInfo(newPaginationInfo);
    }
  }, [searchParams]);

  const initializeStateFromQueryParams = () => {
    const searchValue =
      searchParams.get('searchValue') ?? initialSearchValues.searchValue;
    const type = searchParams.get('type') ?? initialSearchValues.type;
    const limit = searchParams.get('limit') ?? initialSearchValues.limit;
    const sort = searchParams.get('sort') ?? initialSearchValues.sort;
    const searchValue1 =
      searchParams.get('searchValue1') ?? initialSearchValues.searchValue1;
    const searchValue3 =
      searchParams.get('searchValue3') ?? initialSearchValues.searchValue3;
    const searchValue4 =
      searchParams.get('searchValue4') ?? initialSearchValues1.searchValue4;
    const type1 = searchParams.get('type') ?? initialSearchValues1.type1;
    const limit1 = searchParams.get('limit') ?? initialSearchValues1.limit1;
    const sort1 = searchParams.get('sort') ?? initialSearchValues1.sort1;
    const searchValue5 =
      searchParams.get('searchValue1') ?? initialSearchValues1.searchValue5;
    const searchValue6 =
      searchParams.get('searchValue3') ?? initialSearchValues1.searchValue6;
    return {
      searchValue,
      type,
      limit,
      sort,
      searchValue1,
      searchValue3,
      searchValue4,
      type1,
      limit1,
      sort1,
      searchValue5,
      searchValue6,
    };
  };
  const [searchValues, setSearchValues] = useState(
    initializeStateFromQueryParams()
  );
  const handleFetchDataByFilter = () => {
    setIsLoading(true);

    const baseFilters = [];

    if (searchValues?.searchValue) {
      baseFilters.push({
        field: 'transaction.displayOrderId',
        operator: 'like',
        value: searchValues.searchValue?.toString(),
      });
    }

    baseFilters.push({
      field: 'transaction.toUserId',
      operator: 'eq',
      value: userInfo?.id,
    });
    baseFilters.push({
      field: 'transaction.type',
      operator: 'eq',
      value: TransactionType.TICKET_PURCHASE,
    });

    if (searchValues.type) {
      baseFilters.push({
        field: 'event.ticketTypeId',
        operator: 'eq',
        value: searchValues.type,
      });
    }

    if (searchValues.limit) {
      baseFilters.push({
        field: 'transaction.amount',
        operator: 'lte',
        value: searchValues.limit,
      });
    }
    if (searchValues.searchValue1) {
      baseFilters.push({
        field: 'transaction.createdAt',
        operator: 'gte',
        value: new Date(
          new Date(searchValues.searchValue1).setDate(
            new Date(searchValues.searchValue1).getDate() - 1
          )
        ).toISOString(),
      });
    }

    if (searchValues.searchValue3) {
      baseFilters.push({
        field: 'transaction.createdAt',
        operator: 'lte',
        value: new Date(
          new Date(searchValues.searchValue3).setDate(
            new Date(searchValues.searchValue3).getDate() + 2
          )
        ).toISOString(),
      });
    }

    const filters = removeEmptyValueFilters(baseFilters);
    const filterObject = JSON.stringify({ filter: filters });
    const queryParams = new URLSearchParams({
      rpp: paginationInfo.rowPerPage.toString(),
      page: (paginationInfo.currentPage === 0
        ? 1
        : paginationInfo.currentPage
      ).toString(),
      filter: filterObject,
    });

    if (searchValues.sort) {
      queryParams.append(
        'orderBy',
        JSON.stringify({
          displayOrderId: searchValues.sort,
          createdAt: searchValues.sort,
        })
      );
    }

    const fetchUrl = `transactions?${queryParams.toString()}`;

    fetchData(fetchUrl)
      .then((response: any) => {
        if (response?.data) {
          setTranscationData(response.data);
        }
      })
      .catch(err => handleError(err, 'Error fetching transaction'))
      .finally(() => {
        setIsLoading(false);
      });
  };

  const handleFetchData = () => {
    setLoading(true);

    const baseFilters = [];

    if (searchValues?.searchValue4) {
      baseFilters.push({
        field: 'transaction.displayOrderId',
        operator: 'like',
        value: searchValues.searchValue4?.toString(),
      });
    }

    baseFilters.push({
      field: 'transaction.fromUserId',
      operator: 'eq',
      value: userInfo?.id,
    });
    baseFilters.push({
      field: 'transaction.type',
      operator: 'eq',
      value: TransactionType.PERFORMANCE_FEE,
    });

    if (searchValues.type1) {
      baseFilters.push({
        field: 'event.ticketTypeId',
        operator: 'eq',
        value: searchValues.type1,
      });
    }

    if (searchValues.limit1) {
      baseFilters.push({
        field: 'transaction.amount',
        operator: 'lte',
        value: searchValues.limit1,
      });
    }
    if (searchValues.searchValue6) {
      baseFilters.push({
        field: 'transaction.createdAt',
        operator: 'gte',
        value: new Date(
          new Date(searchValues.searchValue6).setDate(
            new Date(searchValues.searchValue6).getDate() - 1
          )
        ).toISOString(),
      });
    }

    if (searchValues.searchValue5) {
      baseFilters.push({
        field: 'transaction.createdAt',
        operator: 'lte',
        value: new Date(
          new Date(searchValues.searchValue5).setDate(
            new Date(searchValues.searchValue5).getDate() + 2
          )
        ).toISOString(),
      });
    }

    const filters = removeEmptyValueFilters(baseFilters);
    const filterObject = JSON.stringify({ filter: filters });
    const queryParams = new URLSearchParams({
      rpp: paginationInfo.rowPerPage.toString(),
      page: (paginationInfo.currentPage === 0
        ? 1
        : paginationInfo.currentPage
      ).toString(),
      filter: filterObject,
    });

    if (searchValues.sort1) {
      queryParams.append(
        'orderBy',
        JSON.stringify({
          displayOrderId: searchValues.sort1,
          createdAt: searchValues.sort1,
        })
      );
    }

    const fetchUrl = `transactions?${queryParams.toString()}`;

    fetchData(fetchUrl)
      .then((response: any) => {
        if (response?.data) {
          setTableData(response.data);
        }
      })
      .catch(err => handleError(err, 'Error fetching transaction'))
      .finally(() => {
        setLoading(false);
      });
  };
  const handleSearchButtonClick = () => {
    handleSetParams(
      searchParams,
      searchValues,
      initialSearchValues,
      setSearchParams
    );

    handleFetchDataByFilter();
  };
  const handleSearchButton = () => {
    handleSetParams(
      searchParams,
      searchValues,
      initialSearchValues,
      setSearchParams
    );
    handleFetchData();
  };
  useEffect(() => {
    handleSearchButtonClick();
  }, [
    searchValues.searchValue,
    searchValues.searchValue1,
    searchValues.searchValue3,
    searchValues.limit,
    searchValues.type,
    searchValues.sort,
  ]);
  useEffect(() => {
    handleSearchButton();
  }, [
    searchValues.searchValue4,
    searchValues.searchValue6,
    searchValues.searchValue5,
    searchValues.limit1,
    searchValues.type1,
    searchValues.sort1,
  ]);

  const columns = useMemo(
    () => [
      {
        header: (
          <div className="flex text-start ml-3 font-normal font-productsans text-[14px]">
            ID
          </div>
        ),
        accessorKey: 'id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;

          return (
            <div className="flex text-start ml-4">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject?.displayOrderId}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-center items-center ml-2 font-normal font-productsans text-[14px]">
            Client Name
          </div>
        ),
        accessorKey: 'event',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start">
              <p className="text-start font-productsans font-normal text-[14px]">
                {rowObject?.toUser?.fullNameOrBusinessName}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-center items-center ml-3 font-normal font-productsans text-[14px]">
            Events
          </div>
        ),
        accessorKey: 'event',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start">
              <div>
                {rowObject?.event?.image ? (
                  <img
                    src={rowObject.event.image}
                    alt="Image"
                    className="rounded-md w-9 h-6 rtl:ml-6 rtl:-mr-4"
                    loading="lazy"
                  />
                ) : (
                  <div className="rounded-md w-9 h-6 rtl:ml-6 rtl:-mr-4 bg-gray-300 flex items-center justify-center text-xs font-semibold uppercase">
                    {rowObject?.event?.title?.[0] || 'E'}
                  </div>
                )}
              </div>
              <p className="text-start ml-2 font-productsans font-normal text-[14px]">
                {rowObject?.event?.title || 'N/A'}
              </p>
            </div>
          );
        },
      },

      {
        header: (
          <div className="flex text-start ml-2 font-normal font-productsans text-[14px]">
            Ticket Bought
          </div>
        ),
        accessorKey: 'id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-0">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject.ticketQuantity || '0'}Pcs
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-start ml-2 font-normal font-productsans text-[14px]">
            Amount Paid
          </div>
        ),
        accessorKey: 'id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start">
              <p className="text-start font-normal font-productsans text-[14px]">
                {`${currency === '1' ? '$' : 'BHD ≈'} ${currency === '1' ? formatNumber(rowObject?.amount) : formatNumber(rowObject?.convertedAmount) || 'N/A'}`}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-center items-center ml-2 font-normal font-productsans text-[14px]">
            Date
          </div>
        ),
        accessorKey: 'createdAt',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          const date = new Date(rowObject?.createdAt).toLocaleDateString(
            'en-GB'
          );

          return (
            <div className="flex text-start">
              <p className="text-start font-productsans font-normal text-[14px]">
                {date || 'N/A'}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-start ml-1 font-normal font-productsans text-[14px]">
            Status
          </div>
        ),
        accessorKey: 'amount',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-2">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject?.event?.status || 'N/A'}
              </p>
            </div>
          );
        },
      },
    ],
    [transactionData, currency]
  );

  const columnsEntainer = useMemo(
    () => [
      {
        header: (
          <div className="flex text-start ml-1 font-normal font-productsans text-[14px]">
            ID
          </div>
        ),
        accessorKey: 'id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-2">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject?.displayOrderId}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-center items-center ml-3 font-normal font-productsans text-[14px]">
            Entertainer Name
          </div>
        ),
        accessorKey: 'entertainerName',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start">
              <p className="text-start font-productsans font-normal text-[14px]">
                {rowObject?.toUser?.fullNameOrBusinessName}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-center items-center ml-12 font-normal font-productsans text-[14px]">
            Events
          </div>
        ),
        accessorKey: 'event',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-9">
              <div>
                {rowObject?.event?.category?.image ? (
                  <img
                    src={rowObject.event.category.image}
                    alt="Image"
                    className="rounded-md w-9 h-6 rtl:ml-6 rtl:-mr-4"
                    loading="lazy"
                  />
                ) : (
                  <div className="rounded-md w-9 h-6 rtl:ml-6 rtl:-mr-4 bg-gray-300 flex items-center justify-center text-xs font-semibold uppercase">
                    {rowObject?.event?.category?.name?.[0] || 'E'}
                  </div>
                )}
              </div>
              <p className="text-start ml-2 font-productsans font-normal text-[14px]">
                {rowObject?.event?.category?.name || 'N/A'}
              </p>
            </div>
          );
        },
      },
      {
        header: (
          <div className="flex text-start ml-5 font-normal font-productsans text-[14px]">
            Amount Paid
          </div>
        ),
        accessorKey: 'amountPaid',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-2">
              <p className="text-start font-normal font-productsans text-[14px]">
                {`${currency === '1' ? '$' : 'BHD ≈'} ${currency === '1' ? formatNumber(rowObject?.actualAmount) : formatNumber(rowObject?.convertedActualAmount) || 'N/A'}`}
              </p>
            </div>
          );
        },
      },

      {
        header: (
          <div className="flex text-start ml-7 font-normal font-productsans text-[14px]">
            Date
          </div>
        ),
        accessorKey: 'date',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          const date = new Date(rowObject?.createdAt).toLocaleDateString(
            'en-GB'
          );
          return (
            <div className="flex text-start ml-5">
              <p className="text-start  font-productsans font-normal text-[14px]">
                {date || 'N/A'}
              </p>
            </div>
          );
        },
      },

      {
        header: (
          <div className="flex text-start ml-0 font-normal font-productsans text-[14px]">
            Status
          </div>
        ),
        accessorKey: 'id',
        cell: (info: any) => {
          const rowObject = info?.row?.original;
          return (
            <div className="flex text-start ml-2">
              <p className="text-start font-normal font-productsans text-[14px]">
                {rowObject?.escrowStatus || 'N/A'}
              </p>
            </div>
          );
        },
      },
    ],
    [tableData, currency]
  );

  const setValuesById = (valuesById: Partial<SearchFilter>) => {
    setSearchValues(prevFormValues => ({
      ...prevFormValues,
      ...valuesById,
    }));
  };
  return (
    <>
      <Paper
        className="flex flex-col justify-between items-center p-4 min-h-screen bg-[radial-gradient(ellipse_at_bottom,_var(--tw-gradient-stops))] from-[#50347d] via-[#3B1E6D] to-[#3B1E6D]"
        radius={0}
        style={{
          backgroundColor: '#3B1E6D',
          background: 'radial-gradient( #6534BA 43%, #3B1E6D)',
        }}
      >
        <Grid className="mt-6 mr-7 ">
          <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
            <div className="ml-4 text-[33px] font-semibold text-[#ffffff] font-productsans">
              {getTranslation(language, 'payment', 'Payments & Wallet')}
            </div>
          </Grid.Col>
        </Grid>
        <Grid className="px-6 py-4 w-full" gutter="xs">
          {/* Available Balance and Ticket Report Section */}
          <Grid className="rounded-2xl font-semibold text-[22px] text-color-white p-5 mt-1 bg-[#ffffff] bg-opacity-5 border border-[#623F9D] justify-between items-start w-full">
            {/* Left Section - Available Balance */}

            <Grid.Col span={{ base: 12, md: 4, lg: 4 }}>
              <div className="mt-3">
                <div className="rounded-2xl font-semibold text-[22px] text-color-white p-6 bg-opacity-5">
                  <div className="text-color-white mb-2 font-productsans font-normal text-[18px]">
                    {getTranslation(language, 'payment', 'Available Balance')}
                  </div>
                  {/* Balance Amount */}
                  <div className="text-color-white text-[34px] font-bold ">
                    {isLoading ? (
                      <div className=" h-8 w-10 bg-gray-300 rounded-md flex items-center justify-center animate-pulse" />
                    ) : (
                      `
                      ${currency === '1' ? '$' : 'BHD ≈'}
                     ${formatNumber(walletBalance?.balance || '0')}
                   `
                    )}
                  </div>
                  {/* Buttons */}
                  <div className="mt-4">
                    <button
                      className="bg-[#D83F87] text-color-white px-6 py-2 rounded-full text-[14px] font-semibold"
                      onClick={() => navigate('/payment/withdrawal')}
                    >
                      {getTranslation(language, 'payment', 'Withdraw Balance')}
                    </button>
                  </div>
                  <div className="mt-3">
                    <button
                      className="bg-[#3B1E6D] text-color-white px-6 py-2 rounded-full text-[14px] font-semibold"
                      onClick={toggleDeposit}
                    >
                      {getTranslation(language, 'payment', 'Add Deposit')}
                    </button>
                  </div>
                </div>
              </div>
            </Grid.Col>
            <Grid.Col span={{ base: 12, md: 8, lg: 8 }}>
              <div className="">
                <PaymentWalletChart isNeedToUpdate={refreshAmount} />
              </div>
            </Grid.Col>
          </Grid>
        </Grid>

        <Grid className="py-5 px-4 w-full">
          <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
            <div
              className="rounded-2xl font-semibold text-color-white p-4 font-['Product Sans'] bg-[#ffffff] bg-opacity-5 border border-[#623F9D] bg-transparent"
              style={{ minHeight: '339px' }}
            >
              {/* Heading & Search Filters in One Line */}
              <Grid className="mt-4 mr-7 ">
                <Grid.Col span={{ base: 12, md: 12, lg: 2 }}>
                  <div className="text-[22px] text-color-white font-productsans">
                    {getTranslation(language, 'payment', 'Ticket Sales')}
                  </div>
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <DebouncedTextInput
                    placeholder={getTranslation(
                      language,
                      'sales',
                      'Search order ID'
                    )}
                    value={searchValues.searchValue}
                    onChange={event =>
                      setValuesById({ searchValue: event.currentTarget.value })
                    }
                    styles={textAreaStyle}
                    classNames={{ input: 'text-input' }}
                    radius="6px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.75 }}>
                  <Select
                    placeholder={getTranslation(
                      language,
                      'payment',
                      'Event Type'
                    )}
                    data={organizeDropDownData(referenceData?.eventCategories)}
                    value={searchValues.type}
                    clearable
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value => setValuesById({ type: value || '' })}
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="6px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.65 }}>
                  <Select
                    placeholder={getTranslation(
                      language,
                      'navbar',
                      'Amount Limit'
                    )}
                    data={AMOUNT}
                    value={searchValues.limit}
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value => value && setValuesById({ limit: value })}
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="6px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <Select
                    placeholder={getTranslation(language, 'sales', 'Sort By')}
                    data={SORT_OPTIONS}
                    value={searchValues.sort}
                    clearable
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value => setValuesById({ sort: value || '' })}
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="6px"
                  />
                </Grid.Col>
                <Grid.Col span={{ base: 12, md: 2, lg: 1.25 }}>
                  <div className="text-[14px] mt-2.5 font-productsans px-2">
                    {getTranslation(language, 'refund', 'Select Date')}
                  </div>
                </Grid.Col>
                <Grid.Col span={{ base: 12, md: 3, lg: 2.25 }}>
                  <div>
                    <DatePickerInput
                      type="range"
                      placeholder={getTranslation(
                        language,
                        'refund',
                        'Pick date range'
                      )}
                      required
                      value={[
                        searchValues?.searchValue1
                          ? new Date(searchValues.searchValue1)
                          : null,
                        searchValues?.searchValue3
                          ? new Date(searchValues.searchValue3)
                          : null,
                      ]}
                      onChange={(value: any) => {
                        if (value) {
                          setValuesById({
                            searchValue1: value[0]
                              ? value[0].toISOString()
                              : '',
                            searchValue3: value[1]
                              ? value[1].toISOString()
                              : '',
                          });
                        }
                      }}
                      valueFormat="M/D/YY"
                      style={filterStyle}
                      radius={'6px'}
                      styles={{
                        input: {
                          backgroundColor: 'transparent',
                          borderColor: '#FFFFFF26',
                          color: '#ffffff',
                          fontFamily: 'Product Sans',
                          fontSize: '12px',
                          height: '48px',
                        },
                        placeholder: { color: 'white', fontWeight: 'normal' },
                      }}
                      rightSection={
                        <IconChevronDown size={16} color="#ffffff" />
                      }
                      leftSection={<IconCalendar size={20} color="#ffffff" />}
                    />
                  </div>
                </Grid.Col>
              </Grid>

              {/* Table Section */}
              <div className="mt-5 overflow-x-auto">
                <Table
                  data={transactionData}
                  columns={columns}
                  isLoading={isLoading}
                  paginationInfo={paginationInfo}
                  handlePagination={handlePagination}
                  isPaginated={false}
                  isWithActionButton={false}
                />
              </div>
            </div>
          </Grid.Col>
        </Grid>

        <Grid className="py-5 px-4 w-full">
          <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
            <div
              className="rounded-2xl font-semibold text-color-white p-4 font-['Product Sans'] bg-[#ffffff] bg-opacity-5 border border-[#623F9D] bg-transparent"
              style={{ minHeight: '339px' }}
            >
              {/* Heading & Search Filters in One Line */}
              <Grid className="mt-4 mr-7 ">
                <Grid.Col span={{ base: 12, md: 12, lg: 2.5 }}>
                  <div className="text-[22px] text-color-white font-productsans">
                    {getTranslation(
                      language,
                      'payment',
                      'Entertainers Payments'
                    )}
                  </div>
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <TextInput
                    placeholder={getTranslation(
                      language,
                      'sales',
                      'Search order ID'
                    )}
                    value={searchValues.searchValue4}
                    onChange={event =>
                      setValuesById({ searchValue4: event.currentTarget.value })
                    }
                    styles={textAreaStyle}
                    classNames={{ input: 'text-input' }}
                    radius="6px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <Select
                    placeholder={getTranslation(
                      language,
                      'payment',
                      'Event Type'
                    )}
                    data={organizeDropDownData(referenceData?.eventCategories)}
                    value={searchValues.type1}
                    clearable
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value => setValuesById({ type1: value || '' })}
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="8px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <Select
                    placeholder={getTranslation(
                      language,
                      'sales',
                      'Amount Limit'
                    )}
                    data={AMOUNT}
                    value={searchValues.limit1}
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value =>
                      value && setValuesById({ limit1: value })
                    }
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="6px"
                  />
                </Grid.Col>

                <Grid.Col span={{ base: 12, md: 3, lg: 1.5 }}>
                  <Select
                    placeholder={getTranslation(language, 'sales', 'Sort By')}
                    data={SORT_OPTIONS}
                    value={searchValues.sort1}
                    clearable
                    rightSection={<IconChevronDown size={16} color="white" />}
                    onChange={value => setValuesById({ sort1: value || '' })}
                    styles={filterStyle}
                    classNames={{ input: 'custom-input' }}
                    radius="6px"
                  />
                </Grid.Col>
                <Grid.Col span={{ base: 12, md: 2, lg: 1.25 }}>
                  <div className="text-[14px] mt-2.5 font-productsans px-1">
                    {getTranslation(language, 'refund', 'Select Date')}
                  </div>
                </Grid.Col>
                <Grid.Col span={{ base: 12, md: 3, lg: 2.25 }}>
                  <DatePickerInput
                    type="range"
                    placeholder={getTranslation(
                      language,
                      'refund',
                      'Pick date range'
                    )}
                    required
                    value={[
                      searchValues?.searchValue6
                        ? new Date(searchValues.searchValue6)
                        : null,
                      searchValues?.searchValue5
                        ? new Date(searchValues.searchValue5)
                        : null,
                    ]}
                    onChange={(value: any) => {
                      if (value) {
                        setValuesById({
                          searchValue6: value[0] ? value[0].toISOString() : '',
                          searchValue5: value[1] ? value[1].toISOString() : '',
                        });
                      }
                    }}
                    valueFormat="M/D/YY"
                    style={filterStyle}
                    radius={'6px'}
                    styles={{
                      input: {
                        backgroundColor: 'transparent',
                        borderColor: '#FFFFFF26',
                        color: '#ffffff',
                        fontFamily: 'Product Sans',
                        fontSize: '12px',
                        height: '48px',
                      },
                      placeholder: { color: 'white', fontWeight: 'normal' },
                    }}
                    rightSection={<IconChevronDown size={16} color="#ffffff" />}
                    leftSection={<IconCalendar size={20} color="#ffffff" />}
                  />
                </Grid.Col>
              </Grid>

              {/* Table Section */}
              <div className="mt-5 overflow-x-auto">
                <Table
                  data={tableData}
                  isPaginated={false}
                  columns={columnsEntainer}
                  isLoading={Loading}
                  paginationInfo={paginationInfo}
                  handlePagination={handlePagination}
                  isWithActionButton={false}
                />
              </div>
            </div>
          </Grid.Col>
        </Grid>
      </Paper>
      <DepositModal
        opened={isDepositOpen}
        setOpened={() => {
          setRefreshAmount(!refreshAmount);
          toggleDeposit();
        }}
      />
    </>
  );
};

export default PaymentWalletBusiness;
