import { Modal, Box, Loader } from '@mantine/core';
import { useState } from 'react';
import { useSelector } from 'react-redux';

const ProfileModal = ({ opened, setOpened, profileData }: any) => {
  const [loading, setLoading] = useState<boolean>(false);
  const userInfo = useSelector((state: any) => state?.userInfo?.userInfo);

  return (
    <Modal
      opened={opened}
      onClose={() => setOpened(false)}
      size="md"
      centered
      withCloseButton={false}
      styles={{
        content: {
          borderRadius: '15px',
          backgroundColor: '#6D3EBD',
          padding: 0, // Remove default padding
        },
        body: {
          padding: 0, // Ensure no padding inside modal body
          backgroundColor: '#6D3EBD',
          color: 'white',
        },
        inner: {
          padding: 0, // Ensures modal wrapper has no padding
          margin: 0,
          maxWidth: '100vw',
        },
        header: { backgroundColor: '#6D3EBD', color: 'white' },
      }}
      overlayProps={{
        backgroundOpacity: 0.55,
        blur: 3,
      }}
      transitionProps={{ transition: 'fade-up', duration: 300 }}
    >
      <div className="relative w-full">
        {profileData?.profile?.profilePicture ? (
          <img
            src={profileData?.profile?.profilePicture}
            alt="image"
            className="rounded-t-md h-[180px] w-full object-cover"
          />
        ) : (
          <div className="rounded-t-md h-[30px] w-full object-cover"> </div>
        )}
        <Modal.CloseButton
          onClick={() => setOpened(false)}
          style={{
            position: 'absolute',
            top: 10,
            right: 10,
            border: 'none',
            outline: 'none',
            boxShadow: 'none',
            color: '#ffffff',
            backgroundColor: 'transparent',
            transition: 'background-color 0.2s ease-in-out',
            width: 33,
            height: 33,
          }}
        />
      </div>

      {loading ? (
        <Box
          style={{
            height: '200px',
            display: 'flex',
            justifyContent: 'center',
            alignItems: 'center',
          }}
        >
          <Loader color="white" size="lg" />
        </Box>
      ) : (
        <>
          <div className="mt-4">
            <div className="flex flex-row justify-between ml-8 mr-6">
              <div className="text-[18px] font-productsans text-[#F4F4FE]">
                {profileData?.profile?.fullNameOrBusinessName}
              </div>
            </div>
            <div className=" ml-8 mr-6">
              <div className="text-[14px] font-productsans text-[#F4F4FE] flex flex-row justify-start">
                {profileData?.profile?.email}
              </div>
              <div className="text-[18px] font-productsans text-[#F4F4FE]">
                {profileData?.profile?.phoneNumber}
              </div>
            </div>
            <div className="text-[18px] font-productsans text-[#F4F4FE] ml-8 mr-6 mt-4 font-bold">
              Bio:
            </div>
            <div className="text-[#BBACD7] font-productsans text-[14px] px-8 py-2 mb-3">
              {profileData?.profile?.bio}
            </div>
          </div>
        </>
      )}
    </Modal>
  );
};

export default ProfileModal;
