import { Chip } from '@mantine/core';
import { IconCheck } from '@tabler/icons-react';
import React from 'react';

interface NotificationPerformedProps {
  language: string;
  getTranslation: (lang: string, section: string, key: string) => string;
}

const NotificationPerformed: React.FC<NotificationPerformedProps> = ({
  language,
  getTranslation,
}) => {
  return (
    <Chip
      checked
      icon={<IconCheck size={16} color="white" />}
      color="#418F90"
      variant="filled"
      readOnly
      styles={{
        root: {
          color: '#418F90',
          borderRadius: '16px',
          padding: '8px 14px',
          fontSize: '13px',
          fontWeight: 500,
          cursor: 'default',
        },
        label: { padding: 8 },
      }}
    >
      {getTranslation(language, 'dashboard', 'Action has been performed')}
    </Chip>
  );
};

export default NotificationPerformed;
