import { Modal } from '@mantine/core';
import { useSelector } from 'react-redux';
import { getTranslation } from '../../layout/languages';

const ViewPaymentDetails = ({ opened, setOpened, eventData }: any) => {
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );

  const acceptedGig = Array.isArray(eventData?.gigs)
    ? eventData.gigs.find((gig: any) => gig?.status === 'Accepted')
    : null;

  return (
    <Modal
      opened={opened}
      centered
      size="md"
      onClose={() => setOpened(false)}
      withCloseButton={false}
      styles={{
        content: {
          borderRadius: '15px',
          backgroundColor: '#6D3EBD',
          padding: 0,
        },
        body: {
          padding: 0,
        },
        inner: {
          padding: 0,
          margin: 0,
          maxWidth: '100vw',
        },
      }}
      overlayProps={{
        backgroundOpacity: 0.55,
        blur: 3,
      }}
      transitionProps={{ transition: 'fade-up', duration: 300 }}
      title=""
    >
      <div className="relative w-full">
        <Modal.CloseButton
          onClick={() => setOpened(false)}
          style={{
            position: 'absolute',
            top: 10,
            right: 10,
            border: 'none',
            outline: 'none',
            boxShadow: 'none',
            color: '#ffffff',
            backgroundColor: 'transparent',
            transition: 'background-color 0.2s ease-in-out',
            width: 33,
            height: 33,
          }}
        />
      </div>

      <div className="mt-4">
        {acceptedGig ? (
          <div className="text-[14px] px-8 py-3 bg-opacity-30 mt-4">
            <div className="text-[#ffffff] text-[14px] font-semibold font-productsans mt-3">
              {getTranslation(language, 'event', 'Payment Details')}:
            </div>

            <div className="text-[#BBACD7D9] text-[13px] font-productsans mt-2">
              <p className="text-[#ffffff] mb-1">
                {getTranslation(language, 'event', 'Name')}:
                <p>{acceptedGig.entertainer?.fullNameOrBusinessName}</p>
              </p>
              <p className="text-[#ffffff] mb-1">
                {getTranslation(language, 'event', 'Fee')}:{' '}
                <p>{acceptedGig.proposedPerformanceFee}</p>
              </p>
              <p className="text-[#ffffff] mb-1">
                {getTranslation(language, 'event', 'Payment Type')}:{' '}
                <p> {acceptedGig.paymentType}</p>
              </p>
            </div>
          </div>
        ) : (
          <div className="text-center text-[#ffffff] text-[14px] font-productsans py-4">
            {getTranslation(language, 'event', 'No Gig')}
          </div>
        )}
      </div>
    </Modal>
  );
};

export default ViewPaymentDetails;
