import React, { useState } from 'react';
import {
  Box,
  Stepper,
  Step,
  StepLabel,
  styled,
  StepConnector,
  StepButton,
} from '@mui/material';
import { useLocation, useNavigate } from 'react-router-dom';
import { useSelector } from 'react-redux';
import { getTranslation } from '../../layout/languages';

const StepperComponent = () => {
  const navigate = useNavigate();
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const steps = ['Details', 'Entertainer', 'Selection', 'Publish'];
  const [completed, setCompleted] = React.useState<{
    [k: number]: boolean;
  }>({});

  const location = useLocation();

  const activeStep = location.state?.step || 1;
  const CustomConnector = styled(StepConnector)(({ theme }) => ({
    [`& .MuiStepConnector-line`]: {
      borderColor: 'white', // Default connector color (white)
      borderTopWidth: 4, // Line thickness
      transition: 'border-color 0.3s ease-in-out',
    },
    [`&.Mui-active .MuiStepConnector-line, &.Mui-completed .MuiStepConnector-line`]:
      {
        borderColor: '#D83F87', // Connector turns pink when step is completed
      },
  }));

  const CustomStepIcon = (props: {
    completed?: boolean;
    active?: boolean;
    icon: React.ReactNode;
  }) => {
    const completed = !!props.completed; // Ensure boolean value

    const { icon } = props;

    return (
      <Box
        sx={{
          width: 36,
          height: 36,
          borderRadius: '50%',
          display: 'flex',
          alignItems: 'center',
          justifyContent: 'center',
          fontWeight: 'bold',
          fontSize: 14,
          color: completed ? 'white' : 'white', // Text color
          backgroundColor: completed ? '#D83F87' : '#D83F87', // Background pink when completed
          border: completed ? 'none' : '4px solid white', // White border when not completed
          transition: 'all 0.3s ease-in-out',
        }}
      >
        {icon}
      </Box>
    );
  };

  const handleStepClick = (stepIndex: number) => {
    switch (stepIndex) {
      case 0:
        navigate(`/upcomingEvents/create-event`, {
          state: { step: 1 },
        });
        break;
      case 1:
        navigate(`/upcomingEvents/Search-Entertainer`, {
          state: { step: 2 },
        });
        break;
      case 2:
        navigate('/upcomingEvents/Event-Summary', { state: { step: 3 } });
        break;
      case 3:
        navigate('/upcomingEvents/Publish', { state: { step: 4 } });
        break;
      default:
        break;
    }
  };

  return (
    <Box sx={{ width: '100%' }}>
      <Stepper
        activeStep={activeStep}
        alternativeLabel
        connector={<CustomConnector />}
      >
        {steps.map((label, index) => (
          <Step key={label} completed={completed[index]}>
            <StepButton
              color="inherit"
              sx={{ color: 'white' }}
              onClick={() => handleStepClick(index)}
              disabled={false}
            >
              <StepLabel
                StepIconComponent={stepProps => (
                  <CustomStepIcon
                    {...stepProps}
                    completed={!!stepProps.completed}
                    active={!!stepProps.active}
                  />
                )}
                sx={{
                  '& .MuiStepLabel-label': {
                    color: 'white !important',
                    fontFamily: 'Product Sans',
                    fontSize: '14px',
                    fontWeight: activeStep === index ? 'bold' : 'normal', // Highlight current step
                  },
                  '& .Mui-active .MuiStepLabel-label': {
                    color: 'white',
                    fontFamily: 'Product Sans',
                    fontSize: '14px',
                    fontWeight: 'bold',
                  },
                  '& .Mui-completed .MuiStepLabel-label': {
                    color: 'white',
                    fontFamily: 'Product Sans',
                    fontSize: '14px',
                    fontWeight: 'normal',
                  },

                  '& .MuiStepIcon-root': {
                    color: '#D83F87 !important',
                  },
                  '& .Mui-active .MuiStepIcon-root': {
                    color: '#D83F87',
                  },
                  '& .Mui-completed .MuiStepIcon-root': {
                    color: '#D83F87',
                  },
                }}
              >
                {getTranslation(language, 'event', label)}
              </StepLabel>
            </StepButton>
          </Step>
        ))}
      </Stepper>
    </Box>
  );
};

export default StepperComponent;
