import { FileInput, Grid, Paper, Select, TextInput } from '@mantine/core';
import { IconArrowLeft, IconStarFilled } from '@tabler/icons-react';

import { useEffect, useState } from 'react';
import { useNavigate, useParams, useSearchParams } from 'react-router-dom';
import { Button } from '../../components';

import { paginationInfoValue } from '../../utils/common/constant.objects';
import StepperComponent from './stepper';
import useScreenSize from '../../hooks/useScreenSize';
import { fetchData, putData } from '../../api/api';
import {
  formatDate,
  handleError,
  handleSuccess,
} from '../../utils/common/function';

import { useSelector } from 'react-redux';
import SuccessModal from './success';
const EventSummary = () => {
  const initialPaginationFromQueryParams = () => {
    const rowPerPage =
      searchParams.get('rowPerPage') ?? paginationInfoValue.rowPerPage;
    const currentPage = Number(
      searchParams.get('currentPage') ??
        paginationInfoValue.currentPage?.toString()
    );
    return { ...paginationInfoValue, rowPerPage, currentPage };
  };
  const { isSmallScreen, isMediumScreen, isExtraLargeScreen } = useScreenSize();
  const [accountInfo, setaccountInfo] = useState(false);
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const [searchParams, setSearchParams] = useSearchParams();
  const [paginationInfo, setPaginationInfo] = useState(
    initialPaginationFromQueryParams()
  );
  const currency = useSelector(
    (state: any) => state.userInfo?.preferences?.currency?.preferredCurrencyId
  );
  useEffect(() => {
    const newPaginationInfo = initialPaginationFromQueryParams();

    if (JSON.stringify(newPaginationInfo) !== JSON.stringify(paginationInfo)) {
      setPaginationInfo(newPaginationInfo);
    }
  }, [searchParams]);
  const navigate = useNavigate();
  const [isLoading, setIsLoading] = useState(false);
  const [data, setData] = useState<any>();
  const [gigdata, setgigData] = useState<any>();
  const { id } = useParams();

  const eventId = searchParams.get('eventId');
  const [paymentSuccess, setPaymentSuccess] = useState(false);
  useEffect(() => {
    if (!eventId) return;

    setIsLoading(true);

    fetchData(`/events/${eventId}`)
      .then((response: any) => {
        setData(response);
        const firstValidGig = response.gigs?.find(
          (gig: any) => gig.entertainer
        );
        setgigData(firstValidGig || null);
      })
      .catch((error: any) => {
        handleError(error, 'Failed to fetch event data');
      })
      .finally(() => {
        setIsLoading(false);
      });
  }, [eventId, currency]);

  const handlePublish = async () => {
    try {
      setIsLoading(true);

      await putData(`events/${eventId}/publish`, {
        isPublished: true,
      });
      // navigate('/upcomingEvents');
      setPaymentSuccess(true);
      handleSuccess('Event Publish successfully!');
    } catch (error) {
      console.error('Error:', error);
      handleError(error);
    } finally {
      setIsLoading(false);
    }
  };
  return (
    <>
      <Paper
        className="flex justify-between items-center p-4 min-h-screen "
        radius={0}
        style={{
          backgroundColor: '#3B1E6D',
          background: 'radial-gradient( #6534BA 43%, #3B1E6D)',
        }}
      >
        <Grid className="mt-6 mr-7 mb-5">
          <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
            <div className="ml-4 text-[26px] font-semibold text-[#ffffff] font-productsans flex flex-row justify-start">
              <span className="mr-2 mt-1">
                <div
                  className={`rounded-md border-none shadow-sm border bg-color-white bg-opacity-5 w-8 h-8  flex items-center justify-center`}
                >
                  <IconArrowLeft
                    className=" align-middle select-none bg-transparent text-center transition-all cursor-pointer"
                    color="#ffffff"
                    onClick={() => navigate(-1)}
                    size={20}
                  />
                </div>
              </span>
              {`  Event Summary`}
            </div>
          </Grid.Col>
          <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
            <StepperComponent />
          </Grid.Col>
        </Grid>

        <div
          className="rounded-2xl ml-4 mr-2 font-semibold text-[#ffffff] p-4 font-productsans h-[100%] bg-transparent bg-[#ffffff] bg-opacity-5 border border-[#623F9D]"
          style={{ height: 'auto' }}
        >
          <Grid className="mt-4 px-4">
            <Grid.Col span={{ base: 12, md: 12, lg: 6.5 }}>
              <div className="relative w-full px-2 py-2">
                {data?.eventImage ? (
                  <img
                    src={data?.eventImage}
                    alt="image"
                    className=" h-[290px] w-full object-cover rounded-lg"
                    loading="lazy"
                  />
                ) : (
                  <div className="flex items-center justify-center bg-gray-200 text-gray-600 rounded-md h-[285px] w-full text-6xl font-bold">
                    {data?.title?.charAt(0) || ''}
                  </div>
                )}
              </div>
            </Grid.Col>
            <Grid.Col span={{ base: 12, md: 12, lg: 5.5 }}>
              <div className="mt-2 mr-8">
                <div className="flex flex-row justify-between mr-6">
                  <div className="flex flex-col justify-between ml-2 mr-6">
                    <div className="text-[20px] font-productsans font-semibold text-[#F4F4FE]">
                      {data?.title || 'N/A'}
                    </div>

                    <div className="text-[14px] font-productsans text-[#F4F4FE]">
                      Ticket Limit
                      <span className="ml-2">
                        {Array.isArray(data?.ticketsAndPrices) &&
                        data.ticketsAndPrices.length > 0
                          ? (() => {
                              const quantity = data.ticketsAndPrices
                                .map((ticket: any) => Number(ticket.quantity))
                                .filter((price: any) => !isNaN(price));

                              if (quantity.length === 0) return 'N/A';

                              const minPrice = Math.min(...quantity);
                              const maxPrice = Math.max(...quantity);

                              return minPrice === maxPrice
                                ? `${minPrice} `
                                : `${minPrice} - ${maxPrice} `;
                            })()
                          : 'N/A'}
                      </span>
                    </div>
                  </div>
                  <div className="text-[16px] font-productsans text-[#F4F4FE] mt-4 bg-[#D83F87] px-2 rounded-full h-7 inline-flex items-center justify-center">
                    {Array.isArray(data?.ticketsAndPrices) &&
                    data.ticketsAndPrices.length > 0
                      ? (() => {
                          const prices = data.ticketsAndPrices
                            .map((ticket: any) => Number(ticket.price))
                            .filter((price: any) => !isNaN(price));

                          if (prices.length === 0) return 'N/A';

                          const minPrice = Math.min(...prices);
                          const maxPrice = Math.max(...prices);

                          return minPrice === maxPrice
                            ? ` ${currency === '1' ? '$' : 'BHD ≈'} ${minPrice}`
                            : ` ${currency === '1' ? '$' : 'BHD ≈'}${minPrice} -  ${currency === '1' ? '$' : 'BHD ≈'}${maxPrice}`;
                        })()
                      : 'N/A'}
                  </div>
                </div>

                <div className=" w-auto h-auto  rounded-lg mb-3  mr-2 mt-4 ">
                  <div
                    className={`${isSmallScreen ? 'flex flex-row justify-between  text-[#ffffff] ml-2  text-[18px] font-productsans' : 'flex flex-row justify-between  text-[#ffffff] ml-2 mr-6 text-[18px] font-productsans'}`}
                  >
                    <div className="flex flex-col justify-between">
                      <p className="mt-2 font-semibold ">Location:</p>
                      <p className="mb-2 font-normal">{data?.venue || 'N/A'}</p>
                    </div>
                    <div className="border-r-[1px] border-r-caption border-color-light mt-4 mb-3"></div>
                    <div className="flex flex-col justify-between ml-3">
                      <p className="mt-2 font-semibold ">Date:</p>
                      <p className="mb-2 font-normal">
                        {formatDate(
                          data?.startDateTime?.substring(0, 10) || 'N/A'
                        )}
                      </p>
                    </div>
                    <div className="border-r-[1px] border-r-caption border-color-light mt-4 mb-3"></div>
                    <div className="flex flex-col justify-between ml-3">
                      <p className="mt-2 font-semibold ">Time:</p>
                      <p className="mb-2 font-normal">
                        {data?.startDateTime
                          ? new Date(data.startDateTime).toLocaleTimeString(
                              'en-US',
                              {
                                hour: '2-digit',
                                minute: '2-digit',
                                hour12: true,
                              }
                            )
                          : ''}
                        {' - '}
                        {data?.endDateTime
                          ? new Date(data.endDateTime).toLocaleTimeString(
                              'en-US',
                              {
                                hour: '2-digit',
                                minute: '2-digit',
                                hour12: true,
                              }
                            )
                          : ''}
                      </p>
                    </div>
                  </div>
                </div>
                <div className="text-[#ffffff] font-productsans font-normal text-[14px] px-2">
                  {data?.description}
                </div>
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    <div className="flex flex-row justify-start py-4 ml-2">
                      <div>
                        {/* <img
                          src={
                            gigdata?.entertainer?.profilePicture ||
                            gigdata?.entertainer?.fullNameOrBusinessName?.charAt(
                              0
                            ) ||
                            'G'
                          }
                          alt="image"
                          className="rounded-md w-12 mt-0.5 h-11"
                          loading="lazy"
                        /> */}

                        {gigdata?.entertainer?.profilePicture ? (
                          <img
                            src={gigdata?.entertainer?.profilePicture || ''}
                            alt="image"
                            className="rounded-md w-12 mt-0.5 h-11"
                            loading="lazy"
                          />
                        ) : (
                          <div className="flex items-center justify-center bg-gray-200 text-gray-600 rounded-md h-11 w-12 text-[20px] font-bold">
                            {gigdata?.entertainer?.fullNameOrBusinessName.charAt(
                              0
                            ) || 'G'}
                          </div>
                        )}
                      </div>
                      <p className="text-start ml-2 font-productsans font-semibold text-[16px]">
                        {gigdata?.entertainer?.fullNameOrBusinessName || 'N/A'}
                        <p className=" font-productsans font-normal text-[14px]">
                          Status : {gigdata?.status || 'N/A'}
                        </p>
                      </p>
                    </div>
                  </Grid.Col>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    {data?.isPublished === false && (
                      <div
                        className={` ${isSmallScreen || isMediumScreen ? 'mb-1  flex flex-row justify-center mt-2' : 'mb-1 mr-2 flex flex-row justify-end mt-2 '}`}
                      >
                        <Button
                          autoContrast
                          m={5}
                          size="sm"
                          styles={{
                            root: {
                              background: '#D83F87',
                            },
                          }}
                          style={{
                            height: 42,
                            width: '70%',
                          }}
                          className="px-2"
                          onClick={() => handlePublish()}
                        >
                          <div className="font-productsans font-normal text-[14px] text-[#ffffff] ">
                            {isLoading ? 'Loading' : 'Publish'}
                          </div>
                        </Button>
                      </div>
                    )}
                  </Grid.Col>
                </Grid>
              </div>
            </Grid.Col>
          </Grid>
        </div>
        <SuccessModal
          opened={paymentSuccess}
          setOpened={setPaymentSuccess}
          isPublished={true}
        />
      </Paper>
    </>
  );
};

export default EventSummary;
