import { Grid, Loader, Paper } from '@mantine/core';
import { IconArrowLeft, IconStarFilled } from '@tabler/icons-react';

// import { Button, Table } from '../../concave.agri/components';
import { useEffect, useState } from 'react';
import {
  useLocation,
  useNavigate,
  useParams,
  useSearchParams,
} from 'react-router-dom';
import { Button } from '../../components';
import { FaCalendarDays } from 'react-icons/fa6';
import { paginationInfoValue } from '../../utils/common/constant.objects';
import { fetchData } from '../../api/api';
import { handleError } from '../../utils/common/function';
import BasicDateCalendar from './calender';
import OfferGigs from './offer-gig';
import { useSelector } from 'react-redux';
const EntertainerProfile = () => {
  const initialPaginationFromQueryParams = () => {
    const rowPerPage =
      searchParams.get('rowPerPage') ?? paginationInfoValue.rowPerPage;
    const currentPage = Number(
      searchParams.get('currentPage') ??
        paginationInfoValue.currentPage?.toString()
    );
    return { ...paginationInfoValue, rowPerPage, currentPage };
  };

  const [accountInfo, setaccountInfo] = useState(false);

  const [searchParams, setSearchParams] = useSearchParams();

  const location = useLocation();

  const [paginationInfo, setPaginationInfo] = useState(
    initialPaginationFromQueryParams()
  );
  useEffect(() => {
    const newPaginationInfo = initialPaginationFromQueryParams();

    if (JSON.stringify(newPaginationInfo) !== JSON.stringify(paginationInfo)) {
      setPaginationInfo(newPaginationInfo);
    }
  }, [searchParams]);
  const navigate = useNavigate();
  const { eventid } = useParams();
  const currency = useSelector(
    (state: any) => state.userInfo?.preferences?.currency?.preferredCurrencyId
  );
  const { id } = useParams();

  const [isLoading, setIsLoading] = useState(false);
  const [data, setData] = useState<any>();

  useEffect(() => {
    if (!id) return;

    setIsLoading(true);

    fetchData(`/users/${id}`)
      .then((response: any) => {
        setData(response);
      })
      .catch((error: any) => {
        handleError(error, 'Failed to fetch user data');
      })
      .finally(() => {
        setIsLoading(false);
      });
  }, [id, currency]);

  const positiveCount = data?.entertainerFeedbacks.filter(
    (feedback: any) => parseFloat(feedback.rating) >= 2
  ).length;

  const formattedCount =
    positiveCount >= 1000
      ? `${(positiveCount / 1000).toFixed(1)}k`
      : positiveCount;
  return (
    <>
      <Paper
        className="flex justify-between items-center p-4 min-h-screen overflow-x-hidden "
        radius={0}
        style={{
          backgroundColor: '#3B1E6D',
          background: 'radial-gradient( #6534BA 43%, #3B1E6D)',
        }}
      >
        {location.pathname ===
          `/upcomingEvents/${eventid}/entertainer-profile/${id}` && (
          <Grid className="mt-6 mr-7 mb-5">
            <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
              <div className="ml-4 text-[26px] font-semibold text-[#ffffff] font-productsans flex flex-row justify-start">
                <span className="mr-2 mt-1">
                  <div
                    className={`rounded-md border-none shadow-sm border bg-color-white bg-opacity-5 w-8 h-8  flex items-center justify-center`}
                  >
                    <IconArrowLeft
                      className=" align-middle select-none bg-transparent text-center transition-all cursor-pointer"
                      color="#ffffff"
                      onClick={() => navigate(-1)}
                      size={20}
                    />
                  </div>
                </span>
                <div>{` Events`}</div>

                <div className="ml-2">{'>'}</div>
                <span className="text-[23px] text-[#ffffff] font-semibold mt-1 ml-2 flex flex-row justify-start">
                  <div> {`Event Details `}</div>

                  <div className="ml-1">{'>'}</div>
                </span>
                <span className="text-[23px] text-[#ffffff] font-semibold mt-1 ml-2">
                  {`Add Entertainers >`}
                </span>
                <span className="text-[23px] text-[#D83F87] font-normal mt-1 ml-2">
                  Entertainer Profile
                </span>
              </div>
            </Grid.Col>
          </Grid>
        )}
        {location.pathname === `/entertainer/entertainer-profile/${id}` && (
          <Grid className="mt-6 mr-7 mb-5">
            <Grid.Col span={{ base: 12, md: 6, lg: 12 }}>
              <div className="ml-4 text-[26px] font-semibold text-[#ffffff] font-productsans flex flex-row justify-start">
                <span className="mr-2 mt-1">
                  <div
                    className={`rounded-md border-none shadow-sm border bg-color-white bg-opacity-5 w-8 h-8  flex items-center justify-center`}
                  >
                    <IconArrowLeft
                      className=" align-middle select-none bg-transparent text-center transition-all cursor-pointer"
                      color="#ffffff"
                      onClick={() => navigate(-1)}
                      size={20}
                    />
                  </div>
                </span>
                {` Entertainers `}
                <div className="ml-2 mt-0.5">{`>`}</div>

                <span className="text-[23px] text-[#D83F87] font-normal mt-1 ml-2">
                  Entertainer Profile
                </span>
              </div>
            </Grid.Col>
          </Grid>
        )}
        <div
          className="rounded-2xl ml-4 mr-2 font-semibold text-[#ffffff] p-4 font-productsans h-[100%] bg-transparent bg-[#ffffff] bg-opacity-5 border border-[#623F9D]"
          style={{ height: 'auto' }}
        >
          <Grid className="mt-4 px-4">
            <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
              <div className="relative w-full px-2 py-2">
                {isLoading ? (
                  <div className="flex items-center justify-center mt-24 w-full h-[256px]">
                    <Loader size="lg" color="#C28CFF" />
                  </div>
                ) : data?.profilePicture ? (
                  <img
                    src={data.profilePicture}
                    alt="Entertainer"
                    className="rounded-md h-[640px] w-full object-cover"
                    loading="lazy"
                  />
                ) : (
                  <div className="flex items-center justify-center bg-gray-200 text-gray-600 rounded-md h-[640px] w-full text-6xl font-bold">
                    {data?.fullNameOrBusinessName?.charAt(0) || 'E'}
                  </div>
                )}
              </div>
            </Grid.Col>
            <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
              <div className="mt-2 mr-8">
                <div className="text-[20px] ml-2 font-productsans font-semibold text-[#F4F4FE]">
                  {data?.fullNameOrBusinessName || 'N/A'}
                </div>
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 5 }}>
                    <div className="flex flex-row justify-between">
                      <a
                        href={data?.faceBookLink}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <div>
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            x="0px"
                            y="0px"
                            width="45"
                            height="45"
                            viewBox="0 0 48 48"
                          >
                            <path
                              fill="#3F51B5"
                              d="M42,37c0,2.762-2.238,5-5,5H11c-2.761,0-5-2.238-5-5V11c0-2.762,2.239-5,5-5h26c2.762,0,5,2.238,5,5V37z"
                            ></path>
                            <path
                              fill="#FFF"
                              d="M34.368,25H31v13h-5V25h-3v-4h3v-2.41c0.002-3.508,1.459-5.59,5.592-5.59H35v4h-2.287C31.104,17,31,17.6,31,18.723V21h4L34.368,25z"
                            ></path>
                          </svg>
                        </div>
                      </a>
                      <a
                        href={data?.instagramLink}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <div>
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            x="0px"
                            y="0px"
                            width="45"
                            height="45"
                            viewBox="0 0 48 48"
                          >
                            <radialGradient
                              id="yOrnnhliCrdS2gy~4tD8ma_Xy10Jcu1L2Su_gr1"
                              cx="19.38"
                              cy="42.035"
                              r="44.899"
                              gradientUnits="userSpaceOnUse"
                            >
                              <stop offset="0" stopColor="#fd5"></stop>
                              <stop offset=".328" stopColor="#ff543f"></stop>
                              <stop offset=".348" stopColor="#fc5245"></stop>
                              <stop offset=".504" stopColor="#e64771"></stop>
                              <stop offset=".643" stopColor="#d53e91"></stop>
                              <stop offset=".761" stopColor="#cc39a4"></stop>
                              <stop offset=".841" stopColor="#c837ab"></stop>
                            </radialGradient>
                            <path
                              fill="url(#yOrnnhliCrdS2gy~4tD8ma_Xy10Jcu1L2Su_gr1)"
                              d="M34.017,41.99l-20,0.019c-4.4,0.004-8.003-3.592-8.008-7.992l-0.019-20	c-0.004-4.4,3.592-8.003,7.992-8.008l20-0.019c4.4-0.004,8.003,3.592,8.008,7.992l0.019,20	C42.014,38.383,38.417,41.986,34.017,41.99z"
                            ></path>
                            <radialGradient
                              id="yOrnnhliCrdS2gy~4tD8mb_Xy10Jcu1L2Su_gr2"
                              cx="11.786"
                              cy="5.54"
                              r="29.813"
                              gradientTransform="matrix(1 0 0 .6663 0 1.849)"
                              gradientUnits="userSpaceOnUse"
                            >
                              <stop offset="0" stopColor="#4168c9"></stop>
                              <stop
                                offset=".999"
                                stopColor="#4168c9"
                                stopOpacity="0"
                              ></stop>
                            </radialGradient>
                            <path
                              fill="url(#yOrnnhliCrdS2gy~4tD8mb_Xy10Jcu1L2Su_gr2)"
                              d="M34.017,41.99l-20,0.019c-4.4,0.004-8.003-3.592-8.008-7.992l-0.019-20	c-0.004-4.4,3.592-8.003,7.992-8.008l20-0.019c4.4-0.004,8.003,3.592,8.008,7.992l0.019,20	C42.014,38.383,38.417,41.986,34.017,41.99z"
                            ></path>
                            <path
                              fill="#fff"
                              d="M24,31c-3.859,0-7-3.14-7-7s3.141-7,7-7s7,3.14,7,7S27.859,31,24,31z M24,19c-2.757,0-5,2.243-5,5	s2.243,5,5,5s5-2.243,5-5S26.757,19,24,19z"
                            ></path>
                            <circle
                              cx="31.5"
                              cy="16.5"
                              r="1.5"
                              fill="#fff"
                            ></circle>
                            <path
                              fill="#fff"
                              d="M30,37H18c-3.859,0-7-3.14-7-7V18c0-3.86,3.141-7,7-7h12c3.859,0,7,3.14,7,7v12	C37,33.86,33.859,37,30,37z M18,13c-2.757,0-5,2.243-5,5v12c0,2.757,2.243,5,5,5h12c2.757,0,5-2.243,5-5V18c0-2.757-2.243-5-5-5H18z"
                            ></path>
                          </svg>
                        </div>
                      </a>
                      <a
                        href={data?.xLink}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <div className="mt-1.5">
                          <svg
                            width="33"
                            height="32"
                            viewBox="0 0 24 24"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                          >
                            <rect width="24" height="24" rx="4" fill="black" />
                            <path
                              fillRule="evenodd"
                              clipRule="evenodd"
                              d="M17.53 3H20L13.93 10.32L21 21H14.87L10.46 14.64L5.65 21H3L9.47 12.17L3 3H9.27L13.27 8.84L17.53 3ZM16.4 19.5H18.1L7.6 4.42H5.76L16.4 19.5Z"
                              fill="white"
                            />
                          </svg>
                        </div>
                      </a>
                      <a
                        href={data?.snapChatLink}
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        <div>
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            x="0px"
                            y="0px"
                            width="45"
                            height="45"
                            viewBox="0 0 48 48"
                          >
                            <linearGradient
                              id="s9~sBE_MLsUutFtX7i6Pra_KrtKMa6Fduil_gr1"
                              x1="20.601"
                              x2="27.399"
                              y1="4.721"
                              y2="43.279"
                              gradientUnits="userSpaceOnUse"
                            >
                              <stop offset="0" stopColor="#fede00"></stop>
                              <stop offset="1" stopColor="#ffd000"></stop>
                            </linearGradient>
                            <path
                              fill="url(#s9~sBE_MLsUutFtX7i6Pra_KrtKMa6Fduil_gr1)"
                              d="M34.017,41.99l-20,0.019c-4.4,0.004-8.003-3.592-8.008-7.992l-0.019-20	c-0.004-4.4,3.592-8.003,7.992-8.008l20-0.019c4.4-0.004,8.003,3.592,8.008,7.992l0.019,20	C42.014,38.383,38.417,41.986,34.017,41.99z"
                            ></path>
                            <path
                              d="M14.613,20.505c-0.168,0-0.342,0.039-0.503,0.12c-0.265,0.132-0.463,0.36-0.557,0.641	c-0.151,0.453,0.004,0.95,0.386,1.236l3.676,2.296l-0.143,0.382c-0.066,0.179-1.67,4.403-4.703,6.057	c-0.161,0.088-0.264,0.206-0.274,0.317c-0.011,0.112,0.078,0.213,0.155,0.277c0.656,0.549,1.334,0.939,2.685,1.187l0.409,0.075	l0.001,0.416c0.002,0.608,0.195,1.251,0.375,1.251c0.893,0,2.751,0,4.608,0.928c1.03,0.515,2.472,0.823,3.271,0.823	s2.241-0.308,3.271-0.823c1.856-0.928,3.715-0.928,4.608-0.928c0.181,0,0.374-0.643,0.375-1.251l0.001-0.416l0.409-0.075	c1.351-0.247,2.029-0.637,2.686-1.187c0.077-0.064,0.166-0.165,0.155-0.277c-0.011-0.111-0.114-0.229-0.274-0.317	c-3.032-1.654-4.636-5.878-4.703-6.057l-0.143-0.382l3.71-2.32c0.347-0.263,0.502-0.759,0.351-1.212	c-0.093-0.281-0.291-0.508-0.556-0.641c-0.264-0.133-0.564-0.153-0.846-0.06l-2.546,1.042V18.1c0-3.636-2.914-6.594-6.496-6.594	c-3.586,0-6.5,2.958-6.5,6.594v3.508l-2.576-1.053C14.828,20.522,14.722,20.505,14.613,20.505z"
                              opacity=".07"
                            ></path>
                            <path
                              fill="none"
                              stroke="#1d1d1b"
                              strokeWidth="2"
                              d="M24,37.011c0.868,0,2.387-0.322,3.494-0.875 c1.751-0.875,3.509-0.875,4.384-0.875c0.875,0,0.875-1.751,0.875-1.751c1.391-0.254,2.156-0.658,2.917-1.295 c0.531-0.445,0.407-1.085-0.201-1.416c-2.903-1.583-4.474-5.793-4.474-5.793l3.364-2.104c0.554-0.415,0.779-1.138,0.561-1.795l0,0 c-0.281-0.843-1.193-1.298-2.035-1.016l-1.887,0.771V18.1c0-3.864-3.132-7.094-6.996-7.094h0h-0.004h0 c-3.864,0-6.996,3.23-6.996,7.094v2.763l-1.887-0.771c-0.843-0.282-1.754,0.173-2.035,1.016l0,0 c-0.219,0.656,0.007,1.379,0.561,1.795l3.364,2.104c0,0-1.57,4.209-4.474,5.793c-0.608,0.331-0.732,0.972-0.201,1.416 c0.76,0.637,1.526,1.041,2.917,1.295c0,0,0,1.751,0.875,1.751c0.875,0,2.633,0,4.384,0.875C21.613,36.689,23.132,37.011,24,37.011"
                              opacity=".05"
                            ></path>
                            <path
                              fill="none"
                              stroke="#000"
                              d="M24,37.011c0.868,0,2.387-0.322,3.494-0.875 c1.751-0.875,3.509-0.875,4.384-0.875c0.875,0,0.875-1.751,0.875-1.751c1.391-0.254,2.156-0.658,2.917-1.295 c0.531-0.445,0.407-1.085-0.201-1.416c-2.903-1.583-4.474-5.793-4.474-5.793l3.364-2.104c0.554-0.415,0.779-1.138,0.561-1.795l0,0 c-0.281-0.843-1.193-1.298-2.035-1.016l-1.887,0.771V18.1c0-3.864-3.132-7.094-6.996-7.094h0h-0.004h0 c-3.864,0-6.996,3.23-6.996,7.094v2.763l-1.887-0.771c-0.843-0.282-1.754,0.173-2.035,1.016l0,0 c-0.219,0.656,0.007,1.379,0.561,1.795l3.364,2.104c0,0-1.57,4.209-4.474,5.793c-0.608,0.331-0.732,0.972-0.201,1.416 c0.76,0.637,1.526,1.041,2.917,1.295c0,0,0,1.751,0.875,1.751c0.875,0,2.633,0,4.384,0.875C21.613,36.689,23.132,37.011,24,37.011"
                              opacity=".07"
                            ></path>
                            <path
                              fill="#fff"
                              d="M24,37.011c0.868,0,2.387-0.322,3.494-0.875c1.751-0.875,3.509-0.875,4.384-0.875	c0.875,0,0.875-1.751,0.875-1.751c1.391-0.254,2.156-0.658,2.917-1.295c0.531-0.445,0.407-1.085-0.201-1.416	c-2.903-1.583-4.474-5.793-4.474-5.793l3.364-2.104c0.554-0.415,0.779-1.138,0.561-1.795l0,0c-0.281-0.843-1.193-1.298-2.035-1.016	l-1.887,0.771V18.1c0-3.864-3.132-7.094-6.996-7.094h0h-0.004h0c-3.864,0-6.996,3.23-6.996,7.094v2.763l-1.887-0.771	c-0.843-0.282-1.754,0.173-2.035,1.016l0,0c-0.219,0.656,0.007,1.379,0.561,1.795l3.364,2.104c0,0-1.57,4.209-4.474,5.793	c-0.608,0.331-0.732,0.972-0.201,1.416c0.76,0.637,1.526,1.041,2.917,1.295c0,0,0,1.751,0.875,1.751c0.875,0,2.633,0,4.384,0.875	C21.613,36.689,23.132,37.011,24,37.011"
                            ></path>
                          </svg>
                        </div>
                      </a>
                    </div>
                  </Grid.Col>
                </Grid>
                <div className=" w-auto h-auto  rounded-lg mb-3  mr-2 ">
                  <div
                    className={`flex flex-row justify-between  text-[#ffffff] ml-2 mr-6 text-[18px] font-productsans`}
                  >
                    <div className="flex flex-col justify-between">
                      <p className="mt-2 font-semibold ">Entertainer Type:</p>
                      <p className="mb-2 font-normal">
                        {data?.entertainerType?.name || 'N/A'}
                      </p>
                    </div>
                    <div className="border-r-[1px] border-r-caption border-color-light mt-4 mb-3"></div>
                    <div className="flex flex-col justify-between">
                      <p className="mt-2 font-semibold ">Rate/Price:</p>
                      <p className="mb-2 font-normal">
                        {` ${currency === '1' ? '$' : 'BHD ≈'} ${data?.ratePerHour || 'N/A'} `}
                        /hr
                      </p>
                    </div>
                    <div className="border-r-[1px] border-r-caption border-color-light mt-4 mb-3"></div>
                    <div className="flex flex-col justify-between">
                      <p className="mt-2 font-semibold ">Location:</p>
                      <p className="mb-2 font-normal">
                        {data?.address || 'N/A'}
                      </p>
                    </div>
                  </div>
                </div>
                <div className="text-[#ffffff] font-productsans font-normal text-[14px] px-2">
                  {data?.bio || 'N/A'}
                </div>
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 6 }}>
                    {location.pathname !==
                      `/entertainer/entertainer-profile/${id}` && (
                      <div className=" mb-1 mr-2 flex flex-row justify-between">
                        <Button
                          autoContrast
                          m={5}
                          size="sm"
                          styles={{
                            root: {
                              background: '#D83F87',
                            },
                          }}
                          style={{
                            height: 42,
                            width: '100%',
                          }}
                          className="px-2"
                          onClick={() => setaccountInfo(true)}
                        >
                          <div className="font-productsans font-normal text-[14px] text-[#ffffff] ">
                            Offer Gig Now
                          </div>
                        </Button>
                      </div>
                    )}
                  </Grid.Col>
                </Grid>
                <Grid>
                  <Grid.Col span={{ base: 12, md: 12, lg: 8 }}>
                    <div className="flex flex-row justify-between">
                      <div className="text-[#ffffff] font-productsans text-[14px] px-3 py-2 font-semibold flex flex-row justify-normal">
                        <div>
                          <FaCalendarDays size={20} color="#D83F87" />
                        </div>
                        <div className="ml-2 "> Available Date:</div>
                      </div>
                      <div className="text-[#ffffff] font-productsans text-[12px] py-3 font-normal flex flex-row justify-normal">
                        <div className="rounded-full w-3 h-3 bg-[#D83F87] mt-0.5"></div>
                        <p className="px-1.5">Booked</p>
                        <div className="rounded-full w-3 h-3 bg-[#7B7B7B] ml-1 mt-0.5"></div>
                        <p className="px-1.5">Unavailable</p>
                      </div>
                    </div>
                    <div className="border border-[#ffffff] rounded-lg w-[100%]">
                      <BasicDateCalendar />
                    </div>
                  </Grid.Col>
                </Grid>
              </div>
            </Grid.Col>
          </Grid>
          <Grid className=" mr-7 py-2">
            <Grid.Col
              span={{ base: 12, md: 12, lg: 12 }}
              className="flex flex-row justify-between"
            >
              <div className="text-[#ffffff] font-productsans text-[16px] px-7 py-5 font-semibold">
                Reviews:
              </div>
              <div className="text-[#ffffff] font-productsans text-[16px] px-7 py-5 font-normal">
                🔥 {formattedCount} Positive Feedback
              </div>
            </Grid.Col>
          </Grid>

          <Grid
            className="flex flex-row justify-between py-2 px-6"
            gutter={'md'}
            align="stretch"
          >
            {isLoading ? (
              <div
                className="flex items-center justify-center ml-96 mt-20 mb-9"
                style={{ marginLeft: '45%' }}
              >
                <Loader size="lg" color="#C28CFF" />
              </div>
            ) : (data?.entertainerFeedbacks?.length ?? 0) === 0 ? (
              <div className="text-center w-full py-6 text-[#ffffff] font-pt">
                No reviews available
              </div>
            ) : (
              data?.entertainerFeedbacks?.map((item: any) => (
                <Grid.Col key={item.id} span={{ base: 12, md: 6, lg: 3 }}>
                  <div className="h-full flex flex-col justify-between rounded-md bg-[#D83F87] p-3 text-white">
                    <div className="mb-4">“{item?.comment}”</div>

                    <div className="flex flex-row justify-between items-end mt-auto">
                      <div className="font-productsans text-[15px] font-semibold">
                        <p>{item?.entertainer?.fullNameOrBusinessName}</p>
                        <p className="text-[13px] font-normal">
                          {item?.entertainer?.bio}
                        </p>
                      </div>
                      <div className="flex flex-row items-center font-normal text-white">
                        <div className="text-[19px] mr-1">{item?.rating}</div>
                        <IconStarFilled size={17} color="#ffffff" />
                      </div>
                    </div>
                  </div>
                </Grid.Col>
              ))
            )}
          </Grid>

          <Grid className="mr-7">
            <Grid.Col span={{ base: 12, md: 12, lg: 4 }}>
              <div className="text-[#ffffff] font-productsans text-[16px] px-7 py-5 font-semibold">
                Portfolio
              </div>
            </Grid.Col>
          </Grid>
          <Grid
            className="flex flex-row justify-between py-2 px-6 "
            gutter={'lg'}
          >
            {isLoading ? (
              <div
                className="flex items-center justify-center ml-96 mt-20 mb-9"
                style={{ marginLeft: '45%' }}
              >
                <Loader size="lg" color="#C28CFF" />
              </div>
            ) : (data?.portfolioImages?.length ?? 0) === 0 ? (
              <div className="text-center w-full py-6 text-[#ffffff] font-pt">
                No images available
              </div>
            ) : (
              data?.portfolioImages?.map((url: string, index: number) => (
                <Grid.Col key={index} span={{ base: 12, md: 6, lg: 3 }}>
                  <div className="cursor-pointer flex space-x-2">
                    <div>
                      <img
                        src={url}
                        alt={`portfolio-image-${index}`}
                        className="w-[360px] h-[180px] object-cover rounded-md"
                        loading="lazy"
                      />
                    </div>
                  </div>
                </Grid.Col>
              ))
            )}
          </Grid>
        </div>
        <OfferGigs
          opened={accountInfo}
          setOpened={setaccountInfo}
          eventid={eventid}
        />
      </Paper>
    </>
  );
};

export default EntertainerProfile;
