import { Modal, RangeSlider, Slider, Text, Button } from '@mantine/core';
import { useSelector } from 'react-redux';
import { useState } from 'react';
import { fetchData, postData } from '../../api/api';
import { handleError, handleSuccess } from '../../utils/common/function';
import { useParams } from 'react-router-dom';
import { useFormik } from 'formik';
import * as Yup from 'yup';

const BoostListingDetails = ({ opened, setOpened, eventData }: any) => {
  const { userInfo } = useSelector((state: any) => state?.userInfo);
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const currentRole = userInfo?.roleId;

  const [isLoading, setIsLoading] = useState(false);

  const formik = useFormik({
    enableReinitialize: true,
    initialValues: {
      targetAgeRange: {
        min: eventData?.targetAgeRange?.min ?? 0,
        max: eventData?.targetAgeRange?.max ?? 2,
      },
      targetRadiusInKM: eventData?.targetRadiusInKM ?? 0,
    },
    validationSchema: Yup.object().shape({}),
    onSubmit: values => {
      setIsLoading(true);
      const eventId = eventData?.id;

      postData(`/events/${eventId}/boost`, values)
        .then(() => {
          handleSuccess('Boost successfully');
          formik.resetForm();
          setTimeout(() => {
            setOpened(false);
          }, 1000);
        })
        .catch((error: any) => {
          handleError(error);
        })
        .finally(() => {
          setIsLoading(false);
        });
    },
  });
  console.log(formik.errors, 'error');
  const resetAndClose = () => {
    formik.resetForm();
    setOpened(false);
  };

  const handleClose = () => {
    resetAndClose();
  };
  const marks = [
    { value: 0, label: 0 },
    { value: 25 },
    { value: 50 },
    { value: 75 },
    { value: 80, label: 80 },
  ];
  return (
    <Modal
      opened={opened}
      centered
      size="27%"
      onClose={() => setOpened(false)}
      withCloseButton={false}
      styles={{
        content: {
          borderRadius: '15px',
          backgroundColor: '#6D3EBD',
          padding: 10,
        },
        body: {
          padding: 20,
        },
        inner: {
          padding: 0,
          margin: 0,
          maxWidth: '100vw',
        },
      }}
      overlayProps={{
        backgroundOpacity: 0.55,
        blur: 3,
      }}
      transitionProps={{ transition: 'fade-up', duration: 300 }}
      title=""
    >
      <form onSubmit={formik.handleSubmit} className="relative w-full">
        <div className="relative w-full flex flex-row justify-between">
          <div className=" text-[#ffffff] font-semibold font-productsans text-[18px] -ml-1">
            Boost Listing
          </div>
          <Modal.CloseButton
            onClick={() => handleClose()}
            style={{
              position: 'absolute',
              top: -4,
              right: -6,
              border: 'none',
              outline: 'none',
              boxShadow: 'none',
              color: '#ffffff',
              backgroundColor: 'transparent',
              transition: 'background-color 0.2s ease-in-out',
              width: 33,
              height: 33,
            }}
          />
        </div>

        {/* Sliders Section */}
        <div className="flex flex-col gap-8 mt-6 text-color-white">
          {/* Radius Slider */}
          <div>
            <Text size="md" fw={500}>
              Area Range
            </Text>
            <Slider
              value={formik.values.targetRadiusInKM}
              onChange={val => formik.setFieldValue('targetRadiusInKM', val)}
              min={0}
              max={1000}
              marks={[
                { value: 0, label: '0 KM' },
                { value: 150 },
                { value: 550 },
                { value: 950 },
                { value: 1000, label: '1000 KM' },
              ]}
              color="pink"
              thumbSize={16}
              className="mt-4"
              styles={{
                markLabel: {
                  color: 'white',
                  paddingTop: '3px',
                },
                mark: {
                  borderColor: '#ff66a3',
                  backgroundColor: 'white',
                },
              }}
            />
          </div>

          <div className="mt-2 mb-2">
            <Text size="md" fw={500}>
              Age Range
            </Text>
            <RangeSlider
              value={[
                formik.values.targetAgeRange.min,
                formik.values.targetAgeRange.max,
              ]}
              onChange={val =>
                formik.setFieldValue('targetAgeRange', {
                  min: val[0],
                  max: val[1],
                })
              }
              min={0}
              max={80}
              marks={marks}
              color="pink"
              thumbSize={16}
              className="mt-4"
              styles={{
                markLabel: {
                  color: 'white',
                },
                mark: {
                  borderColor: '#ff66a3',
                  backgroundColor: 'white',
                },
              }}
            />
          </div>
          {currentRole === '1' && eventData?.isApproved === true && (
            <Button
              type="submit"
              color="pink"
              className="mt-6"
              fullWidth
              loading={isLoading}
              onClick={() => {
                formik.handleSubmit();
              }}
            >
              Boost
            </Button>
          )}
        </div>
      </form>
    </Modal>
  );
};

export default BoostListingDetails;
