import Highcharts from 'highcharts';
import HighchartsReact from 'highcharts-react-official';

const SalesReport = ({
  data,
}: {
  data: { categories: string[]; values: number[] };
}) => {
  const hasData = data?.values?.length > 0;

  const fallbackCategories = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'];
  const fallbackValues = new Array(fallbackCategories.length).fill(0);

  const options = {
    chart: {
      type: 'spline',
      backgroundColor: 'transparent',
      height: '345px',
    },
    title: {
      text: '',
    },
    xAxis: {
      categories: hasData ? data.categories : fallbackCategories,
      gridLineColor: '#824DDD',
      labels: {
        style: {
          color: '#ABADBF',
          fontWeight: 'normal',
        },
      },
      crosshair: {
        color: 'transparent',
        width: 0,
      },
    },
    yAxis: {
      title: {
        text: '',
      },
      gridLineColor: '#824DDD',
      labels: {
        style: {
          color: '#ABADBF',
          fontWeight: 'normal',
        },
      },
    },
    tooltip: {
      crosshairs: true,
      shared: true,
    },
    plotOptions: {
      spline: {
        marker: {
          radius: 6,
          lineColor: '#000000',
          lineWidth: 1,
        },
      },
    },
    legend: {
      enabled: false,
    },
    series: [
      {
        color: '#8640FD',
        name: 'Sales',
        lineWidth: 5,
        marker: {
          color: '#000000',
          symbol: 'circle',
          radius: 6,
          fillColor: '#418F90',
          lineColor: '#ffffff',
          lineWidth: 4,
        },
        data: hasData ? data.values : fallbackValues,
      },
    ],
  };

  return <HighchartsReact highcharts={Highcharts} options={options} />;
};

export default SalesReport;
