/* eslint-disable no-useless-escape */

// import { isValidPhoneNumber } from 'libphonenumber-js';
import * as Yup from 'yup';

export const validationSchema = Yup.object({
  fullNameOrBusinessName: Yup.string()
    .min(2, 'Must be at least 2 characters')
    .max(100, 'Must be at most 100 characters')
    .required('Full name or business name is required'),

  email: Yup.string()
    .email('Invalid email address')
    .required('Email is required'),

  // bio: Yup.string().max(500, 'Bio must be under 500 characters'),

  // address: Yup.string().required('Address is required'),

  // city: Yup.string().required('City is required'),

  // country: Yup.string().required('Country is required'),

  // zipCode: Yup.string()
  //   .matches(/^\d{4,10}$/, 'Invalid Zip Code')
  //   .required('Zip Code is required'),

  // phoneNumber: Yup.string()
  //   .required('Phone number is required')
  //   .test(
  //     'is-valid-phone',
  //     'Invalid phone number',
  //     value => !!value && isValidPhoneNumber(value)
  //   ),

  // taxId: Yup.string().required('Tax ID is required'),

  // businessDocumentType: Yup.string().required('Document type is required'),

  // taxIdDocumentUrl: Yup.string().when(
  //   'businessDocumentType',
  //   (businessDocumentType: any, schema: any): any => {
  //     return businessDocumentType === 'ein'
  //       ? schema.required('Tax ID document is required for EIN')
  //       : schema;
  //   }
  // ),

  // crNumber: Yup.string().when(
  //   'businessDocumentType',
  //   (businessDocumentType: any, schema: any) => {
  //     return businessDocumentType === 'cr'
  //       ? schema.required('CR Number is required')
  //       : schema;
  //   }
  // ),
});

export const initialValues = {
  fullNameOrBusinessName: '',
  email: '',
  bio: '',
  address: '',
  city: '',
  country: '',
  zipCode: '',
  phoneNumber: '',
  taxId: '',
  businessDocumentType: 'ein',
  taxIdDocumentUrl: '',
  roleId: '3',
  crNumber: '',
  businessWebsite: '',
  gmbProfile: '',
};

export const initialValueForEntertainer = {
  firstName: '',
  lastName: '',
  stageName: '',
  dateOfBirth: null,
  email: '',
  phoneNumber: '',
  gender: '',
  roleId: '2',
};

export const validationSchemaForEntertainer = Yup.object({
  firstName: Yup.string()
    .min(2, 'First name must be at least 2 characters')
    .max(50, 'First name must be at most 50 characters')
    .required('First name is required'),

  lastName: Yup.string()
    .min(2, 'Last name must be at least 2 characters')
    .max(50, 'Last name must be at most 50 characters')
    .required('Last name is required'),

  // stageName: Yup.string().max(50, 'Stage name must be at most 50 characters'),

  // dateOfBirth: Yup.date()
  //   .nullable()
  //   .max(new Date(), 'Date of birth cannot be in the future')
  //   .required('Date of birth is required'),

  email: Yup.string()
    .email('Invalid email address')
    .required('Email is required'),

  // phoneNumber: Yup.string()
  //   .required('Phone number is required')
  //   .test(
  //     'is-valid-phone',
  //     'Invalid phone number',
  //     value => !!value && isValidPhoneNumber(value)
  //   ),

  // gender: Yup.string()
  //   .oneOf(['Male', 'Female', 'Other'], 'Invalid gender')
  //   .required('Gender is required'),
});
