import { Grid, Select, Stepper, useMantineTheme } from '@mantine/core';
import { DatePickerInput } from '@mantine/dates';
import {
  IconAddressBook,
  IconCalendar,
  IconChevronDown,
  IconInfoCircle,
  IconMail,
  IconPhone,
  IconUser,
} from '@tabler/icons-react';
import { useFormik } from 'formik';
import { useEffect, useState } from 'react';
import { LuUserRound } from 'react-icons/lu';
import { postData } from '../../api/api';
import { default as leftBackgroundImageSrc } from '../../assets/images/leftImage.png';
import backgroundImageSrc from '../../assets/images/login bg img.jpg';
import logo from '../../assets/images/muv-logo.svg';
import { TextInput } from '../../components';
import useScreenSize from '../../hooks/useScreenSize';
import { inputStyle } from '../../theme/common.style';
import { initialNotification } from '../../utils/common/constant.objects';
import {
  initialValueForEntertainer,
  validationSchemaForEntertainer,
} from './constant';
import { useNavigate } from 'react-router-dom';
import {
  cleanObject,
  handleError,
  handleSuccess,
} from '../../utils/common/function';

// Preload the background image
const backgroundImage = new Image();
// eslint-disable-next-line @typescript-eslint/no-require-imports
backgroundImage.src = backgroundImageSrc;

const leftBackgroundImage = new Image();

// eslint-disable-next-line @typescript-eslint/no-require-imports
leftBackgroundImage.src = leftBackgroundImageSrc;

// LoginPage function component
export function EntertainerSignupPage() {
  // Initialize theme hook
  const theme = useMantineTheme();
  const navigate = useNavigate();
  const { isLargeScreen } = useScreenSize();

  const [isLoading, setIsLoading] = useState(false);
  const [imagesLoaded, setImagesLoaded] = useState({
    background: false,
    leftBackground: false,
  });

  useEffect(() => {
    // Preload the background image
    const backgroundImage = new Image();
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    backgroundImage.src = backgroundImageSrc;

    const leftBackgroundImage = new Image();
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    leftBackgroundImage.src = leftBackgroundImageSrc;
    backgroundImage.onload = () => {
      setImagesLoaded(prev => ({ ...prev, background: true }));
    };
    leftBackgroundImage.onload = () => {
      setImagesLoaded(prev => ({ ...prev, leftBackground: true }));
    };
  }, []);

  // Initialize formik for form handling
  const formik = useFormik({
    initialValues: initialValueForEntertainer,
    validationSchema: validationSchemaForEntertainer,
    onSubmit: values => {
      setIsLoading(true);
      postData('users', cleanObject(values))
        .then(() => {
          handleSuccess(
            'Account created successfully. Please wait we are verifying your account.'
          );
          navigate('/');
        })
        .catch(error => {
          handleError(error, 'Failed to fetch table data');
        })
        .finally(() => {
          setIsLoading(false);
        });
    },
  });

  const [active, setActive] = useState(0);
  const [highestStepVisited, setHighestStepVisited] = useState(active);

  // Add this validation function
  const validateCurrentStep = (step: number) => {
    switch (step) {
      case 0: // Personal Information step
        if (
          !formik.values.firstName ||
          formik.errors.firstName ||
          !formik.values.lastName ||
          formik.errors.lastName
        ) {
          formik.setFieldTouched('firstName', true);
          formik.setFieldTouched('lastName', true);
          return false;
        }
        return true;
      case 1: // Contact Information step
        if (
          // !formik.values.dateOfBirth ||
          // formik.errors.dateOfBirth ||
          !formik.values.email ||
          formik.errors.email
        ) {
          // formik.setFieldTouched('dateOfBirth', true);
          formik.setFieldTouched('email', true);
          return false;
        }
        return true;
      case 2: // Additional Information step
        // if (
        //   !formik.values.phoneNumber ||
        //   formik.errors.phoneNumber ||
        //   !formik.values.gender ||
        //   formik.errors.gender
        // ) {
        //   formik.setFieldTouched('phoneNumber', true);
        //   formik.setFieldTouched('gender', true);
        //   return false;
        // }
        return true;
      default:
        return true;
    }
  };

  // Modify the handleStepChange function to include validation
  const handleStepChange = (nextStep: number) => {
    const isOutOfBounds = nextStep > 3 || nextStep < 0;

    if (isOutOfBounds) {
      return;
    }

    // Validate current step before proceeding to next
    if (nextStep > active) {
      const isValid = validateCurrentStep(active);
      if (!isValid) {
        return;
      }
    }

    setActive(nextStep);
    setHighestStepVisited(hSC => Math.max(hSC, nextStep));
  };
  // Allow the user to freely go back and forth between visited steps.
  const shouldAllowSelectStep = (step: number) =>
    highestStepVisited >= step && active !== step;

  return imagesLoaded?.background && imagesLoaded.leftBackground ? (
    isLargeScreen ? (
      <>
        <div className="flex justify-between items-stretch h-[100vh]">
          <div className="flex items-center justify-center flex-1 h-full">
            <video
              src={'/loginpage.mp4'}
              className="object-cover w-full h-full"
              autoPlay
              loop
              muted
              playsInline
            ></video>
          </div>
          <div
            className="relative flex-1 bg-cover bg-no-repeat bg-center bg-[#3B1E6D] h-screen items-center justify-center flex bg-gradient-to-br
from-[#563097]
via-[#3B1E6D]
to-[#563097]"
          >
            <div className="flex flex-col items-center w-full max-w-[500px] px-5">
              <img
                src={logo}
                alt=""
                className="max-h-full h-[92px] w-[226px] mb-[10px] mt-[30px]"
              />
              <div className="text-[#ffffff] text-[36px] font-bold font-productsans leading-[49.7px] mt-3">
                SIGNUP
              </div>
              <form
                className="w-full flex flex-col gap-4 mt-[45px]"
                onSubmit={formik.handleSubmit}
              >
                <div className="pb-6">
                  <Stepper
                    active={active}
                    onStepClick={setActive}
                    styles={{
                      stepIcon: {
                        borderColor: '#D83F87',
                        backgroundColor: '#D83F87',
                      },
                      separator: {
                        backgroundColor: '#D83F87',
                      },
                    }}
                  >
                    {/* Step 1: Personal Information */}
                    <Stepper.Step
                      icon={<IconInfoCircle size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(0)}
                    >
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-6 custom-input"
                            label="First Name"
                            placeholder="Enter your first name"
                            name="firstName"
                            value={formik.values.firstName}
                            leftSection={
                              <LuUserRound
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: string) =>
                              formik.setFieldValue('firstName', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.firstName &&
                              formik.errors.firstName
                            }
                          />
                        </Grid.Col>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-6 custom-input"
                            label="Last Name"
                            placeholder="Enter your last name"
                            name="lastName"
                            value={formik.values.lastName}
                            leftSection={
                              <LuUserRound
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: string) =>
                              formik.setFieldValue('lastName', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.lastName && formik.errors.lastName
                            }
                          />
                        </Grid.Col>
                      </Grid>
                      <TextInput
                        className="mt-6 custom-input"
                        label="Stage Name"
                        placeholder="Enter your stage name"
                        name="stageName"
                        value={formik.values.stageName}
                        leftSection={
                          <LuUserRound
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        onChange={(value: string) =>
                          formik.setFieldValue('stageName', value)
                        }
                        radius="6px"
                        styles={inputStyle}
                        error={
                          formik.touched.stageName && formik.errors.stageName
                        }
                      />
                    </Stepper.Step>

                    {/* Step 2: Contact Information */}
                    <Stepper.Step
                      icon={<IconUser size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(1)}
                    >
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                          <DatePickerInput
                            className="mt-6 custom-input"
                            label="Date of Birth"
                            placeholder="Select your date of birth"
                            name="dateOfBirth"
                            value={formik.values.dateOfBirth}
                            onChange={(value: Date | null) =>
                              value &&
                              formik.setFieldValue('dateOfBirth', value)
                            }
                            styles={{
                              label: {
                                fontWeight: '400',
                                fontSize: '16px',
                                color: '#ffffff',
                                marginBottom: '0',
                                fontFamily: 'Product Sans',
                                position: 'absolute',
                                top: '-14px',
                                left: '18px',
                                backgroundColor: '#3B1E6D',
                                padding: '0 8px',
                                zIndex: 1,
                              },
                              input: {
                                backgroundColor: 'transparent',
                                color: '#ffffff',
                                border: '1px solid #ffffff',
                                height: '60.84px',
                                paddingLeft: '60px',
                                paddingRight: '40px',
                                width: '100%',
                                fontFamily: 'Product Sans',
                              },
                              root: {
                                position: 'relative',
                                maxWidth: '100%',
                                marginBottom: '16px',
                              },
                            }}
                            radius="6px"
                            leftSection={
                              <IconCalendar
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            error={
                              formik.touched.dateOfBirth &&
                              formik.errors.dateOfBirth
                            }
                          />
                        </Grid.Col>

                        <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                          <TextInput
                            className="custom-input"
                            label="Email"
                            placeholder="Enter your email address"
                            name="email"
                            value={formik.values.email}
                            leftSection={
                              <IconMail
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: string) =>
                              formik.setFieldValue('email', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={formik.touched.email && formik.errors.email}
                          />
                        </Grid.Col>
                      </Grid>
                    </Stepper.Step>

                    {/* Step 3: Additional Information */}
                    <Stepper.Step
                      icon={<IconAddressBook size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(2)}
                    >
                      <TextInput
                        className="mt-8 custom-input"
                        label="Phone Number"
                        placeholder="Enter phone number"
                        name="phoneNumber"
                        value={formik.values.phoneNumber}
                        hideControls
                        leftSection={
                          <IconPhone
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        onChange={(value: string) =>
                          formik.setFieldValue('phoneNumber', value)
                        }
                        radius="6px"
                        styles={{
                          label: {
                            fontWeight: '400',
                            fontSize: '16px',
                            color: '#ffffff',
                            marginBottom: '0',
                            fontFamily: 'Product Sans',
                            position: 'absolute',
                            top: '-14px',
                            left: '18px',
                            backgroundColor: '#3B1E6D',
                            padding: '0 8px',
                            zIndex: 1,
                          },
                          input: {
                            backgroundColor: 'transparent',
                            color: '#ffffff',
                            border: '1px solid #ffffff',
                            height: '60.84px',
                            paddingLeft: '60px',
                            paddingRight: '40px',
                            width: '100%',
                            fontFamily: 'Product Sans',
                          },
                          root: {
                            position: 'relative',
                            maxWidth: '100%',
                            marginBottom: '16px',
                          },
                        }}
                        error={
                          formik.touched.phoneNumber &&
                          formik.errors.phoneNumber
                        }
                      />

                      <Select
                        className="mt-8 custom-input"
                        label="Gender"
                        placeholder="Select Gender"
                        name="gender"
                        value={formik.values.gender}
                        data={['Male', 'Female', 'Other']}
                        leftSection={
                          <IconUser
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        rightSection={
                          <IconChevronDown
                            size={20}
                            color="#ffffff"
                            className="mr-3"
                          />
                        }
                        onChange={(value: string | null) => {
                          if (value) formik.setFieldValue('gender', value);
                        }}
                        radius="6px"
                        styles={{
                          label: {
                            fontWeight: '400',
                            fontSize: '16px',
                            color: '#ffffff',
                            marginBottom: '0',
                            fontFamily: 'Product Sans',
                            position: 'absolute',
                            top: '-14px',
                            left: '18px',
                            backgroundColor: '#3B1E6D',
                            padding: '0 8px',
                            zIndex: 1,
                          },
                          input: {
                            backgroundColor: 'transparent',
                            color: '#ffffff',
                            border: '1px solid #ffffff',
                            height: '60.84px',
                            paddingLeft: '60px',
                            paddingRight: '40px',
                            width: '100%',
                            fontFamily: 'Product Sans',
                          },
                          root: {
                            position: 'relative',
                            maxWidth: '100%',
                            marginBottom: '16px',
                          },
                        }}
                        error={formik.touched.gender && formik.errors.gender}
                      />
                    </Stepper.Step>

                    {/* Completion Step */}
                    <Stepper.Completed>
                      <div className="text-[#ffffff]">
                        Completed, click back button to get to previous step
                      </div>
                    </Stepper.Completed>
                  </Stepper>
                </div>

                {/* Navigation Buttons */}
                <div className="-mt-[17px] mb-[4px] flex flex-col items-center">
                  <div className="flex space-x-4">
                    {active > 0 && (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#6B7280] py-2 px-5 text-center text-sm text-[#ffffff] shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active - 1)}
                        style={{ color: '#ffffff' }}
                      >
                        Previous
                      </button>
                    )}

                    {active < 3 ? (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#D83F87] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active + 1)}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                      >
                        {isLoading ? 'Loading' : 'Next'}
                      </button>
                    ) : (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#10B981] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => formik.handleSubmit()}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                      >
                        {isLoading ? 'Submitting...' : 'Submit'}
                      </button>
                    )}
                  </div>
                </div>
              </form>
              <div
                className="ml-3 mt-2 cursor-pointer underline font-productsans text-[#fff] text-[12px] sm:text-[14px] font-normal"
                onClick={() => navigate('/')}
              >
                Login
              </div>
            </div>
          </div>
        </div>
      </>
    ) : (
      <>
        <div className="flex flex-col items-stretch justify-between h-auto lg:flex-row">
          {/* Right Form Section */}
          <div
            className="flex-1 bg-cover bg-no-repeat bg-center h-auto lg:h-screen min-h-screen flex items-center justify-center bg-[#3B1E6D] bg-gradient-to-br
from-[#563097]
via-[#3B1E6D]
to-[#563097] "
          >
            <div className="flex flex-col items-center w-full max-w-[500px] px-5">
              {/* Logo */}
              <img
                src={logo}
                alt="Logo"
                className="max-h-[80px] w-auto mb-5 mt-[20px] "
              />
              {/* Title */}
              <h1 className="text-[#ffffff] text-[28px] sm:text-[36px] font-bold font-productsans text-center">
                SIGNUP
              </h1>

              {/* Form */}
              <form
                className="w-full flex flex-col gap-4 mt-[45px]"
                onSubmit={formik.handleSubmit}
              >
                <div className="pb-6">
                  <Stepper
                    active={active}
                    onStepClick={setActive}
                    styles={{
                      stepIcon: {
                        borderColor: '#D83F87',
                        backgroundColor: '#D83F87',
                      },
                      separator: {
                        backgroundColor: '#D83F87',
                      },
                    }}
                  >
                    {/* Step 1: Personal Information */}
                    <Stepper.Step
                      icon={<IconInfoCircle size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(0)}
                    >
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-6 custom-input"
                            label="First Name"
                            placeholder="Enter your first name"
                            name="firstName"
                            value={formik.values.firstName}
                            leftSection={
                              <LuUserRound
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={e => formik.setFieldValue('firstName', e)}
                            onBlur={formik.handleBlur}
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.firstName &&
                              formik.errors.firstName
                            }
                          />
                        </Grid.Col>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-6 custom-input"
                            label="Last Name"
                            placeholder="Enter your last name"
                            name="lastName"
                            value={formik.values.lastName}
                            leftSection={
                              <LuUserRound
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={e => formik.setFieldValue('lastName', e)}
                            onBlur={formik.handleBlur}
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.lastName && formik.errors.lastName
                            }
                          />
                        </Grid.Col>
                      </Grid>
                      <TextInput
                        className="mt-6 custom-input"
                        label="Stage Name"
                        placeholder="Enter your stage name"
                        name="stageName"
                        value={formik.values.stageName}
                        leftSection={
                          <LuUserRound
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        onChange={e => formik.setFieldValue('stageName', e)}
                        onBlur={formik.handleBlur}
                        radius="6px"
                        styles={inputStyle}
                        error={
                          formik.touched.stageName && formik.errors.stageName
                        }
                      />
                    </Stepper.Step>

                    {/* Step 2: Contact Information */}
                    <Stepper.Step
                      icon={<IconUser size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(1)}
                    >
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                          <DatePickerInput
                            className="mt-6 custom-input"
                            label="Date of Birth"
                            placeholder="Select your date of birth"
                            name="dateOfBirth"
                            value={formik.values.dateOfBirth}
                            onChange={value =>
                              formik.setFieldValue('dateOfBirth', value)
                            }
                            onBlur={formik.handleBlur}
                            styles={{
                              label: {
                                fontWeight: '400',
                                fontSize: '16px',
                                color: '#ffffff',
                                marginBottom: '0',
                                fontFamily: 'Product Sans',
                                position: 'absolute',
                                top: '-14px',
                                left: '18px',
                                backgroundColor: '#3B1E6D',
                                padding: '0 8px',
                                zIndex: 1,
                              },
                              input: {
                                backgroundColor: 'transparent',
                                color: '#ffffff',
                                border: '1px solid #ffffff',
                                height: '60.84px',
                                paddingLeft: '60px',
                                paddingRight: '40px',
                                width: '100%',
                                fontFamily: 'Product Sans',
                              },
                              root: {
                                position: 'relative',
                                maxWidth: '100%',
                                marginBottom: '16px',
                              },
                            }}
                            radius="6px"
                            leftSection={
                              <IconCalendar
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            error={
                              formik.touched.dateOfBirth &&
                              formik.errors.dateOfBirth
                            }
                          />
                        </Grid.Col>

                        <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                          <TextInput
                            className="custom-input"
                            label="Email"
                            placeholder="Enter your email address"
                            name="email"
                            value={formik.values.email}
                            leftSection={
                              <IconMail
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={e => formik.setFieldValue('email', e)}
                            onBlur={formik.handleBlur}
                            radius="6px"
                            styles={inputStyle}
                            error={formik.touched.email && formik.errors.email}
                          />
                        </Grid.Col>
                      </Grid>
                    </Stepper.Step>

                    {/* Step 3: Additional Information */}
                    <Stepper.Step
                      icon={<IconAddressBook size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(2)}
                    >
                      <TextInput
                        className="mt-8 custom-input"
                        label="Phone Number"
                        placeholder="Enter phone number"
                        name="phoneNumber"
                        value={formik.values.phoneNumber}
                        hideControls
                        leftSection={
                          <IconPhone
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        onChange={value =>
                          formik.setFieldValue('phoneNumber', value)
                        }
                        onBlur={formik.handleBlur}
                        radius="6px"
                        styles={{
                          label: {
                            fontWeight: '400',
                            fontSize: '16px',
                            color: '#ffffff',
                            marginBottom: '0',
                            fontFamily: 'Product Sans',
                            position: 'absolute',
                            top: '-14px',
                            left: '18px',
                            backgroundColor: '#3B1E6D',
                            padding: '0 8px',
                            zIndex: 1,
                          },
                          input: {
                            backgroundColor: 'transparent',
                            color: '#ffffff',
                            border: '1px solid #ffffff',
                            height: '60.84px',
                            paddingLeft: '60px',
                            paddingRight: '40px',
                            width: '100%',
                            fontFamily: 'Product Sans',
                          },
                          root: {
                            position: 'relative',
                            maxWidth: '100%',
                            marginBottom: '16px',
                          },
                        }}
                        error={
                          formik.touched.phoneNumber &&
                          formik.errors.phoneNumber
                        }
                      />

                      <Select
                        className="mt-8 custom-input"
                        label="Gender"
                        placeholder="Select Gender"
                        name="gender"
                        value={formik.values.gender}
                        data={['Male', 'Female', 'Other']}
                        leftSection={
                          <IconUser
                            style={{
                              width: '25px',
                              height: '25px',
                              color: '#FFFFFF',
                              position: 'absolute',
                              left: '25px',
                              top: '50%',
                              transform: 'translateY(-50%)',
                            }}
                          />
                        }
                        rightSection={
                          <IconChevronDown
                            size={20}
                            color="#ffffff"
                            className="mr-3"
                          />
                        }
                        onChange={value =>
                          formik.setFieldValue('gender', value)
                        }
                        onBlur={formik.handleBlur}
                        radius="6px"
                        styles={{
                          label: {
                            fontWeight: '400',
                            fontSize: '16px',
                            color: '#ffffff',
                            marginBottom: '0',
                            fontFamily: 'Product Sans',
                            position: 'absolute',
                            top: '-14px',
                            left: '18px',
                            backgroundColor: '#3B1E6D',
                            padding: '0 8px',
                            zIndex: 1,
                          },
                          input: {
                            backgroundColor: 'transparent',
                            color: '#ffffff',
                            border: '1px solid #ffffff',
                            height: '60.84px',
                            paddingLeft: '60px',
                            paddingRight: '40px',
                            width: '100%',
                            fontFamily: 'Product Sans',
                          },
                          root: {
                            position: 'relative',
                            maxWidth: '100%',
                            marginBottom: '16px',
                          },
                        }}
                        error={formik.touched.gender && formik.errors.gender}
                      />
                    </Stepper.Step>

                    {/* Completion Step */}
                    <Stepper.Completed>
                      <div className="text-[#ffffff]">
                        Completed, click back button to get to previous step
                      </div>
                    </Stepper.Completed>
                  </Stepper>
                </div>

                {/* Navigation Buttons */}
                <div className="-mt-[17px] mb-[4px] flex flex-col items-center">
                  <div className="flex space-x-4">
                    {active > 0 && (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#6B7280] py-2 px-5 text-center text-sm text-[#ffffff] shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active - 1)}
                        style={{ color: '#ffffff' }}
                      >
                        Previous
                      </button>
                    )}

                    {active < 3 ? (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#D83F87] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active + 1)}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                      >
                        {isLoading ? 'Loading' : 'Next'}
                      </button>
                    ) : (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#10B981] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => formik.handleSubmit()}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                      >
                        {isLoading ? 'Submitting...' : 'Submit'}
                      </button>
                    )}
                  </div>
                </div>
              </form>
              <div
                className="ml-3 mt-2 cursor-pointer underline font-productsans text-[#fff] text-[12px] sm:text-[14px] font-normal"
                onClick={() => navigate('/')}
              >
                Login
              </div>
            </div>
          </div>
        </div>
      </>
    )
  ) : null;
}
