// Importing necessary Mantine components and hooks
import {
  FileInput,
  Grid,
  Group,
  NumberInput,
  Radio,
  Stepper,
  Textarea,
} from '@mantine/core';
import {
  IconAddressBook,
  IconBarcode,
  IconBuilding,
  IconFile,
  IconFileDescription,
  IconLocation,
  IconMail,
  IconMapPin,
  IconPhone,
  IconTax,
  IconUserCheck,
  IconWorld,
} from '@tabler/icons-react';
import { useFormik } from 'formik';
import { useEffect, useState } from 'react';
import { LuUserRound } from 'react-icons/lu';
import { postData, uploadFile } from '../../api/api';
import { default as leftBackgroundImageSrc } from '../../assets/images/leftImage.png';
import backgroundImageSrc from '../../assets/images/login bg img.jpg';
import logo from '../../assets/images/muv-logo.svg';

import { useNavigate } from 'react-router-dom';
import { TextInput } from '../../components';
import useScreenSize from '../../hooks/useScreenSize';
import { inputStyle } from '../../theme/common.style';
import {
  leftSectionIcon,
  numberInputStyle,
  textPublicAreaStyle,
} from '../../theme/public.style';
import {
  cleanObject,
  handleError,
  handleSuccess,
} from '../../utils/common/function';
import { initialValues, validationSchema } from './constant';
import { IoMdLink } from 'react-icons/io';
import { MdOutlineFileUpload } from 'react-icons/md';
const initialNotification = {
  isSuccess: true,
  isEnable: false, // Indicates whether the notification is enabled
  title: '', // Title of the notification
  message: '', // Message of the notification
};

// Preload the background image
const backgroundImage = new Image();
// eslint-disable-next-line @typescript-eslint/no-require-imports
backgroundImage.src = backgroundImageSrc;

const leftBackgroundImage = new Image();

// eslint-disable-next-line @typescript-eslint/no-require-imports
leftBackgroundImage.src = leftBackgroundImageSrc;

export function BusinessSignupPage() {
  const navigate = useNavigate();
  const { isLargeScreen } = useScreenSize();
  const [isLoading, setIsLoading] = useState(false);
  const [imagesLoaded, setImagesLoaded] = useState({
    background: false,
    leftBackground: false,
  });

  useEffect(() => {
    // Preload the background image
    const backgroundImage = new Image();
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    backgroundImage.src = backgroundImageSrc;

    const leftBackgroundImage = new Image();
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    leftBackgroundImage.src = leftBackgroundImageSrc;
    backgroundImage.onload = () => {
      setImagesLoaded(prev => ({ ...prev, background: true }));
    };
    leftBackgroundImage.onload = () => {
      setImagesLoaded(prev => ({ ...prev, leftBackground: true }));
    };
  }, []);

  const formik = useFormik({
    initialValues: initialValues,
    validationSchema: validationSchema,
    onSubmit: values => {
      if (active !== 6) return;
      setIsLoading(true);
      postData(
        'users',
        cleanObject({
          ...values,
          taxId: values?.taxId?.toString(),
          phoneNumber: values?.phoneNumber?.toString(),
        })
      )
        .then(() => {
          handleSuccess(
            'Account created successfully. Please wait we are verifying your account.'
          );
          navigate('/');
        })
        .catch(error => {
          handleError(error, 'Failed to fetch table data');
        })
        .finally(() => {
          setIsLoading(false);
        });
    },
  });

  // Add this function to validate each step
  const validateCurrentStep = (step: number) => {
    switch (step) {
      case 0:
        if (
          !formik.values.fullNameOrBusinessName ||
          formik.errors.fullNameOrBusinessName
        ) {
          formik.setFieldTouched('fullNameOrBusinessName', true);
          return false;
        }
        return true;
      case 1:
        return true;
      case 2:
        // if (
        //   !formik.values.address ||
        //   formik.errors.address ||
        //   !formik.values.city ||
        //   formik.errors.city ||
        //   !formik.values.zipCode ||
        //   formik.errors.zipCode ||
        //   !formik.values.country ||
        //   formik.errors.country
        // ) {
        //   formik.setFieldTouched('address', true);
        //   formik.setFieldTouched('city', true);
        //   formik.setFieldTouched('zipCode', true);
        //   formik.setFieldTouched('country', true);
        //   return false;
        // }
        return true;
      case 3:
        if (
          !formik.values.email ||
          formik.errors.email
          // ||
          // !formik.values.phoneNumber ||
          // formik.errors.phoneNumber
        ) {
          formik.setFieldTouched('email', true);
          // formik.setFieldTouched('phoneNumber', true);
          return false;
        }
        return true;
      case 4:
        // if (!formik.values.taxId || formik.errors.taxId) {
        //   formik.setFieldTouched('taxId', true);
        //   return false;
        // }
        // if (
        //   !formik.values.businessDocumentType ||
        //   formik.errors.businessDocumentType
        // ) {
        //   formik.setFieldTouched('businessDocumentType', true);
        //   return false;
        // }
        // if (
        //   formik.values.businessDocumentType === 'ein' &&
        //   (!formik.values.taxIdDocumentUrl || formik.errors.taxIdDocumentUrl)
        // ) {
        //   formik.setFieldTouched('taxIdDocumentUrl', true);
        //   return false;
        // }
        // if (
        //   formik.values.businessDocumentType === 'cr' &&
        //   (!formik.values.crNumber || formik.errors.crNumber)
        // ) {
        //   formik.setFieldTouched('crNumber', true);
        //   return false;
        // }
        return true;
      default:
        return true;
    }
  };

  // Modify the handleStepChange function to include validation
  const handleStepChange = (nextStep: number) => {
    const isOutOfBounds = nextStep > 6 || nextStep < 0;

    if (isOutOfBounds) {
      return;
    }

    // Validate current step before proceeding
    if (nextStep > active) {
      const isValid = validateCurrentStep(active);
      if (!isValid) {
        return;
      }
    }

    setActive(nextStep);
    setHighestStepVisited(hSC => Math.max(hSC, nextStep));
  };

  const handleFileChange = async (file: File | null) => {
    setIsLoading(true);
    if (!file || !file.type.startsWith('image/')) {
      console.warn('Only image files are allowed.');
      return;
    }

    try {
      const response = await uploadFile<{ url: string }>('file/upload', file);
      if (response?.url) {
        formik.setFieldValue('taxIdDocumentUrl', response?.url);
      }
      setIsLoading(false);
    } catch (error) {
      setIsLoading(false);
      console.error('Upload failed:', error);
    }
  };

  const [active, setActive] = useState(0);
  const [highestStepVisited, setHighestStepVisited] = useState(active);

  const shouldAllowSelectStep = (step: number) =>
    highestStepVisited >= step && active !== step;

  return imagesLoaded?.background && imagesLoaded.leftBackground ? (
    isLargeScreen ? (
      <>
        <div className="flex justify-between items-stretch h-[100vh]">
          <div className="flex items-center justify-center flex-1 h-full">
            <video
              src={'/loginpage.mp4'}
              className="object-cover w-full h-full"
              autoPlay
              loop
              muted
              playsInline
            ></video>
          </div>
          <div
            className="relative flex-1 bg-cover bg-no-repeat bg-center bg-[#3B1E6D] h-screen items-center justify-center flex bg-gradient-to-br
from-[#563097]
via-[#3B1E6D]
to-[#563097]"
          >
            <div className="flex flex-col items-center w-full max-w-[500px] px-5">
              <img
                src={logo}
                alt=""
                className="max-h-full h-[92px] w-[226px] mb-[10px] mt-[30px]"
              />
              <div className="text-[#ffffff] text-[36px] font-bold font-productsans leading-[49.7px] mt-3">
                SIGNUP
              </div>

              <form
                className="w-full flex flex-col gap-4 mt-[45px]"
                onSubmit={() => formik.handleSubmit()}
              >
                <div className="pb-6">
                  <Stepper
                    active={active}
                    onStepClick={setActive}
                    styles={{
                      stepIcon: {
                        borderColor: '#D83F87',
                        backgroundColor: '#D83F87',
                      },
                      separator: {
                        backgroundColor: '#D83F87',
                      },
                    }}
                  >
                    <Stepper.Step
                      // label="Business Information"
                      icon={<IconUserCheck size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(0)}
                    >
                      <TextInput
                        className="mt-6 custom-input"
                        label="Business Name"
                        placeholder="Enter your business name"
                        value={formik.values.fullNameOrBusinessName}
                        onChange={(value: any) =>
                          formik.setFieldValue('fullNameOrBusinessName', value)
                        }
                        error={
                          formik.touched.fullNameOrBusinessName &&
                          formik.errors.fullNameOrBusinessName
                        }
                        leftSection={<LuUserRound style={leftSectionIcon} />}
                        radius="6px"
                        styles={inputStyle}
                      />
                      <Textarea
                        className="mt-8 custom-input"
                        label="Business Description"
                        placeholder="Enter Description"
                        value={formik.values.bio}
                        onChange={(value: any) =>
                          formik.setFieldValue('bio', value.target.value)
                        }
                        error={formik.touched.bio && formik.errors.bio}
                        leftSection={
                          <IconFileDescription style={leftSectionIcon} />
                        }
                        radius="6px"
                        styles={textPublicAreaStyle}
                      />
                    </Stepper.Step>
                    <Stepper.Step
                      icon={<IoMdLink size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(1)}
                    >
                      <TextInput
                        className="custom-input mt-6"
                        label="GMB Profile"
                        placeholder="Enter your GMB Profile"
                        value={formik.values.gmbProfile}
                        onChange={(value: any) =>
                          formik.setFieldValue('gmbProfile', value)
                        }
                        error={
                          formik.touched.gmbProfile && formik.errors.gmbProfile
                        }
                        leftSection={<LuUserRound style={leftSectionIcon} />}
                        radius="6px"
                        styles={inputStyle}
                      />
                      <TextInput
                        className="custom-input mt-10"
                        label="Business Website"
                        placeholder="Enter your Business Website"
                        value={formik.values.businessWebsite}
                        onChange={(value: any) =>
                          formik.setFieldValue('businessWebsite', value)
                        }
                        error={
                          formik.touched.businessWebsite &&
                          formik.errors.businessWebsite
                        }
                        leftSection={
                          <MdOutlineFileUpload style={leftSectionIcon} />
                        }
                        radius="6px"
                        styles={inputStyle}
                      />
                    </Stepper.Step>
                    <Stepper.Step
                      //label="Business Location"
                      icon={<IconLocation size={23} color="#ffffff" />}
                      allowStepSelect={shouldAllowSelectStep(2)}
                    >
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-4 custom-input"
                            label="Address"
                            placeholder="Enter your address"
                            value={formik.values.address}
                            leftSection={
                              <IconMapPin
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: any) =>
                              formik.setFieldValue('address', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.address && formik.errors.address
                            }
                          />
                        </Grid.Col>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="mt-4 custom-input"
                            label="City"
                            placeholder="Enter your city"
                            value={formik.values.city}
                            leftSection={
                              <IconBuilding
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: any) =>
                              formik.setFieldValue('city', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={formik.touched.city && formik.errors.city}
                          />
                        </Grid.Col>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="custom-input"
                            label="Zip Code"
                            placeholder="Enter your zip code"
                            value={formik.values.zipCode}
                            leftSection={
                              <IconBarcode
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: any) =>
                              formik.setFieldValue('zipCode', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.zipCode && formik.errors.zipCode
                            }
                          />
                        </Grid.Col>
                        <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                          <TextInput
                            className="custom-input"
                            label="Country"
                            placeholder="Enter your country"
                            value={formik.values.country}
                            leftSection={
                              <IconWorld
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: any) =>
                              formik.setFieldValue('country', value)
                            }
                            radius="6px"
                            styles={inputStyle}
                            error={
                              formik.touched.country && formik.errors.country
                            }
                          />
                        </Grid.Col>
                      </Grid>
                    </Stepper.Step>
                    <Stepper.Step
                      icon={<IconAddressBook size={23} color="#ffffff" />}
                      // label="Business Information"
                      allowStepSelect={shouldAllowSelectStep(3)}
                    >
                      <TextInput
                        className="mt-4 custom-input"
                        label="Email"
                        placeholder="Enter your email address"
                        value={formik.values.email}
                        leftSection={<IconMail style={leftSectionIcon} />}
                        onChange={(value: any) =>
                          formik.setFieldValue('email', value)
                        }
                        radius="6px"
                        styles={inputStyle}
                        error={formik.touched.email && formik.errors.email}
                      />
                      <Grid>
                        <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                          <TextInput
                            className="mt-4 custom-input"
                            label="Phone Number"
                            placeholder="Enter phone number"
                            value={formik.values.phoneNumber}
                            hideControls
                            leftSection={
                              <IconPhone
                                style={{
                                  width: '25px',
                                  height: '25px',
                                  color: '#FFFFFF',
                                  position: 'absolute',
                                  left: '25px',
                                  top: '50%',
                                  transform: 'translateY(-50%)',
                                }}
                              />
                            }
                            onChange={(value: any) =>
                              formik.setFieldValue('phoneNumber', value)
                            }
                            radius="6px"
                            styles={{
                              label: {
                                fontWeight: '400',
                                fontSize: '16px',
                                color: '#ffffff',
                                marginBottom: '0',
                                fontFamily: 'Product Sans', // Updated font family
                                position: 'absolute',
                                top: '-14px',
                                left: '18px',
                                backgroundColor: '#3B1E6D',
                                padding: '0 8px',
                                zIndex: 1,
                              },
                              input: {
                                backgroundColor: 'transparent',
                                color: '#ffffff',
                                border: '1px solid #ffffff',
                                height: '60.84px',
                                paddingLeft: '60px',
                                paddingRight: '40px',
                                width: '100%',
                                fontFamily: 'Product Sans', // Updated font family
                              },
                              root: {
                                position: 'relative',
                                maxWidth: '100%',
                                marginBottom: '16px',
                              },
                            }}
                            error={
                              formik.touched.phoneNumber &&
                              formik.errors.phoneNumber
                            }
                          />
                        </Grid.Col>
                      </Grid>
                    </Stepper.Step>
                    <Stepper.Step
                      icon={<IconFile size={23} color="#ffffff" />}
                      // label="Business Information"
                      allowStepSelect={shouldAllowSelectStep(4)}
                    >
                      <NumberInput
                        className="mt-3 custom-input"
                        label="Tax ID"
                        placeholder="Enter Tax Id"
                        value={formik.values.taxId}
                        hideControls
                        leftSection={<IconTax style={leftSectionIcon} />}
                        onChange={(value: any) =>
                          formik.setFieldValue('taxId', value)
                        }
                        radius="6px"
                        styles={numberInputStyle}
                        error={formik.touched.taxId && formik.errors.taxId}
                      />

                      <Radio.Group
                        name="favoriteFramework"
                        label="Select your Business Registration Document Type"
                        value={formik.values.businessDocumentType}
                        onChange={value => {
                          formik.setFieldValue('businessDocumentType', value);
                        }}
                        error={
                          formik.touched.businessDocumentType &&
                          formik.errors.businessDocumentType
                        }
                        className="mt-1"
                        styles={{
                          label: {
                            color: '#ffffff',
                            fontSize: '16px',
                            fontFamily: 'Product Sans',
                          },
                        }}
                      >
                        <Group mt="sm" mb="35px">
                          <Radio
                            value="ein"
                            label="EIN"
                            iconColor="#ffffff"
                            color="#D83F87"
                            styles={{
                              label: {
                                color: '#ffffff',
                                fontSize: '14px',
                                fontFamily: 'Product Sans',
                              },
                            }}
                          />
                          <Radio
                            value="cr"
                            label="CR"
                            iconColor="#ffffff"
                            color="#D83F87"
                            styles={{
                              label: {
                                color: '#ffffff',
                                fontSize: '14px',
                                fontFamily: 'Product Sans',
                              },
                            }}
                          />
                        </Group>
                      </Radio.Group>
                      {formik.values.businessDocumentType === 'ein' && (
                        <FileInput
                          label="Document"
                          id="fileInput"
                          placeholder={
                            formik.values.taxIdDocumentUrl
                              ? 'Document uploaded: ' +
                                formik.values.taxIdDocumentUrl
                              : 'Upload The File Containing the Business Documents'
                          }
                          styles={numberInputStyle}
                          radius={'6px'}
                          leftSection={<IconFile style={leftSectionIcon} />}
                          className="mt-1 custom-input"
                          onChange={handleFileChange}
                          accept=".pdf,.doc,.docx,.png,.jpg,.jpeg"
                          clearable
                        />
                      )}
                      {formik.values.businessDocumentType === 'cr' && (
                        <TextInput
                          className="mt-3 custom-input"
                          label="CR Number"
                          placeholder="Enter CR Number"
                          value={formik.values.crNumber}
                          hideControls
                          leftSection={<IconTax style={leftSectionIcon} />}
                          onChange={(value: any) =>
                            formik.setFieldValue('crNumber', value)
                          }
                          radius="6px"
                          styles={numberInputStyle}
                          error={
                            formik.touched.crNumber && formik.errors.crNumber
                          }
                        />
                      )}
                      <p className="text-[#ffffff] text-[12px] ">
                        Disclaimer: The information provided (EIN/CR documents)
                        is collected solely for business verification and to
                        prevent illicit activities on the platform.
                      </p>
                    </Stepper.Step>
                    <Stepper.Completed>
                      <div className="text-[#ffffff]">
                        Completed, click back button to get to previous step
                      </div>
                    </Stepper.Completed>
                  </Stepper>
                </div>

                <div className="-mt-[20px] mb-[4px] flex flex-col items-center ">
                  <div className="flex space-x-4">
                    {active > 0 ? (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#6B7280] py-2 px-5 text-center text-sm text-[#ffffff] shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active - 1)}
                        style={{ color: '#ffffff' }}
                      >
                        Previous
                      </button>
                    ) : (
                      <div></div>
                    )}

                    {active < 6 ? (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#D83F87] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        type="button"
                        onClick={() => handleStepChange(active + 1)}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                      >
                        {isLoading ? 'Loading' : 'Next'}
                      </button>
                    ) : (
                      <button
                        className="w-[120px] h-[50px] cursor-pointer select-none bg-[#10B981] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                        onClick={() => formik.handleSubmit()}
                        disabled={isLoading}
                        style={{ color: '#ffffff' }}
                        type="button"
                      >
                        {isLoading ? 'Submitting...' : 'Submit'}
                      </button>
                    )}
                  </div>
                  <div
                    className="ml-3 mt-2 cursor-pointer underline font-productsans text-[#fff] text-[12px] sm:text-[14px] font-normal"
                    onClick={() => navigate('/')}
                  >
                    Login
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </>
    ) : (
      <div className="flex flex-col items-stretch justify-between h-auto lg:flex-row">
        {/* Right Form Section */}
        <div
          className="flex-1 bg-cover bg-no-repeat bg-center h-auto lg:h-screen min-h-screen flex items-center justify-center bg-[#3B1E6D] bg-gradient-to-br
from-[#563097]
via-[#3B1E6D]
to-[#563097] "
        >
          <div className="flex flex-col items-center w-full max-w-[500px] px-5">
            {/* Logo */}
            <img
              src={logo}
              alt="Logo"
              className="max-h-[80px] w-auto mb-5 mt-[20px] "
            />
            {/* Title */}
            <h1 className="text-[#ffffff] text-[28px] sm:text-[36px] font-bold font-productsans text-center">
              SIGNUP
            </h1>

            {/* Form */}
            <form
              className="w-full flex flex-col gap-4 mt-[45px]"
              onSubmit={formik.handleSubmit}
            >
              <div className="pb-6">
                <Stepper
                  active={active}
                  onStepClick={setActive}
                  styles={{
                    stepIcon: {
                      borderColor: '#D83F87',
                      backgroundColor: '#D83F87',
                    },
                    separator: {
                      backgroundColor: '#D83F87',
                    },
                  }}
                >
                  <Stepper.Step
                    icon={<IconUserCheck size={23} color="#ffffff" />}
                    allowStepSelect={shouldAllowSelectStep(0)}
                  >
                    <TextInput
                      className="mt-6 custom-input"
                      label="Business Name"
                      placeholder="Enter your business name"
                      value={formik.values.fullNameOrBusinessName}
                      onChange={(value: any) =>
                        formik.setFieldValue('fullNameOrBusinessName', value)
                      }
                      error={
                        formik.touched.fullNameOrBusinessName &&
                        formik.errors.fullNameOrBusinessName
                      }
                      leftSection={<LuUserRound style={leftSectionIcon} />}
                      radius="6px"
                      styles={inputStyle}
                    />
                    <Textarea
                      className="mt-8 custom-input"
                      label="Business Description"
                      placeholder="Enter Description"
                      value={formik.values.bio}
                      onChange={(value: any) =>
                        formik.setFieldValue('bio', value.target.value)
                      }
                      error={formik.touched.bio && formik.errors.bio}
                      leftSection={
                        <IconFileDescription style={leftSectionIcon} />
                      }
                      radius="6px"
                      styles={textPublicAreaStyle}
                    />
                  </Stepper.Step>
                  <Stepper.Step
                    icon={<IoMdLink size={23} color="#ffffff" />}
                    allowStepSelect={shouldAllowSelectStep(1)}
                  >
                    <TextInput
                      className="custom-input mt-6"
                      label="GMB Profile"
                      placeholder="Enter your GMB Profile"
                      value={formik.values.gmbProfile}
                      onChange={(value: any) =>
                        formik.setFieldValue('gmbProfile', value)
                      }
                      error={
                        formik.touched.gmbProfile && formik.errors.gmbProfile
                      }
                      leftSection={<LuUserRound style={leftSectionIcon} />}
                      radius="6px"
                      styles={inputStyle}
                    />
                    <TextInput
                      className="custom-input mt-10"
                      label="Business Website"
                      placeholder="Enter your Business Website"
                      value={formik.values.businessWebsite}
                      onChange={(value: any) =>
                        formik.setFieldValue('businessWebsite', value)
                      }
                      error={
                        formik.touched.businessWebsite &&
                        formik.errors.businessWebsite
                      }
                      leftSection={
                        <MdOutlineFileUpload style={leftSectionIcon} />
                      }
                      radius="6px"
                      styles={inputStyle}
                    />
                  </Stepper.Step>
                  <Stepper.Step
                    icon={<IconLocation size={23} color="#ffffff" />}
                    allowStepSelect={shouldAllowSelectStep(2)}
                  >
                    <Grid>
                      <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                        <TextInput
                          className="mt-4 custom-input"
                          label="Address"
                          placeholder="Enter your address"
                          value={formik.values.address}
                          leftSection={
                            <IconMapPin
                              style={{
                                width: '25px',
                                height: '25px',
                                color: '#FFFFFF',
                                position: 'absolute',
                                left: '25px',
                                top: '50%',
                                transform: 'translateY(-50%)',
                              }}
                            />
                          }
                          onChange={(value: any) =>
                            formik.setFieldValue('address', value)
                          }
                          radius="6px"
                          styles={inputStyle}
                          error={
                            formik.touched.address && formik.errors.address
                          }
                        />
                      </Grid.Col>
                      <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                        <TextInput
                          className="mt-4 custom-input"
                          label="City"
                          placeholder="Enter your city"
                          value={formik.values.city}
                          leftSection={
                            <IconBuilding
                              style={{
                                width: '25px',
                                height: '25px',
                                color: '#FFFFFF',
                                position: 'absolute',
                                left: '25px',
                                top: '50%',
                                transform: 'translateY(-50%)',
                              }}
                            />
                          }
                          onChange={(value: any) =>
                            formik.setFieldValue('city', value)
                          }
                          radius="6px"
                          styles={inputStyle}
                          error={formik.touched.city && formik.errors.city}
                        />
                      </Grid.Col>
                      <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                        <TextInput
                          className="custom-input"
                          label="Zip Code"
                          placeholder="Enter your zip code"
                          value={formik.values.zipCode}
                          leftSection={
                            <IconBarcode
                              style={{
                                width: '25px',
                                height: '25px',
                                color: '#FFFFFF',
                                position: 'absolute',
                                left: '25px',
                                top: '50%',
                                transform: 'translateY(-50%)',
                              }}
                            />
                          }
                          onChange={(value: any) =>
                            formik.setFieldValue('zipCode', value)
                          }
                          radius="6px"
                          styles={inputStyle}
                          error={
                            formik.touched.zipCode && formik.errors.zipCode
                          }
                        />
                      </Grid.Col>
                      <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
                        <TextInput
                          className="custom-input"
                          label="Country"
                          placeholder="Enter your country"
                          value={formik.values.country}
                          leftSection={
                            <IconWorld
                              style={{
                                width: '25px',
                                height: '25px',
                                color: '#FFFFFF',
                                position: 'absolute',
                                left: '25px',
                                top: '50%',
                                transform: 'translateY(-50%)',
                              }}
                            />
                          }
                          onChange={(value: any) =>
                            formik.setFieldValue('country', value)
                          }
                          radius="6px"
                          styles={inputStyle}
                          error={
                            formik.touched.country && formik.errors.country
                          }
                        />
                      </Grid.Col>
                    </Grid>
                  </Stepper.Step>
                  <Stepper.Step
                    icon={<IconAddressBook size={23} color="#ffffff" />}
                    // label="Business Information"
                    allowStepSelect={shouldAllowSelectStep(3)}
                  >
                    <TextInput
                      className="mt-4 custom-input"
                      label="Email"
                      placeholder="Enter your email address"
                      value={formik.values.email}
                      leftSection={<IconMail style={leftSectionIcon} />}
                      onChange={(value: any) =>
                        formik.setFieldValue('email', value)
                      }
                      radius="6px"
                      styles={inputStyle}
                      error={formik.touched.email && formik.errors.email}
                    />
                    <Grid>
                      <Grid.Col span={{ base: 12, md: 12, lg: 12 }}>
                        <TextInput
                          className="mt-4 custom-input"
                          label="Phone Number"
                          placeholder="Enter phone number"
                          value={formik.values.phoneNumber}
                          hideControls
                          leftSection={
                            <IconPhone
                              style={{
                                width: '25px',
                                height: '25px',
                                color: '#FFFFFF',
                                position: 'absolute',
                                left: '25px',
                                top: '50%',
                                transform: 'translateY(-50%)',
                              }}
                            />
                          }
                          onChange={(value: any) =>
                            formik.setFieldValue('phoneNumber', value)
                          }
                          radius="6px"
                          styles={{
                            label: {
                              fontWeight: '400',
                              fontSize: '16px',
                              color: '#ffffff',
                              marginBottom: '0',
                              fontFamily: 'Product Sans', // Updated font family
                              position: 'absolute',
                              top: '-14px',
                              left: '18px',
                              backgroundColor: '#3B1E6D',
                              padding: '0 8px',
                              zIndex: 1,
                            },
                            input: {
                              backgroundColor: 'transparent',
                              color: '#ffffff',
                              border: '1px solid #ffffff',
                              height: '60.84px',
                              paddingLeft: '60px',
                              paddingRight: '40px',
                              width: '100%',
                              fontFamily: 'Product Sans', // Updated font family
                            },
                            root: {
                              position: 'relative',
                              maxWidth: '100%',
                              marginBottom: '16px',
                            },
                          }}
                          error={
                            formik.touched.phoneNumber &&
                            formik.errors.phoneNumber
                          }
                        />
                      </Grid.Col>
                    </Grid>
                  </Stepper.Step>
                  <Stepper.Step
                    icon={<IconFile size={23} color="#ffffff" />}
                    // label="Business Information"
                    allowStepSelect={shouldAllowSelectStep(4)}
                  >
                    <NumberInput
                      className="mt-3 custom-input"
                      label="Tax ID"
                      placeholder="Enter Tax Id"
                      value={formik.values.taxId}
                      hideControls
                      leftSection={<IconTax style={leftSectionIcon} />}
                      onChange={(value: any) =>
                        formik.setFieldValue('taxId', value)
                      }
                      radius="6px"
                      styles={numberInputStyle}
                      error={formik.touched.taxId && formik.errors.taxId}
                    />

                    <Radio.Group
                      name="businessDocumentType"
                      label="Select your Business Registration Document Type"
                      className="mt-1"
                      value={formik.values.businessDocumentType}
                      onChange={value => {
                        console.log('Value', value);
                        formik.setFieldValue('businessDocumentType', value);
                      }}
                      error={
                        formik.touched.businessDocumentType &&
                        formik.errors.businessDocumentType
                      }
                      styles={{
                        label: {
                          color: '#ffffff',
                          fontSize: '16px',
                          fontFamily: 'Product Sans',
                        },
                      }}
                    >
                      <Group mt="sm" mb="35px">
                        <Radio
                          value="ein"
                          label="EIN"
                          iconColor="#ffffff"
                          color="#D83F87"
                          styles={{
                            label: {
                              color: '#ffffff',
                              fontSize: '14px',
                              fontFamily: 'Product Sans',
                            },
                          }}
                        />
                        <Radio
                          value="cr"
                          label="CR"
                          iconColor="#ffffff"
                          color="#D83F87"
                          styles={{
                            label: {
                              color: '#ffffff',
                              fontSize: '14px',
                              fontFamily: 'Product Sans',
                            },
                          }}
                        />
                      </Group>
                    </Radio.Group>
                    {formik.values.businessDocumentType === 'ein' && (
                      <FileInput
                        label="Document"
                        id="fileInput"
                        placeholder={
                          formik.values.taxIdDocumentUrl
                            ? 'Document uploaded: ' +
                              formik.values.taxIdDocumentUrl
                            : 'Upload The File Containing the Business Documents'
                        }
                        styles={numberInputStyle}
                        radius={'6px'}
                        leftSection={<IconFile style={leftSectionIcon} />}
                        className="mt-1 custom-input"
                        onChange={handleFileChange}
                        accept=".pdf,.doc,.docx,.png,.jpg,.jpeg"
                        clearable
                      />
                    )}
                    {formik.values.businessDocumentType === 'cr' && (
                      <TextInput
                        className="mt-3 custom-input"
                        label="CR Number"
                        placeholder="Enter CR Number"
                        value={formik.values.crNumber}
                        hideControls
                        leftSection={<IconTax style={leftSectionIcon} />}
                        onChange={(value: any) =>
                          formik.setFieldValue('crNumber', value)
                        }
                        radius="6px"
                        styles={numberInputStyle}
                        error={
                          formik.touched.crNumber && formik.errors.crNumber
                        }
                      />
                    )}
                    <p className="text-[#ffffff] text-[12px] ">
                      Disclaimer: The information provided (EIN/CR documents) is
                      collected solely for business verification and to prevent
                      illicit activities on the platform.
                    </p>
                  </Stepper.Step>
                  <Stepper.Completed>
                    <div className="text-[#ffffff]">
                      Completed, click back button to get to previous step
                    </div>
                  </Stepper.Completed>
                </Stepper>
              </div>

              <div className="-mt-[17px] mb-[4px] flex flex-col items-center ">
                <div className="flex space-x-4">
                  {active > 0 && (
                    <button
                      className="w-[120px] h-[50px] cursor-pointer select-none bg-[#6B7280] py-2 px-5 text-center text-sm text-[#ffffff] shadow font-productsans rounded-md text-[18px] font-bold"
                      type="button"
                      onClick={() => handleStepChange(active - 1)}
                      style={{ color: '#ffffff' }}
                    >
                      Previous
                    </button>
                  )}

                  {active < 6 ? (
                    <button
                      className="w-[120px] h-[50px] cursor-pointer select-none bg-[#D83F87] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                      type="button"
                      onClick={() => handleStepChange(active + 1)}
                      disabled={isLoading}
                      style={{ color: '#ffffff' }}
                    >
                      {isLoading ? 'Loading' : 'Next'}
                    </button>
                  ) : (
                    <button
                      className="w-[120px] h-[50px] cursor-pointer select-none bg-[#10B981] py-2 px-5 text-center text-sm text-white shadow font-productsans rounded-md text-[18px] font-bold"
                      onClick={() => formik.handleSubmit()}
                      disabled={isLoading}
                      type="button"
                      style={{ color: '#ffffff' }}
                    >
                      {isLoading ? 'Submitting...' : 'Submit'}
                    </button>
                  )}
                </div>
                <div
                  className="ml-3 mt-2 cursor-pointer underline font-productsans text-[#fff] text-[12px] sm:text-[14px] font-normal"
                  onClick={() => navigate('/')}
                >
                  Login
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    )
  ) : null;
}
