import {
  IconAlertHexagon,
  IconCalendar,
  IconGift,
  IconLayoutGrid,
  IconFileText,
  IconClipboard,
  IconCalendarWeek,
  IconClipboardText,
  IconFileAnalytics,
  IconDeviceIpadHorizontalDollar,
  IconSettings,
  IconTicket,
  IconUser,
  IconUsers,
} from '@tabler/icons-react';
import { FaUserPlus } from 'react-icons/fa';
import { GiAngelOutfit } from 'react-icons/gi';

export function getNavBarAgainstRole(roleId: number | string) {
  const role = Number(roleId);
  return role === 1
    ? getSystemAdminNav()
    : role === 2
      ? getEntertainerNav()
      : getBusinessNav();
}

function getEntertainerNav() {
  return [
    {
      link: '/dashboard',
      label: 'Dashboard',
      icon: IconLayoutGrid,
      activeLinks: ['/dashboard'],
    },
    {
      link: '/sales',
      label: 'Sales',
      icon: IconFileText,
      activeLinks: ['/sales'],
    },
    {
      link: '/upcomingEvents',
      label: 'Upcoming Events',
      icon: IconClipboard,
      activeLinks: ['/upcomingEvents'],
    },
    {
      link: '/calender',
      label: 'Calendar',
      icon: IconCalendarWeek,
      activeLinks: ['/calender'],
    },
    {
      link: '/gigs',
      label: 'Gigs',
      icon: IconClipboardText,
      activeLinks: ['/gigs'],
    },
    {
      link: '/reporting',
      label: 'Reporting & Analytics',
      icon: IconFileAnalytics,
      activeLinks: ['/reporting'],
    },
    {
      link: '/payment',
      label: 'Payment & Wallet',
      icon: IconDeviceIpadHorizontalDollar,
      activeLinks: ['/payment'],
    },
    {
      link: '/profile',
      label: 'My Profile',
      icon: IconUser,
      activeLinks: ['/profile'],
    },
  ];
}

function getSystemAdminNav() {
  return [
    {
      link: '/dashboard',
      label: 'Dashboard',
      icon: IconLayoutGrid,
      activeLinks: ['/dashboard'],
    },
    {
      link: '/sales',
      label: 'Sales',
      icon: IconFileText,
      activeLinks: ['/sales'],
    },
    {
      link: '/upcomingEvents',
      label: 'Events',
      icon: IconCalendar,
      activeLinks: ['/upcomingEvents'],
    },
    {
      link: '/user',
      label: 'Users',
      icon: IconUsers,
      activeLinks: ['/user'],
    },
    {
      link: '/reporting',
      label: 'Reporting & Analytics',
      icon: IconFileAnalytics,
      activeLinks: ['/reporting'],
    },
    {
      link: '/voucher',
      label: 'Voucher',
      icon: IconGift,
      activeLinks: ['/voucher'],
    },
    {
      link: '/payment',
      label: 'Payment & Wallet',
      icon: IconDeviceIpadHorizontalDollar,
      activeLinks: ['/payment'],
    },
    {
      link: '/refundDispute',
      label: 'Refund Disputes',
      icon: IconAlertHexagon,
      activeLinks: ['/refundDispute'],
    },
    {
      link: '/systemSettings',
      label: 'System Settings',
      icon: IconSettings,
      activeLinks: ['/systemSettings'],
    },
    {
      link: '/systemUser',
      label: 'System User',
      icon: FaUserPlus,
      activeLinks: ['/systemUser'],
    },
  ];
}

function getBusinessNav() {
  return [
    {
      link: '/dashboard',
      label: 'Dashboard',
      icon: IconLayoutGrid,
      activeLinks: ['/dashboard'],
    },
    {
      link: '/sales',
      label: 'Sales',
      icon: IconFileText,
      activeLinks: ['/sales'],
    },
    {
      link: '/tickets',
      label: 'Tickets',
      icon: IconTicket,
      activeLinks: ['/tickets'],
    },
    {
      link: '/upcomingEvents',
      label: 'Events',
      icon: IconCalendar,
      activeLinks: ['/upcomingEvents'],
    },
    {
      link: '/entertainer',
      label: 'Entertainer',
      icon: 'entertainer',
      activeLinks: ['/entertainer'],
    },
    {
      link: '/angel-wing',
      label: 'Angel Wings',
      icon: GiAngelOutfit,
      activeLinks: ['/angel-wing'],
    },
    {
      link: '/reporting',
      label: 'Reporting & Analytics',
      icon: IconFileAnalytics,
      activeLinks: ['/reporting'],
    },
    {
      link: '/payment',
      label: 'Payment & Wallet',
      icon: IconDeviceIpadHorizontalDollar,
      activeLinks: ['/payment'],
    },
    {
      link: '/profile',
      label: 'My Profile',
      icon: IconUser,
      activeLinks: ['/profile'],
    },
  ];
}
