// Mantine library imports
import { useMantineTheme } from '@mantine/core';

// Tabler icons imports

// React icon imports

// React library imports
import { useDispatch, useSelector } from 'react-redux';
import { Link, useNavigate } from 'react-router-dom';

// Component imports

// Redux action imports

// Utility function imports
import { extractFirstWord } from '../utils/common/function';

import entertainer from '../assets/images/entertainer1.png';
import logo from '../assets/images/muv-logo.png';
import { getTranslation } from './languages';
import { getNavBarAgainstRole } from './role-based.navbar';
function Navbar({ onClick }: { onClick: () => void }) {
  // Initialize the Redux dispatch hook

  const navigate = useNavigate(); // Initialize the useNavigate hook

  // Get the current theme for styling purposes
  const theme = useMantineTheme();

  // Determine the current URL and extract the first word for comparison
  const url = window.location.href;
  const currentUrl = extractFirstWord(url);

  const userInfo = useSelector((state: any) => state?.userInfo?.userInfo);

  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const data = getNavBarAgainstRole(userInfo?.roleId);

  const links = data?.map(item => {
    const isActive = item.activeLinks?.includes(`/${currentUrl}`);
    const isAngelWings = item.label === 'Angel Wings';
    const isEntertainer = item.label === 'Entertainer';

    const iconColorClass = isActive
      ? 'text-[#ffffff]'
      : isAngelWings
        ? 'text-[#A46FFE] group-hover:text-[#ffffff]'
        : 'text-[#ffffff] group-hover:text-[#ffffff]';

    const labelColorClass = isActive
      ? 'text-color-white'
      : isAngelWings
        ? 'text-[#A46FFE] group-hover:text-[#ffffff]'
        : '';

    return (
      <Link
        className={`group flex items-center text-md py-3 mb-5 rounded border-n-ne hover:bg-[#D83F87] hover:text-color-white ${
          isActive ? 'bg-[#D83F87] text-color-white' : 'text-color-white'
        }`}
        to={item.link}
        key={item.label}
        onClick={() => {
          navigate(window.location.pathname, { replace: true });
          onClick();
        }}
      >
        {isEntertainer ? (
          <img
            src={entertainer} // adjust path if needed
            alt="Entertainer"
            className="w-8 h-8 mr-3 ml-6"
          />
        ) : (
          <item.icon
            className={`w-6 h-6 mr-3 ml-6 ${iconColorClass}`}
            stroke={'1.5'}
          />
        )}
        <span className={`font-gt text-[14px] ${labelColorClass}`}>
          {getTranslation(language, 'navbar', item.label)}
        </span>
      </Link>
    );
  });

  return (
    <div className="bg-[#3B1E6D] h-full">
      <div
        className={`flex flex-col h-full rounded-br-xl`}
        style={{
          color: theme.colors.lightColors[6],
          backgroundColor: '#452975',
        }}
      >
        <div className="lg:h-[11%] sm:h-[20%]">
          <div className="flex flex-row items-center justify-center">
            <div className="flex flex-col items-center justify-center my-8">
              <img
                src={logo}
                alt="Logo"
                style={{ height: '41px', width: '118px' }}
              />
            </div>
          </div>
        </div>
        {/* Main navigation links */}
        <div className="h-[82%] overflow-y-auto mt-9">
          <div className="flex flex-col">{links}</div>
        </div>
      </div>
    </div>
  );
}

export default Navbar;
