import { MantineProvider } from '@mantine/core';
import { Notifications } from '@mantine/notifications';
import ReactDOM from 'react-dom/client';
import { Provider } from 'react-redux';

import App from './App';
import './index.css';
import { ErrorBoundary } from './pages/error';
import store from './redux';
import reportWebVitals from './reportWebVitals';
import { register as registerServiceWorker } from './serviceWorkerRegistration';
import { theme } from './theme';

import '@mantine/core/styles.css';
import '@mantine/dates/styles.css';
import '@mantine/dropzone/styles.css';
import '@mantine/notifications/styles.css';

import { PayPalScriptProvider } from '@paypal/react-paypal-js';

// Validate required environment variables
const clientId = process.env.REACT_APP_PAYPAL_CLIENT;
if (!clientId) {
  throw new Error(
    'Missing PayPal Client ID. Please set REACT_APP_PAYPAL_CLIENT in your .env file.'
  );
}

// PayPal SDK options
const initialOptions = {
  clientId,
  currency: 'USD',
  intent: 'capture',
  components: 'buttons,card-fields,hosted-fields',
  'disable-funding': 'paylater',
};

const root = ReactDOM.createRoot(
  document.getElementById('root') as HTMLElement
);

registerServiceWorker();

root.render(
  <MantineProvider defaultColorScheme="light" theme={theme}>
    <Notifications />
    <ErrorBoundary>
      <PayPalScriptProvider options={initialOptions}>
        <Provider store={store}>
          <Notifications />
          <App />
        </Provider>
      </PayPalScriptProvider>
    </ErrorBoundary>
  </MantineProvider>
);

reportWebVitals();
