import { useState } from 'react';

type UseDisclosureReturn = [
  boolean,
  {
    open: () => void;
    close: () => void;
    toggle: () => void;
  },
];

function useDisclosure(initialState = false): UseDisclosureReturn {
  const [opened, setOpened] = useState<boolean>(initialState);

  const open = () => setOpened(true);
  const close = () => setOpened(false);
  const toggle = () => setOpened(prev => !prev);

  return [opened, { open, close, toggle }];
}

export default useDisclosure;
