// React imports
import { useEffect, useState } from 'react';

// React icon imports

// Mantine core theme hook
import { Grid, GridCol, useMantineTheme } from '@mantine/core';
import { Pagination, PaginationItem, Stack } from '@mui/material';

// Table-related imports

// Component imports

import { getCoreRowModel, useReactTable } from '@tanstack/react-table';
import { useSelector } from 'react-redux';
import { getTranslation } from '../../layout/languages';

const OnlyPagination = ({
  isPaginated = true,
  headerColor = '#0F783B',
  headerTextColor = '#ffffff',
  data,
  columns,
  isLoading,
  paginationInfo,
  handlePagination,
  isWithActionButton = true,
}: any) => {
  const {
    rowPerPage = '0', // Provide a default value
    totalRecords = 0,
    totalPages = 0,
    currentPage = 0,
  } = paginationInfo || {};
  const [goToPage, setGoToPage] = useState('');
  const theme = useMantineTheme();
  const table = useReactTable({
    defaultColumn: {
      size: 200, //starting column size
      minSize: 50, //enforced during column resizing
      maxSize: 500, //enforced during column resizing
    },
    data: data ?? [],
    columns,
    enableColumnResizing: true,
    columnResizeMode: 'onChange',
    getCoreRowModel: getCoreRowModel(),
    debugTable: true,
    debugHeaders: true,
    debugColumns: true,
  });

  //const { isSmallScreen, isMediumScreen, isLargeScreen } = useScreenSize(); // Using the hook to get screen size
  const language = useSelector(
    (state: any) => state.userInfo?.preferences?.language ?? 'en'
  );
  const [isSmallScreen, setIsSmallScreen] = useState(window.innerWidth <= 600);

  useEffect(() => {
    setIsSmallScreen(window.innerWidth <= 600);
  }, [window.innerWidth, window.innerHeight]);
  const [selectedPage, setSelectedPage] = useState<number | null>(null);

  return (
    <>
      <section
        className={`flex justify-between flex-col mt-4 relative max-w-full overflow-x-auto md:overflow-x-visible sm:overflow-x-visible`}
      >
        {isPaginated && !isSmallScreen && data?.length !== 0 && !isLoading && (
          <>
            <div className="w-full flex flex-col mb-6">
              <div className="w-full h-14 justify-center rounded-3xl">
                <div className="flex flex-row justify-between">
                  <div className="flex flex-row">
                    <div className="ml-1 font-productsans text-[14px] mt-4 font-normal text-color-white space-x-1 flex flex-row">
                      <p>{getTranslation(language, 'dashboard', 'Showing')}</p>
                      <p>
                        {Math.min(
                          Number(rowPerPage),
                          Number(totalRecords) -
                            (Number(currentPage) - 1) * Number(rowPerPage)
                        )}
                      </p>

                      <p> {getTranslation(language, 'dashboard', 'of')}</p>
                      <p> {totalRecords}</p>
                      <p> {getTranslation(language, 'dashboard', 'Entries')}</p>
                    </div>
                  </div>
                  <div className="flex flex-row ">
                    {isSmallScreen && !isLoading ? (
                      <Grid>
                        <GridCol span={12} className="flex justify-center">
                          <Stack spacing={2}>
                            <Pagination
                              count={totalPages}
                              page={currentPage}
                              shape="rounded"
                              siblingCount={1}
                              boundaryCount={1}
                              onChange={(_, page) =>
                                handlePagination('goto', page)
                              }
                              renderItem={item => {
                                const hideSeparator =
                                  selectedPage !== null &&
                                  (item.page === selectedPage - 1 ||
                                    item.page === selectedPage);

                                // Disable previous on first page
                                if (item.type === 'previous') {
                                  return (
                                    <span
                                      {...item}
                                      className="font-productsans"
                                      style={{
                                        padding: '4px 8px',
                                        color:
                                          Number(currentPage) === 1
                                            ? '#888'
                                            : '#fff',
                                        background: 'transparent',
                                        borderRadius: '8px',
                                        cursor:
                                          Number(currentPage) === 1
                                            ? 'not-allowed'
                                            : 'pointer',
                                        fontFamily: 'sans-serif',
                                        fontSize: '13px',
                                        fontWeight: 'normal',
                                        pointerEvents:
                                          currentPage === 1 ? 'none' : 'auto',
                                      }}
                                    >
                                      {getTranslation(
                                        language,
                                        'dashboard',
                                        'Previous'
                                      )}
                                    </span>
                                  );
                                }

                                // Disable next on last page
                                if (item.type === 'next') {
                                  return (
                                    <span
                                      {...item}
                                      className="font-productsans"
                                      style={{
                                        padding: '4px 8px',
                                        color:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? '#888'
                                            : '#fff',
                                        background: 'transparent',
                                        borderRadius: '8px',
                                        cursor:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? 'not-allowed'
                                            : 'pointer',
                                        fontFamily: 'sans-serif',
                                        fontSize: '13px',
                                        fontWeight: 'normal',
                                        pointerEvents:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? 'none'
                                            : 'auto',
                                      }}
                                    >
                                      {getTranslation(
                                        language,
                                        'dashboard',
                                        'Next'
                                      )}
                                    </span>
                                  );
                                }

                                return (
                                  <div
                                    style={{
                                      display: 'flex',
                                      alignItems: 'center',
                                      position: 'relative',
                                    }}
                                  >
                                    <PaginationItem
                                      {...item}
                                      sx={{
                                        color: '#fff',
                                        background: 'transparent',
                                        fontSize: '14px',
                                        width: '35px',
                                        height: '35px',
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',

                                        borderRadius: '0px',
                                        fontWeight: 'normal',
                                        border: '1px solid transparent',
                                        '&.Mui-selected': {
                                          background: '#d63384 !important',
                                          color: '#fff',
                                          border: 'none',
                                          width: '36px',
                                          height: '38px',
                                        },
                                      }}
                                    >
                                      {String(item.page).padStart(2, '0')}
                                    </PaginationItem>

                                    {!hideSeparator && item.page !== 6 && (
                                      <div
                                        style={{
                                          position: 'absolute',
                                          right: '-2px',
                                          top: '50%',
                                          transform: 'translateY(-50%)',
                                          height: '25%',
                                          width: '1px',
                                          backgroundColor: '#fff',
                                          zIndex: 2,
                                        }}
                                      />
                                    )}
                                  </div>
                                );
                              }}
                              sx={{
                                display: 'flex',
                                justifyContent: 'center',
                                alignItems: 'center',
                                background: 'transparent',

                                height: '40px',
                                borderRadius: '8px',
                                paddingLeft: '6px',
                                border: '1px solid #fff',
                              }}
                            />
                          </Stack>
                        </GridCol>
                      </Grid>
                    ) : (
                      !isLoading && (
                        <div className="flex flex-row items-center space-x-4 mt-4 w-auto h-[40px] px-4">
                          <Stack spacing={2}>
                            <Pagination
                              count={totalPages}
                              page={currentPage}
                              shape="rounded"
                              siblingCount={1}
                              boundaryCount={1}
                              onChange={(_, page) =>
                                handlePagination('goto', page)
                              }
                              renderItem={item => {
                                const hideSeparator =
                                  selectedPage !== null &&
                                  (item.page === selectedPage - 1 ||
                                    item.page === selectedPage);

                                // Disable previous on first page
                                if (item.type === 'previous') {
                                  return (
                                    <span
                                      {...item}
                                      className="font-productsans"
                                      style={{
                                        padding: '4px 8px',
                                        color:
                                          Number(currentPage) === 1
                                            ? '#888'
                                            : '#fff',
                                        background: 'transparent',
                                        borderRadius: '8px',
                                        cursor:
                                          Number(currentPage) === 1
                                            ? 'not-allowed'
                                            : 'pointer',
                                        fontFamily: 'sans-serif',
                                        fontSize: '13px',
                                        fontWeight: 'normal',
                                        pointerEvents:
                                          currentPage === 1 ? 'none' : 'auto',
                                      }}
                                    >
                                      {getTranslation(
                                        language,
                                        'dashboard',
                                        'Previous'
                                      )}
                                    </span>
                                  );
                                }

                                // Disable next on last page
                                if (item.type === 'next') {
                                  return (
                                    <span
                                      {...item}
                                      className="font-productsans"
                                      style={{
                                        padding: '4px 8px',
                                        color:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? '#888'
                                            : '#fff',
                                        background: 'transparent',
                                        borderRadius: '8px',
                                        cursor:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? 'not-allowed'
                                            : 'pointer',
                                        fontFamily: 'sans-serif',
                                        fontSize: '13px',
                                        fontWeight: 'normal',
                                        pointerEvents:
                                          Number(currentPage) ===
                                          Number(totalPages)
                                            ? 'none'
                                            : 'auto',
                                      }}
                                    >
                                      {getTranslation(
                                        language,
                                        'dashboard',
                                        'Next'
                                      )}
                                    </span>
                                  );
                                }

                                return (
                                  <div
                                    style={{
                                      display: 'flex',
                                      alignItems: 'center',
                                      position: 'relative',
                                    }}
                                  >
                                    <PaginationItem
                                      {...item}
                                      sx={{
                                        color: '#fff',
                                        background: 'transparent',
                                        fontSize: '14px',
                                        width: '35px',
                                        height: '35px',
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',

                                        borderRadius: '0px',
                                        fontWeight: 'normal',
                                        border: '1px solid transparent',
                                        '&.Mui-selected': {
                                          background: '#d63384 !important',
                                          color: '#fff',
                                          border: 'none',
                                          width: '36px',
                                          height: '38px',
                                        },
                                      }}
                                    >
                                      {String(item.page).padStart(2, '0')}
                                    </PaginationItem>

                                    {!hideSeparator && item.page !== 6 && (
                                      <div
                                        style={{
                                          position: 'absolute',
                                          right: '-2px',
                                          top: '50%',
                                          transform: 'translateY(-50%)',
                                          height: '25%',
                                          width: '1px',
                                          backgroundColor: '#fff',
                                          zIndex: 2,
                                        }}
                                      />
                                    )}
                                  </div>
                                );
                              }}
                              sx={{
                                display: 'flex',
                                justifyContent: 'center',
                                alignItems: 'center',
                                background: 'transparent',

                                height: '40px',
                                borderRadius: '8px',
                                paddingLeft: '6px',
                                border: '1px solid #fff',
                              }}
                            />
                          </Stack>
                        </div>
                      )
                    )}
                  </div>
                </div>
              </div>
            </div>
          </>
        )}
      </section>
    </>
  );
};

export default OnlyPagination;
