import { Grid, Skeleton } from '@mantine/core';

const SkeletonCard = () => {
  return (
    <>
      <Skeleton height={50} width="96%" radius="md" mb="xl" mt="xl" ml="xl" />

      <Grid>
        <Grid.Col span={{ base: 12, md: 6, lg: 4 }}>
          <Skeleton variant="rounded" width={210} height={60} />
        </Grid.Col>
        <Grid.Col span={{ base: 12, md: 6, lg: 4 }}>
          <Skeleton variant="rounded" width={210} height={60} />
        </Grid.Col>
        <Grid.Col span={{ base: 12, md: 6, lg: 4 }}>
          <Skeleton variant="rounded" width={210} height={60} />
        </Grid.Col>
      </Grid>
      <Grid>
        <Grid.Col span={{ base: 12, md: 6, lg: 5 }}>
          <Skeleton variant="rounded" width={210} height={200} />
        </Grid.Col>
        <Grid.Col span={{ base: 12, md: 6, lg: 7 }}>
          <Skeleton variant="rounded" width={210} height={200} />
        </Grid.Col>
      </Grid>
      <Grid>
        <Grid.Col span={{ base: 12, md: 6, lg: 5.5 }}>
          <Skeleton variant="rounded" width={210} height={200} />
        </Grid.Col>
        <Grid.Col span={{ base: 12, md: 6, lg: 6.5 }}>
          <Grid>
            <Grid.Col span={{ base: 12, md: 6, lg: 6 }}>
              <Skeleton variant="rounded" width={210} height={60} />
              <Skeleton variant="rounded" width={210} height={60} />
              <Skeleton variant="rounded" width={210} height={60} />
              <Skeleton variant="rounded" width={210} height={60} />
              <Grid.Col span={{ base: 12, md: 6, lg: 12 }}>
                <Skeleton variant="rounded" width={210} height={200} />
              </Grid.Col>
            </Grid.Col>
          </Grid>
        </Grid.Col>
      </Grid>
    </>
  );
};

export default SkeletonCard;
