import { TextInput as MantineTextInput } from '@mantine/core';
import { ChangeEvent } from 'react';

// Define the props interface with optional properties and an index signature
interface InputProps {
  radius?: string;
  label?: string;
  placeholder?: string;
  value: string | number;
  onChange?: (value: string) => void;
  [key: string]: any;
}

// Define a generic function to handle TextInput and NumberInput components
const TextInput = ({
  radius = '8px',
  label,
  placeholder,
  value,
  onChange = () => {},
  ...rest
}: InputProps) => {
  return (
    <MantineTextInput
      radius={radius}
      label={label}
      placeholder={placeholder}
      value={value}
      onChange={(event: ChangeEvent<HTMLInputElement>) =>
        onChange(event.currentTarget.value)
      }
      {...rest}
    />
  );
};
export default TextInput;
