import { useState } from 'react';

export default function EntertainerImage({ entertainer }: any) {
  const [imgError, setImgError] = useState(false);
  const profilePicture = entertainer?.profilePicture;
  const firstChar =
    entertainer?.fullNameOrBusinessName?.charAt(0)?.toUpperCase() || '?';
  const shouldShowImage = profilePicture && !imgError;

  return (
    <>
      {shouldShowImage ? (
        <div className="w-[245px] h-[180px]">
          <img
            src={profilePicture}
            alt="Entertainer"
            className="w-[360px] h-[180px] rounded-lg object-cover"
            loading="lazy"
            onError={() => setImgError(true)}
          />
        </div>
      ) : (
        <div className="w-[245px] h-[180px] px-2 rounded-lg bg-gray-300 flex items-center justify-center text-white text-6xl font-bold">
          {firstChar}
        </div>
      )}
    </>
  );
}
