# MUV-Frontend

This is the frontend application for the MUV project. It is built using React and CRA for fast development and optimal performance.

## Project Setup

To get started with the MUV-Frontend, follow the steps below:

### Prerequisites

Make sure you have the following installed:

- [Node.js](https://nodejs.org/) (v18 or higher)
- [npm](https://www.npmjs.com/) (v9 or higher)

> **Note**: It is recommended to use the latest versions of Node.js and npm to ensure compatibility with the dependencies.

### Installation

1. Clone the repository:

   ```bash
   git clone https://github.com/concave-agri/MUV-Frontend.git
   cd MUV-Frontend

2. Checkout to a feature branch from main (do not use the main branch directly for development):
   
   ```bash
   git checkout -b feature/your-feature-name

  ## Common Branch Naming Conventions:

  1. Feature Branch: feature/your-feature-name – For developing a new feature or functionality.
  2. Bug Fix Branch: fix/your-bug-fix-name – For addressing bugs or issues in the application.
  3. Improvement Branch: improvement/your-improvement-name – For improving existing features or optimizing code.
  4. Hotfix Branch: hotfix/your-hotfix-name – For urgent patches or fixes to production issues.
  5. Release Branch: release/your-release-name – For preparing and finalizing a new release before deployment.
  

3. Install the required dependencies:
    
   ```bash
   npm install -f

### Setup and Commands

1. Create a .env file in the root directory and add the necessary environment variables (refer to .env.example if available).

2. To start the project in development mode, run the following command:
   
   ```bash
   npm run start

   This will start the CRA development server at http://localhost:3000, and the app will reload automatically as you make changes. PORT is change available from CRA.config.js

3. To format the code using Prettier, run:
   
   ```bash
   npm run format

4. To build the project for production:

   ```bash
   npm run build

   This will generate an optimized production build in the dist/ folder.

## Main Dependencies

### React
The project uses **React** (v18.2.0) for building the user interface. React is a powerful JavaScript library that helps you build interactive UIs by using components.

### TypeScript
The project is written in **TypeScript** (v4.9.5), providing static typing for JavaScript. TypeScript helps to catch errors during development and provides a better developer experience with autocompletion and type-checking.

### Formik
The project uses **Formik** (v2.4.5) for managing form state. Formik simplifies form handling and validation by providing built-in support for common form operations like handling input values, validation, and form submission.

**Key Features**:
- Handling form state and validation in a concise and declarative manner.
- Support for handling complex form validation with **Yup**.

### Redux & Redux Toolkit
**Redux** (v5.0.1) and **Redux Toolkit** (v2.2.1) are used for state management. Redux helps manage the application’s global state, and Redux Toolkit simplifies working with Redux by providing tools like reducers, actions, and the store setup.

**Key Features**:
- Centralized state management for better control of app data.
- Easier dispatching of actions and accessing state in any part of the app.

### Yup
**Yup** (v1.4.0) is used for schema validation, which is integrated with Formik for validating form data. It provides a simple, declarative way to validate data, ensuring that inputs conform to the expected format.

### Mantine
**Mantine** is a modern React component library that provides a set of high-quality, fully accessible components and hooks for building user interfaces quickly and easily. The project uses **Mantine** (v7.13.3) for styling and UI components.

**Key Features**:
- A comprehensive set of UI components such as buttons, modals, tables, and form controls.
- Built-in hooks for common UI tasks like managing forms, notifications, and transitions.
- Easy theming and customization options.
- Fully accessible components that follow WCAG guidelines.
- Great documentation and community support.

**Used Mantine Packages in the Project**:
- `@mantine/core` - Core UI components (buttons, inputs, cards, etc.)
- `@mantine/dates` - Date and time-related components.
- `@mantine/dropzone` - Dropzone components for file uploads.

### Git Workflow

1. Checkout a new branch from main:

   ```bash
   git checkout -b feature/your-feature-name

2: Make your changes and commit them:

    ```bash
    git add .
    git commit -m "I am done with my fixes"

3. Push your branch to the remote repository:

   ```bash
   git push origin feature/your-feature-name

4. Create a Pull Request from your branch to main:
   
   This will guide your team members to follow a structured Git workflow when contributing to the project.

> **Note**
1. Make sure to regularly pull the latest changes from main to stay up to date.
2. Follow the branch naming conventions for easier management and collaboration.
3. Always create a Pull Request for code review before merging your changes to main


This `README.md` now includes the setup instructions, commands for development, build, and preview, as well as the Git workflow and branch naming conventions for your project.
